/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.transmission.sequencer;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.Instruction;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class SequencedGearshiftBlockEntity
extends SplitShaftBlockEntity {
    Vector<Instruction> instructions = Instruction.createDefault();
    int currentInstruction = -1;
    int currentInstructionDuration = -1;
    float currentInstructionProgress = 0.0f;
    int timer = 0;
    boolean poweredPreviously = false;
    public AbstractComputerBehaviour computerBehaviour;

    public SequencedGearshiftBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isIdle()) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.currentInstructionDuration < 0) {
            return;
        }
        if (this.timer < this.currentInstructionDuration) {
            ++this.timer;
            this.currentInstructionProgress += this.getInstruction(this.currentInstruction).getTickProgress(this.speed);
            return;
        }
        this.run(this.currentInstruction + 1);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.isIdle()) {
            return;
        }
        float currentSpeed = Math.abs(this.speed);
        if (Math.abs(previousSpeed) == currentSpeed) {
            return;
        }
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            this.run(-1);
        }
        this.currentInstructionDuration = instruction.getDuration(this.currentInstructionProgress, this.getTheoreticalSpeed());
        this.timer = 0;
    }

    public boolean isIdle() {
        return this.currentInstruction == -1;
    }

    public void onRedstoneUpdate(boolean isPowered, boolean isRunning) {
        if (this.computerBehaviour.hasAttachedComputer()) {
            return;
        }
        if (!this.poweredPreviously && isPowered) {
            this.risingFlank();
        }
        this.poweredPreviously = isPowered;
        if (!this.isIdle()) {
            return;
        }
        if (isPowered == isRunning) {
            return;
        }
        if (!this.field_11863.method_49803(this.field_11867)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.run(0);
    }

    public void risingFlank() {
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.poweredPreviously) {
            return;
        }
        this.poweredPreviously = true;
        switch (instruction.onRedstonePulse()) {
            case CONTINUE: {
                this.run(this.currentInstruction + 1);
                break;
            }
        }
    }

    public void run(int instructionIndex) {
        Instruction instruction = this.getInstruction(instructionIndex);
        if (instruction == null || instruction.instruction == SequencerInstructions.END) {
            if (this.getModifier() != 0) {
                this.detachKinetics();
            }
            this.currentInstruction = -1;
            this.currentInstructionDuration = -1;
            this.currentInstructionProgress = 0.0f;
            this.sequenceContext = null;
            this.timer = 0;
            if (!this.field_11863.method_49803(this.field_11867)) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            } else {
                this.sendData();
            }
            return;
        }
        this.detachKinetics();
        this.currentInstructionDuration = instruction.getDuration(0.0f, this.getTheoreticalSpeed());
        this.currentInstruction = instructionIndex;
        this.currentInstructionProgress = 0.0f;
        this.sequenceContext = SequenceContext.fromGearshift(instruction.instruction, this.getTheoreticalSpeed() * (float)this.getModifier(), instruction.value);
        this.timer = 0;
        this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(instructionIndex + 1)), 3);
    }

    public Instruction getInstruction(int instructionIndex) {
        return instructionIndex >= 0 && instructionIndex < this.instructions.size() ? this.instructions.get(instructionIndex) : null;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("InstructionIndex", this.currentInstruction);
        compound.method_10569("InstructionDuration", this.currentInstructionDuration);
        compound.method_10548("InstructionProgress", this.currentInstructionProgress);
        compound.method_10569("Timer", this.timer);
        compound.method_10556("PrevPowered", this.poweredPreviously);
        compound.method_10566("Instructions", (class_2520)Instruction.serializeAll(this.instructions));
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.currentInstruction = compound.method_10550("InstructionIndex");
        this.currentInstructionDuration = compound.method_10550("InstructionDuration");
        this.currentInstructionProgress = compound.method_10583("InstructionProgress");
        this.poweredPreviously = compound.method_10577("PrevPowered");
        this.timer = compound.method_10550("Timer");
        this.instructions = Instruction.deserializeAll(compound.method_10554("Instructions", 10));
        super.read(compound, clientPacket);
    }

    @Override
    public float getRotationSpeedModifier(class_2350 face) {
        if (this.isVirtual()) {
            return 1.0f;
        }
        return !this.hasSource() || face == this.getSourceFacing() ? 1.0f : (float)this.getModifier();
    }

    public int getModifier() {
        if (this.currentInstruction >= this.instructions.size()) {
            return 0;
        }
        return this.isIdle() ? 0 : this.instructions.get(this.currentInstruction).getSpeedModifier();
    }

    public Vector<Instruction> getInstructions() {
        return this.instructions;
    }

    public record SequenceContext(SequencerInstructions instruction, double relativeValue) {
        public static SequenceContext fromGearshift(SequencerInstructions instruction, double kineticSpeed, int absoluteValue) {
            return instruction.needsPropagation() ? new SequenceContext(instruction, kineticSpeed == 0.0 ? 0.0 : (double)absoluteValue / kineticSpeed) : null;
        }

        public double getEffectiveValue(double speedAtTarget) {
            return Math.abs(this.relativeValue * speedAtTarget);
        }

        public class_2487 serializeNBT() {
            class_2487 nbt = new class_2487();
            NBTHelper.writeEnum(nbt, "Mode", this.instruction);
            nbt.method_10549("Value", this.relativeValue);
            return nbt;
        }

        public static SequenceContext fromNBT(class_2487 nbt) {
            if (nbt.method_33133()) {
                return null;
            }
            return new SequenceContext(NBTHelper.readEnum(nbt, "Mode", SequencerInstructions.class), nbt.method_10574("Value"));
        }
    }
}

