/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.crate;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class BottomlessItemHandler
extends ItemStackHandler
implements SingleSlotStorage<ItemVariant> {
    private Supplier<class_1799> suppliedItemStack;

    public BottomlessItemHandler(Supplier<class_1799> suppliedItemStack) {
        super(0);
        this.suppliedItemStack = suppliedItemStack;
        this.setSize(1);
    }

    protected ItemStackHandlerSlot makeSlot(int index, class_1799 stack) {
        return new BottomlessSlot();
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return maxAmount;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        class_1799 stack = this.getStack();
        if (!resource.matches(stack)) {
            return 0L;
        }
        if (!stack.method_7960()) {
            return Math.min((long)stack.method_7914(), maxAmount);
        }
        return 0L;
    }

    protected class_1799 getStack() {
        class_1799 stack = this.suppliedItemStack.get();
        return stack == null || stack.method_7960() ? class_1799.field_8037 : stack;
    }

    public boolean isResourceBlank() {
        return this.getStack().method_7960();
    }

    public ItemVariant getResource() {
        return ItemVariant.of((class_1799)this.getStack());
    }

    public long getAmount() {
        return Long.MAX_VALUE;
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return super.iterator();
    }

    public Iterable<StorageView<ItemVariant>> nonEmptyViews() {
        return this::nonEmptyIterator;
    }

    public Iterator<StorageView<ItemVariant>> nonEmptyIterator() {
        return this.isResourceBlank() ? Collections.emptyIterator() : this.iterator();
    }

    private class BottomlessSlot
    extends ItemStackHandlerSlot {
        public BottomlessSlot() {
            super(0, (ItemStackHandler)BottomlessItemHandler.this, class_1799.field_8037);
        }

        public class_1799 getStack() {
            return BottomlessItemHandler.this.getStack();
        }

        public ItemVariant getResource() {
            return BottomlessItemHandler.this.getResource();
        }

        public long getAmount() {
            return BottomlessItemHandler.this.getAmount();
        }

        protected void setStack(class_1799 stack) {
        }

        @Nullable
        public class_2487 save() {
            return null;
        }

        protected void onFinalCommit() {
        }
    }
}

