/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.content.trains.bogey.BogeyInstance;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntityRenderer;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_4587;
import org.joml.Vector3f;

public class CarriageContraptionInstance
extends EntityInstance<CarriageContraptionEntity>
implements DynamicInstance {
    private final class_4587 ms = new class_4587();
    private Carriage carriage;
    private Couple<BogeyInstance> bogeys;
    private Couple<Boolean> bogeyHidden = Couple.create(() -> false);

    public CarriageContraptionInstance(MaterialManager materialManager, CarriageContraptionEntity entity) {
        super(materialManager, (class_1297)entity);
        entity.bindInstance(this);
    }

    public void init() {
        this.carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        if (this.carriage == null) {
            return;
        }
        this.bogeys = this.carriage.bogeys.mapNotNullWithParam((bogey, manager) -> bogey.getStyle().createInstance((CarriageBogey)bogey, bogey.type.getSize(), (MaterialManager)manager), this.materialManager);
        this.updateLight();
    }

    public void setBogeyVisibility(boolean first, boolean visible) {
        this.bogeyHidden.set(first, !visible);
    }

    public void beginFrame() {
        if (this.bogeys == null) {
            if (((CarriageContraptionEntity)this.entity).isReadyForRender()) {
                this.init();
            }
            if (this.bogeys == null) {
                return;
            }
        }
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float viewYRot = ((CarriageContraptionEntity)this.entity).method_5705(partialTicks);
        float viewXRot = ((CarriageContraptionEntity)this.entity).method_5695(partialTicks);
        int bogeySpacing = this.carriage.bogeySpacing;
        this.ms.method_22903();
        Vector3f instancePosition = this.getInstancePosition(partialTicks);
        TransformStack.cast((class_4587)this.ms).translate(instancePosition);
        for (boolean current : Iterate.trueAndFalse) {
            BogeyInstance instance = this.bogeys.get(current);
            if (instance == null) continue;
            if (this.bogeyHidden.get(current).booleanValue()) {
                instance.beginFrame(0.0f, null);
                continue;
            }
            this.ms.method_22903();
            CarriageBogey bogey = instance.bogey;
            CarriageContraptionEntityRenderer.translateBogey(this.ms, bogey, bogeySpacing, viewYRot, viewXRot, partialTicks);
            this.ms.method_22904(0.0, -1.5078125, 0.0);
            instance.beginFrame(bogey.wheelAngle.getValue(partialTicks), this.ms);
            this.ms.method_22909();
        }
        this.ms.method_22909();
    }

    public void updateLight() {
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(instance -> {
            if (instance != null) {
                instance.updateLight((class_1920)this.world, (CarriageContraptionEntity)this.entity);
            }
        });
    }

    public void remove() {
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(instance -> {
            if (instance != null) {
                instance.commonRenderer.ifPresent(BogeyRenderer::remove);
                instance.renderer.remove();
            }
        });
    }

    public boolean decreaseFramerateWithDistance() {
        return false;
    }
}

