/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.model;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.ModelAnimator;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.tabula.TabulaCubeContainer;
import com.iafenvoy.uranus.client.model.tabula.TabulaCubeGroupContainer;
import com.iafenvoy.uranus.client.model.tabula.TabulaModelContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;

@Environment(value=EnvType.CLIENT)
public class TabulaModel
extends AdvancedEntityModel {
    public final ModelAnimator animator;
    protected final Map<String, AdvancedModelBox> cubes = new HashMap<String, AdvancedModelBox>();
    protected final List<AdvancedModelBox> rootBoxes = new ArrayList<AdvancedModelBox>();
    protected final ITabulaModelAnimator tabulaAnimator;
    protected final Map<String, AdvancedModelBox> identifierMap = new HashMap<String, AdvancedModelBox>();
    protected final double[] scale;

    public TabulaModel(TabulaModelContainer container, ITabulaModelAnimator tabulaAnimator) {
        this.texWidth = container.getTextureWidth();
        this.texHeight = container.getTextureHeight();
        this.tabulaAnimator = tabulaAnimator;
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
        this.updateDefaultPose();
        this.scale = container.getScale();
        this.animator = ModelAnimator.create();
    }

    public TabulaModel(TabulaModelContainer container) {
        this(container, null);
    }

    private void parseCubeGroup(TabulaCubeGroupContainer container) {
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
    }

    private void parseCube(TabulaCubeContainer cube, AdvancedModelBox parent) {
        AdvancedModelBox box = this.createBox(cube);
        this.cubes.put(cube.getName(), box);
        this.identifierMap.put(cube.getIdentifier(), box);
        if (parent != null) {
            parent.addChild(box);
        } else {
            this.rootBoxes.add(box);
        }
        for (TabulaCubeContainer child : cube.getChildren()) {
            this.parseCube(child, box);
        }
    }

    private AdvancedModelBox createBox(TabulaCubeContainer cube) {
        int[] textureOffset = cube.getTextureOffset();
        double[] position = cube.getPosition();
        double[] rotation = cube.getRotation();
        double[] offset = cube.getOffset();
        int[] dimensions = cube.getDimensions();
        float scaleIn = 0.0f;
        AdvancedModelBox box = new AdvancedModelBox(this, cube.getName());
        box.setTextureOffset(textureOffset[0], textureOffset[1]);
        box.mirror = cube.isTextureMirrorEnabled();
        box.setPos((float)position[0], (float)position[1], (float)position[2]);
        box.addBox((float)offset[0], (float)offset[1], (float)offset[2], (float)dimensions[0], (float)dimensions[1], (float)dimensions[2], scaleIn);
        box.rotateAngleX = (float)Math.toRadians(rotation[0]);
        box.rotateAngleY = (float)Math.toRadians(rotation[1]);
        box.rotateAngleZ = (float)Math.toRadians(rotation[2]);
        return box;
    }

    @Override
    public void method_2819(class_1297 entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (this.tabulaAnimator != null) {
            this.tabulaAnimator.setRotationAngles(this, entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch, 1.0f);
        }
    }

    public AdvancedModelBox getCube(String name) {
        return this.cubes.get(name);
    }

    public Map<String, AdvancedModelBox> getCubes() {
        return this.cubes;
    }

    @Override
    public Iterable<BasicModelPart> parts() {
        return ImmutableList.copyOf(this.rootBoxes);
    }

    @Override
    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.copyOf(this.cubes.values());
    }
}

