/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.model.util;

import com.iafenvoy.uranus.Uranus;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.TabulaModelHandler;
import com.iafenvoy.uranus.client.model.tabula.TabulaModelContainer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.loader.api.FabricLoader;

public class TabulaModelHandlerHelper {
    private static TabulaModel getOrNull(String modelPath, ITabulaModelAnimator<?> tabulaAnimator) {
        try {
            return new TabulaModel(TabulaModelHandlerHelper.loadTabulaModel(modelPath), tabulaAnimator);
        }
        catch (IOException e) {
            Uranus.LOGGER.error((Object)e);
            return null;
        }
    }

    public static TabulaModelContainer loadTabulaModel(String path) throws IOException {
        InputStream stream;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith(".tbl")) {
            path = (String)path + ".tbl";
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            if (!((String)path).startsWith(".")) {
                path = "." + (String)path;
            }
            stream = new FileInputStream((String)path);
        } else {
            stream = TabulaModelHandlerHelper.class.getResourceAsStream((String)path);
        }
        return TabulaModelHandler.INSTANCE.loadTabulaModel(TabulaModelHandlerHelper.getModelJsonStream((String)path, stream));
    }

    private static InputStream getModelJsonStream(String name, InputStream file) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(file);
        do {
            if ((entry = zip.getNextEntry()) != null) continue;
            throw new RuntimeException("No model.json present in " + name);
        } while (!entry.getName().equals("model.json"));
        return zip;
    }
}

