/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.render;

import com.iafenvoy.uranus.client.render.EntityRendererBase;
import java.util.HashMap;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_5617;

public enum Stage {
    Zero(0),
    First(1),
    Second(2),
    Third(3),
    Forth(4),
    Fifth(5),
    Sixth(6);

    private final int index;

    private Stage(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public static Stage getByIndex(int index) {
        for (Stage s : Stage.values()) {
            if (s.index != index) continue;
            return s;
        }
        return Zero;
    }

    public static StagedEntityTextureProvider ofProvider(String modId, String ... textures) {
        return new StagedEntityTextureProvider(modId, textures);
    }

    public static class StagedEntityTextureProvider {
        private final String modId;
        private final HashMap<Stage, String> textureIds = new HashMap();
        private String eyeTextureId = null;

        public StagedEntityTextureProvider(String modId, String ... textures) {
            this.modId = modId;
            Stage[] stages = Stage.values();
            for (int i = 0; i < stages.length - 1 && i < textures.length; ++i) {
                this.textureIds.put(stages[i + 1], textures[i]);
            }
        }

        public StagedEntityTextureProvider setEyeTextureId(String eyeTextureId) {
            this.eyeTextureId = eyeTextureId;
            return this;
        }

        public class_2960 getTexture() {
            return this.getTexture(First);
        }

        public class_2960 getTexture(Stage stage) {
            return new class_2960(this.modId, "textures/entities/" + this.getTextureId(stage) + ".png");
        }

        private String getTextureId(Stage stage) {
            if (this.textureIds.containsKey((Object)stage)) {
                return this.textureIds.get((Object)stage);
            }
            if (this.textureIds.size() == 0) {
                return "";
            }
            return this.textureIds.get((Object)First);
        }

        public <T extends class_1308> EntityRendererBase<T> createRenderer(class_5617.class_5618 context) {
            if (this.eyeTextureId == null) {
                return new EntityRendererBase(context, this, null);
            }
            return new EntityRendererBase(context, this, new class_2960(this.modId, this.eyeTextureId));
        }
    }

    public static interface StagedEntity {
        public Stage getStage();
    }
}

