/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.tick;

import com.iafenvoy.uranus.server.tick.TickRateTracker;
import com.iafenvoy.uranus.server.tick.modifier.TickRateModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientTickRateTracker
extends TickRateTracker {
    public static final Logger LOGGER = LogManager.getLogger((String)"uranus-client-tick");
    private static final Map<class_310, ClientTickRateTracker> dataMap = new HashMap<class_310, ClientTickRateTracker>();
    private static final float MS_PER_TICK = 50.0f;
    public final class_310 client;

    public ClientTickRateTracker(class_310 client) {
        this.client = client;
    }

    public static ClientTickRateTracker getForClient(class_310 minecraft) {
        if (!dataMap.containsKey(minecraft)) {
            ClientTickRateTracker tracker = new ClientTickRateTracker(minecraft);
            dataMap.put(minecraft, tracker);
            return tracker;
        }
        return dataMap.get(minecraft);
    }

    public void syncFromServer(class_2487 tag) {
        this.tickRateModifierList.clear();
        this.fromTag(tag);
    }

    @Override
    public void masterTick() {
        super.masterTick();
        this.client.field_1728.field_1968 = this.getClientTickRate();
    }

    public float getClientTickRate() {
        float f = 50.0f;
        for (TickRateModifier modifier : this.tickRateModifierList) {
            assert (class_310.method_1551().field_1724 != null);
            if (!modifier.appliesTo((class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_23317(), class_310.method_1551().field_1724.method_23318(), class_310.method_1551().field_1724.method_23321())) continue;
            f *= modifier.getTickRateMultiplier();
        }
        return Math.max(1.0f, f * this.getEntityTickLengthModifier((class_1297)class_310.method_1551().field_1724));
    }

    public float modifySoundPitch(class_1113 soundInstance) {
        float f = 1.0f;
        for (TickRateModifier modifier : this.tickRateModifierList) {
            assert (class_310.method_1551().field_1724 != null);
            if (!modifier.appliesTo((class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_23317(), class_310.method_1551().field_1724.method_23318(), class_310.method_1551().field_1724.method_23321())) continue;
            f /= modifier.getTickRateMultiplier();
        }
        return Math.max(1.0f, f * this.getEntityTickLengthModifier((class_1297)class_310.method_1551().field_1724));
    }

    @Override
    public void tickEntityAtCustomRate(class_1297 entity) {
        class_1937 class_19372;
        if (entity.method_37908().field_9236 && (class_19372 = entity.method_37908()) instanceof class_638) {
            class_638 clientWorld = (class_638)class_19372;
            clientWorld.method_18646(entity);
        }
    }
}

