/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.server.tick;

import com.iafenvoy.uranus.server.tick.modifier.TickRateModifier;
import com.iafenvoy.uranus.server.tick.modifier.TickRateModifierType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public abstract class TickRateTracker {
    public final List<TickRateModifier> tickRateModifierList = new ArrayList<TickRateModifier>();
    public final List<class_1297> specialTickRateEntities = new ArrayList<class_1297>();
    private long masterTickCount;

    public void masterTick() {
        ++this.masterTickCount;
        this.specialTickRateEntities.forEach(this::tickBlockedEntity);
        this.specialTickRateEntities.removeIf(this::hasNormalTickRate);
        for (TickRateModifier modifier : this.tickRateModifierList) {
            modifier.masterTick();
        }
        if (!this.tickRateModifierList.isEmpty() && this.tickRateModifierList.removeIf(TickRateModifier::doRemove)) {
            this.sync();
        }
    }

    protected void sync() {
    }

    public boolean hasModifiersActive() {
        return !this.tickRateModifierList.isEmpty();
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        for (TickRateModifier modifier : this.tickRateModifierList) {
            if (modifier.doRemove()) continue;
            list.add((Object)modifier.toTag());
        }
        tag.method_10566("TickRateModifiers", (class_2520)list);
        return tag;
    }

    public void fromTag(class_2487 tag) {
        if (tag.method_10545("TickRateModifiers")) {
            class_2499 list = tag.method_10554("TickRateModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 tag1 = list.method_10602(i);
                TickRateModifier modifier = TickRateModifier.fromTag(tag1);
                assert (modifier != null);
                if (modifier.doRemove()) continue;
                this.tickRateModifierList.add(modifier);
            }
        }
    }

    public long getDayTimeIncrement(long timeIn) {
        float f = 1.0f;
        for (TickRateModifier modifier : this.tickRateModifierList) {
            if (modifier.getType() != TickRateModifierType.CELESTIAL) continue;
            f *= modifier.getTickRateMultiplier();
        }
        if (f < 1.0f && f > 0.0f) {
            int inverse = (int)(1.0f / f);
            return this.masterTickCount % (long)inverse == 0L ? timeIn : 0L;
        }
        return (long)((float)timeIn * f);
    }

    public float getEntityTickLengthModifier(class_1297 entity) {
        float f = 1.0f;
        for (TickRateModifier modifier : this.tickRateModifierList) {
            if (!modifier.getType().isLocal() || !modifier.appliesTo(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321())) continue;
            f *= modifier.getTickRateMultiplier();
        }
        return f;
    }

    public boolean hasNormalTickRate(class_1297 entity) {
        return this.getEntityTickLengthModifier(entity) == 1.0f;
    }

    public boolean isTickingHandled(class_1297 entity) {
        return this.specialTickRateEntities.contains(entity);
    }

    public void addTickBlockedEntity(class_1297 entity) {
        if (!this.isTickingHandled(entity)) {
            this.specialTickRateEntities.add(entity);
        }
    }

    protected void tickBlockedEntity(class_1297 entity) {
        this.tickEntityAtCustomRate(entity);
    }

    protected abstract void tickEntityAtCustomRate(class_1297 var1);
}

