/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.server.tick.modifier;

import com.iafenvoy.uranus.server.tick.modifier.TickRateModifierType;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

public abstract class TickRateModifier {
    private final TickRateModifierType type;
    private float maxDuration;
    private float duration;
    private float tickRateMultiplier;

    public TickRateModifier(TickRateModifierType type, int maxDuration, float tickRateMultiplier) {
        this.type = type;
        this.maxDuration = maxDuration;
        this.tickRateMultiplier = tickRateMultiplier;
    }

    public TickRateModifier(class_2487 tag) {
        this.type = TickRateModifierType.fromId(tag.method_10550("TickRateType"));
        this.maxDuration = tag.method_10583("MaxDuration");
        this.duration = tag.method_10583("Duration");
        this.tickRateMultiplier = tag.method_10583("SpeedMultiplier");
    }

    public static TickRateModifier fromTag(class_2487 tag) {
        TickRateModifierType typeFromNbt = TickRateModifierType.fromId(tag.method_10550("TickRateType"));
        try {
            return typeFromNbt.getTickRateClass().getConstructor(class_2487.class).newInstance(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TickRateModifierType getType() {
        return this.type;
    }

    public float getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(float maxDuration) {
        this.maxDuration = maxDuration;
    }

    public float getTickRateMultiplier() {
        return this.tickRateMultiplier;
    }

    public void setTickRateMultiplier(float tickRateMultiplier) {
        this.tickRateMultiplier = tickRateMultiplier;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("TickRateType", this.type.toId());
        tag.method_10548("MaxDuration", this.maxDuration);
        tag.method_10548("Duration", this.duration);
        tag.method_10548("SpeedMultiplier", this.tickRateMultiplier);
        return tag;
    }

    public boolean isGlobal() {
        return this.type.isLocal();
    }

    public void masterTick() {
        this.duration += 1.0f;
    }

    public boolean doRemove() {
        float f = this.tickRateMultiplier == 0.0f || this.getType() == TickRateModifierType.CELESTIAL ? 1.0f : 1.0f / this.tickRateMultiplier;
        return this.duration >= this.maxDuration * f;
    }

    public abstract boolean appliesTo(class_1937 var1, double var2, double var4, double var6);
}

