/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base.tag_utils;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class TypeAndTagDataHolder<TYPE, VALUE> {
    protected final Map<TYPE, VALUE> tagData = new Reference2ObjectOpenHashMap();
    protected final Map<TYPE, VALUE> typeData = new Reference2ObjectOpenHashMap();
    protected final Map<class_6862<TYPE>, VALUE> tagsToEvaluate = new Object2ObjectLinkedOpenHashMap();
    protected final class_2378<TYPE> registry;

    public TypeAndTagDataHolder(class_2378<TYPE> registry) {
        this.registry = registry;
    }

    public void addTagData(class_6862<TYPE> tag, VALUE value) {
        this.tagsToEvaluate.put(tag, value);
    }

    public void addData(TYPE type, VALUE value) {
        this.typeData.put(type, value);
    }

    public void cleanUp() {
        this.tagData.clear();
        this.typeData.clear();
        this.tagsToEvaluate.clear();
    }

    public void cleanUpTags() {
        this.tagData.clear();
    }

    public void loadTags() {
        this.tagData.clear();
        for (Map.Entry<class_6862<TYPE>, VALUE> entry : this.tagsToEvaluate.entrySet()) {
            VALUE properties = entry.getValue();
            for (class_6880 holder : this.registry.method_40286(entry.getKey())) {
                this.tagData.put(holder.comp_349(), properties);
            }
        }
    }

    @Nullable
    public VALUE getData(TYPE type) {
        if (this.typeData.containsKey(type)) {
            return this.typeData.get(type);
        }
        if (this.tagData.containsKey(type)) {
            return this.tagData.get(type);
        }
        return null;
    }

    public void writeToNetwork(class_2540 buf, BiConsumer<class_2540, VALUE> consumer) {
        class_2960 key;
        buf.method_10804(this.typeData.size());
        for (Map.Entry<TYPE, VALUE> entry : this.typeData.entrySet()) {
            key = this.registry.method_10221(entry.getKey());
            buf.writeBoolean(key != null);
            if (key == null) continue;
            buf.method_10812(key);
            consumer.accept(buf, entry.getValue());
        }
        buf.method_10804(this.tagData.size());
        for (Map.Entry<TYPE, VALUE> entry : this.tagData.entrySet()) {
            key = this.registry.method_10221(entry.getKey());
            buf.writeBoolean(key != null);
            if (key == null) continue;
            buf.method_10812(key);
            consumer.accept(buf, entry.getValue());
        }
    }

    public void readFromNetwork(class_2540 buf, Function<class_2540, VALUE> consumer) {
        this.cleanUp();
        int typeSize = buf.method_10816();
        for (int i = 0; i < typeSize; ++i) {
            if (!buf.readBoolean()) continue;
            class_2960 location = buf.method_10810();
            Object type = this.registry.method_10223(location);
            VALUE value = consumer.apply(buf);
            if (type == null) continue;
            this.typeData.put(type, value);
        }
        int tagSize = buf.method_10816();
        for (int i = 0; i < tagSize; ++i) {
            if (!buf.readBoolean()) continue;
            class_2960 location = buf.method_10810();
            Object type = this.registry.method_10223(location);
            VALUE value = consumer.apply(buf);
            if (type == null) continue;
            this.tagData.put(type, value);
        }
    }
}

