/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.compat.rei;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import rbasamoyai.createbigcannons.compat.rei.CBCDisplay;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;

public abstract class CBCBlockRecipeCategory<T extends BlockRecipe>
implements DisplayCategory<CBCDisplay<T>> {
    protected final CategoryIdentifier<CBCDisplay<T>> type;
    protected final class_2561 title;
    protected final Renderer background;
    protected final Renderer icon;
    private final Supplier<List<T>> recipes;
    private final List<Supplier<? extends class_1799>> catalysts;
    private final int width;
    private final int height;
    private final Function<T, ? extends CBCDisplay<T>> displayFactory;

    public CBCBlockRecipeCategory(Info<T> info) {
        this.type = info.recipeType();
        this.title = info.title();
        this.background = info.background();
        this.icon = info.icon();
        this.recipes = info.recipes();
        this.catalysts = info.catalysts();
        this.width = info.width();
        this.height = info.height();
        this.displayFactory = info.displayFactory();
    }

    public CategoryIdentifier<CBCDisplay<T>> getCategoryIdentifier() {
        return this.type;
    }

    public void registerRecipes(DisplayRegistry registry) {
        for (BlockRecipe recipe : this.recipes.get()) {
            registry.add((Display)this.displayFactory.apply(recipe), (Object)recipe);
        }
    }

    public void registerCatalysts(CategoryRegistry registry) {
        this.catalysts.forEach(s -> registry.addWorkstations(this.type, new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)((class_1799)s.get()))}));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public int getDisplayWidth(CBCDisplay<T> display) {
        return this.width;
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public static AllGuiTextures getRenderedSlot(class_1860<?> recipe, int index) {
        AllGuiTextures jeiSlot = AllGuiTextures.JEI_SLOT;
        if (!(recipe instanceof ProcessingRecipe)) {
            return jeiSlot;
        }
        ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
        List rollableResults = processingRecipe.getRollableResults();
        if (rollableResults.size() <= index) {
            return jeiSlot;
        }
        if (((ProcessingOutput)processingRecipe.getRollableResults().get(index)).getChance() == 1.0f) {
            return jeiSlot;
        }
        return AllGuiTextures.JEI_CHANCE_SLOT;
    }

    public void addWidgets(CBCDisplay<T> display, List<Widget> ingredients, Point origin) {
    }

    public void addWidgets(CBCDisplay<T> display, List<Widget> ingredients, Point origin, Rectangle bounds) {
    }

    public List<Widget> setupDisplay(CBCDisplay<T> display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, partialTick) -> {
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416((float)bounds.getX(), (float)(bounds.getY() + 4), 0.0f);
            this.draw(display.getRecipe(), graphics, mouseX, mouseY);
            this.draw(display.getRecipe(), display, graphics, mouseX, mouseY);
            poseStack.method_22909();
        }));
        this.addWidgets(display, widgets, new Point(bounds.getX(), bounds.getY() + 4));
        this.addWidgets(display, widgets, new Point(bounds.getX(), bounds.getY() + 4), bounds);
        return widgets;
    }

    public void draw(T recipe, class_332 graphics, double mouseX, double mouseY) {
    }

    public void draw(T recipe, CBCDisplay<T> display, class_332 graphics, double mouseX, double mouseY) {
    }

    public record Info<T extends BlockRecipe>(CategoryIdentifier<CBCDisplay<T>> recipeType, class_2561 title, Renderer background, Renderer icon, Supplier<List<T>> recipes, List<Supplier<? extends class_1799>> catalysts, int width, int height, Function<T, ? extends CBCDisplay<T>> displayFactory) {
    }

    public static interface Factory<T extends BlockRecipe> {
        public CBCBlockRecipeCategory<T> create(Info<T> var1);
    }
}

