/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.datagen.CBCDatagenCommon;
import rbasamoyai.createbigcannons.datagen.recipes.BlockRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.FinishedBlockRecipe;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class CannonCastRecipeProvider
extends BlockRecipeProvider {
    CannonCastRecipeProvider(class_7784 output) {
        this("createbigcannons", output);
    }

    public CannonCastRecipeProvider(String modid, class_7784 output) {
        super(modid, output);
        this.info = CreateBigCannons.resource("cannon_casting");
    }

    @Override
    protected void registerRecipes(Consumer<FinishedBlockRecipe> cons) {
        class_6862<class_3611> castIronTag = CannonCastRecipeProvider.fluidTag("molten_cast_iron");
        this.builder("unbored_cast_iron_cannon_barrel").castingShape(CannonCastShape.VERY_SMALL).ingredient(castIronTag).result((class_2248)CBCBlocks.UNBORED_CAST_IRON_CANNON_BARREL.get()).save(cons);
        this.builder("unbored_cast_iron_cannon_chamber").castingShape(CannonCastShape.MEDIUM).ingredient(castIronTag).result((class_2248)CBCBlocks.UNBORED_CAST_IRON_CANNON_CHAMBER.get()).save(cons);
        this.builder("cast_iron_cannon_end").castingShape(CannonCastShape.CANNON_END).ingredient(castIronTag).result((class_2248)CBCBlocks.CAST_IRON_CANNON_END.get()).save(cons);
        this.builder("unbored_cast_iron_sliding_breech").castingShape(CannonCastShape.SLIDING_BREECH).ingredient(castIronTag).result((class_2248)CBCBlocks.UNBORED_CAST_IRON_SLIDING_BREECH.get()).save(cons);
        class_6862<class_3611> bronzeTag = CannonCastRecipeProvider.fluidTag("molten_bronze");
        this.builder("unbored_bronze_cannon_barrel").castingShape(CannonCastShape.VERY_SMALL).ingredient(bronzeTag).result((class_2248)CBCBlocks.UNBORED_BRONZE_CANNON_BARREL.get()).save(cons);
        this.builder("unbored_bronze_cannon_chamber").castingShape(CannonCastShape.MEDIUM).ingredient(bronzeTag).result((class_2248)CBCBlocks.UNBORED_BRONZE_CANNON_CHAMBER.get()).save(cons);
        this.builder("bronze_cannon_end").castingShape(CannonCastShape.CANNON_END).ingredient(bronzeTag).result((class_2248)CBCBlocks.BRONZE_CANNON_END.get()).save(cons);
        this.builder("unbored_bronze_sliding_breech").castingShape(CannonCastShape.SLIDING_BREECH).ingredient(bronzeTag).result((class_2248)CBCBlocks.UNBORED_BRONZE_SLIDING_BREECH.get()).save(cons);
        class_6862<class_3611> steelTag = CannonCastRecipeProvider.fluidTag("molten_steel");
        this.builder("unbored_very_small_steel_cannon_layer").castingShape(CannonCastShape.VERY_SMALL).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_VERY_SMALL_STEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_small_steel_cannon_layer").castingShape(CannonCastShape.SMALL).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_SMALL_STEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_medium_steel_cannon_layer").castingShape(CannonCastShape.MEDIUM).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_MEDIUM_STEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_large_steel_cannon_layer").castingShape(CannonCastShape.LARGE).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_LARGE_STEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_very_large_steel_cannon_layer").castingShape(CannonCastShape.VERY_LARGE).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_VERY_LARGE_STEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_steel_sliding_breech").castingShape(CannonCastShape.SLIDING_BREECH).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_STEEL_SLIDING_BREECH.get()).save(cons);
        this.builder("unbored_steel_screw_breech").castingShape(CannonCastShape.SCREW_BREECH).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_STEEL_SCREW_BREECH.get()).save(cons);
        class_6862<class_3611> nethersteelTag = CannonCastRecipeProvider.fluidTag("molten_nethersteel");
        this.builder("unbored_very_small_nethersteel_cannon_layer").castingShape(CannonCastShape.VERY_SMALL).ingredient(nethersteelTag).result((class_2248)CBCBlocks.UNBORED_VERY_SMALL_NETHERSTEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_small_nethersteel_cannon_layer").castingShape(CannonCastShape.SMALL).ingredient(nethersteelTag).result((class_2248)CBCBlocks.UNBORED_SMALL_NETHERSTEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_medium_nethersteel_cannon_layer").castingShape(CannonCastShape.MEDIUM).ingredient(nethersteelTag).result((class_2248)CBCBlocks.UNBORED_MEDIUM_NETHERSTEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_large_nethersteel_cannon_layer").castingShape(CannonCastShape.LARGE).ingredient(nethersteelTag).result((class_2248)CBCBlocks.UNBORED_LARGE_NETHERSTEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_very_large_nethersteel_cannon_layer").castingShape(CannonCastShape.VERY_LARGE).ingredient(nethersteelTag).result((class_2248)CBCBlocks.UNBORED_VERY_LARGE_NETHERSTEEL_CANNON_LAYER.get()).save(cons);
        this.builder("unbored_nethersteel_screw_breech").castingShape(CannonCastShape.SCREW_BREECH).ingredient(nethersteelTag).result((class_2248)CBCBlocks.UNBORED_NETHERSTEEL_SCREW_BREECH.get()).save(cons);
        this.builder("unbored_cast_iron_autocannon_breech").castingShape(CannonCastShape.AUTOCANNON_BREECH).ingredient(castIronTag).result((class_2248)CBCBlocks.UNBORED_CAST_IRON_AUTOCANNON_BREECH.get()).save(cons);
        this.builder("unbored_cast_iron_autocannon_recoil_spring").castingShape(CannonCastShape.AUTOCANNON_RECOIL_SPRING).ingredient(castIronTag).result((class_2248)CBCBlocks.UNBORED_CAST_IRON_AUTOCANNON_RECOIL_SPRING.get()).save(cons);
        this.builder("unbored_cast_iron_autocannon_barrel").castingShape(CannonCastShape.AUTOCANNON_BARREL).ingredient(castIronTag).result((class_2248)CBCBlocks.UNBORED_CAST_IRON_AUTOCANNON_BARREL.get()).save(cons);
        this.builder("unbored_bronze_autocannon_breech").castingShape(CannonCastShape.AUTOCANNON_BREECH).ingredient(bronzeTag).result((class_2248)CBCBlocks.UNBORED_BRONZE_AUTOCANNON_BREECH.get()).save(cons);
        this.builder("unbored_bronze_autocannon_recoil_spring").castingShape(CannonCastShape.AUTOCANNON_RECOIL_SPRING).ingredient(bronzeTag).result((class_2248)CBCBlocks.UNBORED_BRONZE_AUTOCANNON_RECOIL_SPRING.get()).save(cons);
        this.builder("unbored_bronze_autocannon_barrel").castingShape(CannonCastShape.AUTOCANNON_BARREL).ingredient(bronzeTag).result((class_2248)CBCBlocks.UNBORED_BRONZE_AUTOCANNON_BARREL.get()).save(cons);
        this.builder("unbored_steel_autocannon_breech").castingShape(CannonCastShape.AUTOCANNON_BREECH).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_STEEL_AUTOCANNON_BREECH.get()).save(cons);
        this.builder("unbored_steel_autocannon_recoil_spring").castingShape(CannonCastShape.AUTOCANNON_RECOIL_SPRING).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_STEEL_AUTOCANNON_RECOIL_SPRING.get()).save(cons);
        this.builder("unbored_steel_autocannon_barrel").castingShape(CannonCastShape.AUTOCANNON_BARREL).ingredient(steelTag).result((class_2248)CBCBlocks.UNBORED_STEEL_AUTOCANNON_BARREL.get()).save(cons);
    }

    protected Builder builder(String name) {
        return new Builder(name);
    }

    private static class_6862<class_3611> fluidTag(String path) {
        return class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)new class_2960(CBCDatagenCommon.PLATFORM.tagNamespace(), path));
    }

    private class Builder {
        private final class_2960 id;
        private CannonCastShape shape = null;
        private FluidIngredient ingredient = null;
        private class_2248 result = null;

        private Builder(String name) {
            this.id = CBCUtils.location(CannonCastRecipeProvider.this.modid, name);
        }

        public Builder castingShape(CannonCastShape shape) {
            this.shape = shape;
            return this;
        }

        public Builder ingredient(class_3611 ingredient) {
            this.ingredient = IndexPlatform.fluidIngredientFrom(ingredient, 1);
            return this;
        }

        public Builder ingredient(class_6862<class_3611> ingredient) {
            this.ingredient = IndexPlatform.fluidIngredientFrom(ingredient, 1);
            return this;
        }

        public Builder result(class_2248 result) {
            this.result = result;
            return this;
        }

        public void save(Consumer<FinishedBlockRecipe> cons) {
            Objects.requireNonNull(this.shape, "Recipe " + this.id + " has no casting shape specified");
            Objects.requireNonNull(this.ingredient, "Recipe " + this.id + " has no fluid ingredient specified");
            Objects.requireNonNull(this.result, "Recipe " + this.id + " has no result specified");
            cons.accept(new Result(this.shape, this.ingredient, this.result, this.id));
        }
    }

    private static class Result
    implements FinishedBlockRecipe {
        private final class_2960 id;
        private final CannonCastShape shape;
        private final FluidIngredient ingredient;
        private final class_2248 result;

        public Result(CannonCastShape shape, FluidIngredient ingredient, class_2248 result, class_2960 id) {
            this.shape = shape;
            this.ingredient = ingredient;
            this.result = result;
            this.id = id;
        }

        @Override
        public void serializeRecipeData(JsonObject obj) {
            obj.addProperty("cast_shape", CBCRegistries.cannonCastShapes().method_10221((Object)this.shape).toString());
            obj.add("fluid", (JsonElement)this.ingredient.serialize());
            obj.addProperty("result", CBCRegistryUtils.getBlockLocation(this.result).toString());
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public BlockRecipeSerializer<?> getSerializer() {
            return BlockRecipeSerializer.CANNON_CASTING;
        }
    }
}

