/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.PropertiesTypeHandler;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class MunitionPropertiesHandler {
    private static final Map<class_1299<?>, PropertiesTypeHandler<class_1299<?>, ?>> PROJECTILES = new Reference2ReferenceOpenHashMap();
    private static final Map<class_2248, PropertiesTypeHandler<class_2248, ?>> BLOCK_PROPELLANT = new Reference2ReferenceOpenHashMap();
    private static final Map<class_1792, PropertiesTypeHandler<class_1792, ?>> ITEM_PROPELLANT = new Reference2ReferenceOpenHashMap();

    public static void registerProjectileHandler(class_1299<?> type, PropertiesTypeHandler<class_1299<?>, ?> handler) {
        if (PROJECTILES.containsKey(type)) {
            throw new IllegalStateException("Handler for entity type " + CBCRegistryUtils.getEntityTypeLocation(type) + " already registered");
        }
        PROJECTILES.put(type, handler);
    }

    public static void registerBlockPropellantHandler(class_2248 block, PropertiesTypeHandler<class_2248, ?> handler) {
        if (BLOCK_PROPELLANT.containsKey(block)) {
            throw new IllegalStateException("Handler for block " + CBCRegistryUtils.getBlockLocation(block) + " already registered");
        }
        BLOCK_PROPELLANT.put(block, handler);
    }

    public static void registerItemPropellantHandler(class_1792 item, PropertiesTypeHandler<class_1792, ?> handler) {
        if (ITEM_PROPELLANT.containsKey(item)) {
            throw new IllegalStateException("Handler for item " + CBCRegistryUtils.getItemLocation(item) + " already registered");
        }
        ITEM_PROPELLANT.put(item, handler);
    }

    public static void writeBuf(class_2540 buf) {
        MunitionPropertiesHandler.writeToNetwork(buf, PROJECTILES, CBCRegistryUtils.getEntityTypeRegistry());
        MunitionPropertiesHandler.writeToNetwork(buf, BLOCK_PROPELLANT, CBCRegistryUtils.getBlockRegistry());
        MunitionPropertiesHandler.writeToNetwork(buf, ITEM_PROPELLANT, CBCRegistryUtils.getItemRegistry());
    }

    private static <TYPE> void writeToNetwork(class_2540 buf, Map<TYPE, PropertiesTypeHandler<TYPE, ?>> handlers, class_2378<TYPE> registry) {
        buf.method_10804(handlers.size());
        for (Map.Entry<TYPE, PropertiesTypeHandler<TYPE, ?>> entry : handlers.entrySet()) {
            TYPE type = entry.getKey();
            buf.method_10812(registry.method_10221(type));
            entry.getValue().writeToNetwork(type, buf);
        }
    }

    public static void readBuf(class_2540 buf) {
        MunitionPropertiesHandler.readFromNetwork(buf, PROJECTILES, CBCRegistryUtils.getEntityTypeRegistry());
        MunitionPropertiesHandler.readFromNetwork(buf, BLOCK_PROPELLANT, CBCRegistryUtils.getBlockRegistry());
        MunitionPropertiesHandler.readFromNetwork(buf, ITEM_PROPELLANT, CBCRegistryUtils.getItemRegistry());
    }

    private static <TYPE> void readFromNetwork(class_2540 buf, Map<TYPE, PropertiesTypeHandler<TYPE, ?>> map, class_2378<TYPE> registry) {
        map.values().forEach(PropertiesTypeHandler::clearForReload);
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            Object type = registry.method_10223(buf.method_10810());
            map.get(type).loadFromNetwork(type, buf);
        }
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundMunitionPropertiesPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundMunitionPropertiesPacket(), server);
    }

    public record ClientboundMunitionPropertiesPacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundMunitionPropertiesPacket() {
            this(null);
        }

        public static ClientboundMunitionPropertiesPacket copyOf(class_2540 buf) {
            return new ClientboundMunitionPropertiesPacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            MunitionPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                MunitionPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListenerItemPropellant
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerItemPropellant INSTANCE = new ReloadListenerItemPropellant();

        protected ReloadListenerItemPropellant() {
            super(GSON, "munition_properties/item_propellant");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            ITEM_PROPELLANT.values().forEach(PropertiesTypeHandler::clearForReload);
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    class_1792 item = CBCRegistryUtils.getOptionalItem(loc).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + loc + "'"));
                    PropertiesTypeHandler<class_1792, ?> handler = ITEM_PROPELLANT.get(item);
                    if (handler == null) {
                        throw new JsonSyntaxException("No configuration for item '" + loc + "' present");
                    }
                    handler.loadFromJson(item, loc, element.getAsJsonObject());
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class ReloadListenerBlockPropellant
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerBlockPropellant INSTANCE = new ReloadListenerBlockPropellant();

        protected ReloadListenerBlockPropellant() {
            super(GSON, "munition_properties/block_propellant");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            BLOCK_PROPELLANT.values().forEach(PropertiesTypeHandler::clearForReload);
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    class_2248 block = CBCRegistryUtils.getOptionalBlock(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    PropertiesTypeHandler<class_2248, ?> handler = BLOCK_PROPELLANT.get(block);
                    if (handler == null) {
                        throw new JsonSyntaxException("No configuration for block '" + loc + "' present");
                    }
                    handler.loadFromJson(block, loc, element.getAsJsonObject());
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class ReloadListenerProjectiles
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerProjectiles INSTANCE = new ReloadListenerProjectiles();

        protected ReloadListenerProjectiles() {
            super(GSON, "munition_properties/projectiles");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            PROJECTILES.values().forEach(PropertiesTypeHandler::clearForReload);
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    class_1299<?> type = CBCRegistryUtils.getOptionalEntityType(loc).orElseThrow(() -> new JsonSyntaxException("Unknown entity type '" + loc + "'"));
                    PropertiesTypeHandler<class_1299<?>, ?> handler = PROJECTILES.get(type);
                    if (handler == null) {
                        throw new JsonSyntaxException("No configuration for entity type '" + loc + "' present");
                    }
                    handler.loadFromJson(type, loc, element.getAsJsonObject());
                }
                catch (Exception exception) {}
            }
        }
    }
}

