/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.block;

import de.dafuqs.spectrum.inventories.slots.ShadowSlot;
import de.dafuqs.spectrum.networking.SpectrumC2SPacketSender;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3545;
import net.minecraft.class_5536;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FilterConfigurable {
    public List<ItemVariant> getItemFilters();

    public void setFilterItem(int var1, ItemVariant var2);

    default public int getFilterRows() {
        return 1;
    }

    default public int getSlotsPerRow() {
        return 5;
    }

    default public int getDrawnSlots() {
        return this.getItemFilters().size();
    }

    public static void writeFilterNbt(class_2487 tag, List<ItemVariant> filterItems) {
        for (int i = 0; i < filterItems.size(); ++i) {
            tag.method_10566("FilterStack" + i, (class_2520)filterItems.get(i).toNbt());
        }
    }

    public static void readFilterNbt(class_2487 tag, List<ItemVariant> filterItems) {
        for (int i = 0; i < filterItems.size(); ++i) {
            if (!tag.method_10545("FilterStack" + i)) continue;
            filterItems.set(i, ItemVariant.fromNbt((class_2487)tag.method_10562("FilterStack" + i)));
        }
    }

    public static class_1263 getFilterInventoryFromPacketClicker(class_2540 packetByteBuf, ShadowSlotClicker clicker) {
        int size = packetByteBuf.readInt();
        FilterInventory inventory = new FilterInventory(clicker, size);
        for (int i = 0; i < size; ++i) {
            inventory.method_5447(i, packetByteBuf.method_10819());
        }
        return inventory;
    }

    public static class_3545<class_1263, Integer[]> getFilterInventoryWithRowDataFromPacket(int syncId, @NotNull class_1661 playerInventory, class_2540 packetByteBuf, @NotNull class_1703 thisHandler) {
        class_1263 inventory = FilterConfigurable.getFilterInventoryFromPacketHandler(syncId, playerInventory, packetByteBuf, thisHandler);
        Integer[] arr = new Integer[]{packetByteBuf.readInt(), packetByteBuf.readInt(), packetByteBuf.readInt()};
        return new class_3545((Object)inventory, (Object)arr);
    }

    public static class_1263 getFilterInventoryFromPacketHandler(int syncId, @NotNull class_1661 playerInventory, class_2540 packetByteBuf, @NotNull class_1703 thisHandler) {
        ShadowSlotClicker.FromHandler clicker = new ShadowSlotClicker.FromHandler(thisHandler, playerInventory.field_7546, syncId);
        return FilterConfigurable.getFilterInventoryFromPacketClicker(packetByteBuf, clicker);
    }

    public static class_1263 getFilterInventoryFromItemsClicker(List<ItemVariant> items, ShadowSlotClicker clicker) {
        FilterInventory inventory = new FilterInventory(clicker, items.size());
        for (int i = 0; i < items.size(); ++i) {
            inventory.method_5447(i, items.get(i).toStack());
        }
        return inventory;
    }

    public static class_1263 getFilterInventoryFromItemsHandler(int syncId, @NotNull class_1661 playerInventory, List<ItemVariant> items, @NotNull class_1703 thisHandler) {
        ShadowSlotClicker.FromHandler clicker = new ShadowSlotClicker.FromHandler(thisHandler, playerInventory.field_7546, syncId);
        return FilterConfigurable.getFilterInventoryFromItemsClicker(items, clicker);
    }

    public static void writeScreenOpeningData(class_2540 buf, FilterConfigurable configurable) {
        FilterConfigurable.writeScreenOpeningData(buf, configurable.getItemFilters(), configurable.getFilterRows(), configurable.getSlotsPerRow(), configurable.getDrawnSlots());
    }

    public static void writeScreenOpeningData(class_2540 buf, List<ItemVariant> filterItems, int rows, int slotsPerRow, int drawnSlots) {
        buf.writeInt(filterItems.size());
        for (ItemVariant filterItem : filterItems) {
            buf.method_10793(filterItem.toStack());
        }
        buf.writeInt(rows);
        buf.writeInt(slotsPerRow);
        buf.writeInt(drawnSlots);
    }

    default public boolean hasEmptyFilter() {
        return this.getItemFilters().stream().allMatch(TransferVariant::isBlank);
    }

    public static class FilterInventory
    extends class_1277 {
        @NotNull
        private final ShadowSlotClicker clicker;

        public FilterInventory(@NotNull ShadowSlotClicker slotClicker, int size) {
            super(size);
            this.clicker = slotClicker;
        }

        public FilterInventory(@NotNull ShadowSlotClicker slotClicker, class_1799 ... items) {
            super(items);
            this.clicker = slotClicker;
        }

        @NotNull
        public ShadowSlotClicker getClicker() {
            return this.clicker;
        }
    }

    public static interface ShadowSlotClicker {
        default public void clickShadowSlot(int syncId, class_1735 slot, class_1799 shadowStack) {
            this.clickShadowSlot(syncId, slot.field_7874, shadowStack);
        }

        public void clickShadowSlot(int var1, int var2, class_1799 var3);

        public static class FromHandler
        implements ShadowSlotClicker {
            @NotNull
            public final class_1703 handler;
            @NotNull
            public final class_1657 player;
            public final int syncId;

            public FromHandler(@NotNull class_1703 screenHandler, @NotNull class_1657 player, int syncId) {
                this.handler = screenHandler;
                this.player = player;
                this.syncId = syncId;
            }

            @Override
            public void clickShadowSlot(int syncId, @Nullable class_1735 slot, class_1799 shadowStack) {
                if (this.syncId != syncId || !(slot instanceof ShadowSlot)) {
                    return;
                }
                ShadowSlot shadowSlot = (ShadowSlot)slot;
                if (!shadowSlot.onClicked(shadowStack, class_5536.field_27013, this.player)) {
                    return;
                }
                if (this.player.method_37908().method_8608()) {
                    SpectrumC2SPacketSender.sendShadowSlot(syncId, slot.field_7874, shadowStack);
                }
            }

            @Override
            public void clickShadowSlot(int syncId, int id, class_1799 shadowStack) {
                this.clickShadowSlot(syncId, this.handler.method_7611(id), shadowStack);
            }
        }
    }
}

