/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.api.block.FilterConfigurable;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlock;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.listeners.EventQueue;
import de.dafuqs.spectrum.events.listeners.ExperienceOrbEventQueue;
import de.dafuqs.spectrum.events.listeners.ItemAndExperienceEventQueue;
import de.dafuqs.spectrum.events.listeners.ItemEntityEventQueue;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.inventories.BlackHoleChestScreenHandler;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlackHoleChestBlockEntity
extends SpectrumChestBlockEntity
implements ExtendedScreenHandlerFactory,
class_1278,
EventQueue.Callback<Object> {
    public static final int INVENTORY_SIZE = 28;
    public static final int ITEM_FILTER_SLOT_COUNT = 5;
    public static final int EXPERIENCE_STORAGE_PROVIDER_ITEM_SLOT = 27;
    private static final int RANGE = 12;
    private final ItemAndExperienceEventQueue itemAndExperienceEventQueue = new ItemAndExperienceEventQueue((class_5716)new class_5707(this.field_11867), 12, this);
    private final List<ItemVariant> filterItems = class_2371.method_10213((int)5, (Object)ItemVariant.blank());
    private State state;
    private boolean isOpen;
    private boolean isFull;
    private boolean hasXPStorage;
    float storageTarget;
    float storagePos;
    float lastStorageTarget;
    float capTarget;
    float capPos;
    float lastCapTarget;
    float orbTarget;
    float orbPos;
    float lastOrbTarget;
    float yawTarget;
    float orbYaw;
    float lastYawTarget;
    long interpTicks;
    long interpLength = 1L;
    long age;
    long storedXP;
    long maxStoredXP;

    public BlackHoleChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.BLACK_HOLE_CHEST, blockPos, blockState);
    }

    public static void tick(@NotNull class_1937 world, class_2338 pos, class_2680 state, BlackHoleChestBlockEntity chest) {
        chest.updateFullState();
        ++chest.age;
        if (chest.isOpen) {
            if (chest.canFunction()) {
                chest.changeState(State.OPEN_ACTIVE);
                chest.interpLength = 7L;
            } else {
                chest.changeState(State.OPEN_INACTIVE);
                chest.interpLength = 5L;
            }
        } else if (chest.isFull) {
            chest.changeState(State.FULL);
            chest.interpLength = 12L;
        } else if (chest.canFunction()) {
            chest.changeState(State.CLOSED_ACTIVE);
            chest.interpLength = 15L;
        } else {
            chest.changeState(State.CLOSED_INACTIVE);
            chest.interpLength = 10L;
        }
        if (chest.interpTicks < chest.interpLength) {
            ++chest.interpTicks;
        }
        if (world.field_9236) {
            chest.lidAnimator.method_31672();
        } else {
            chest.itemAndExperienceEventQueue.tick(world);
            if (world.method_8510() % 80L == 0L && !SpectrumChestBlock.isChestBlocked((class_1936)world, pos)) {
                BlackHoleChestBlockEntity.searchForNearbyEntities(chest);
            }
        }
    }

    public long getRenderTime() {
        return this.age % 50000L;
    }

    public void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.lastCapTarget = this.capPos;
            this.lastOrbTarget = this.orbPos;
            this.lastStorageTarget = this.storagePos;
            this.lastYawTarget = this.orbYaw;
            this.interpTicks = 0L;
        }
    }

    public void updateFullState() {
        if (!this.field_11863.method_8608()) {
            this.isFull = this.isFull();
            SpectrumS2CPacketSender.sendBlackHoleChestUpdate(this);
        }
    }

    public void setXPData(long xp, long max) {
        this.storedXP = xp;
        this.maxStoredXP = max;
    }

    public State getState() {
        return this.state;
    }

    public boolean canFunction() {
        return !SpectrumChestBlock.isChestBlocked((class_1936)this.field_11863, this.field_11867) && !this.isFull;
    }

    public boolean isFull() {
        for (int i = 0; i < this.inventory.size() - 1; ++i) {
            class_1799 stack = (class_1799)this.inventory.get(i);
            if (stack.method_7947() >= stack.method_7914()) continue;
            return false;
        }
        if (this.canStoreExperience()) {
            class_1799 experienceStack = (class_1799)this.inventory.get(27);
            ExperienceStorageItem experienceStorage = (ExperienceStorageItem)experienceStack.method_7909();
            return ExperienceStorageItem.getStoredExperience(experienceStack) >= experienceStorage.getMaxStoredExperience(experienceStack);
        }
        return true;
    }

    public boolean canStoreExperience() {
        return ((class_1799)this.inventory.get(27)).method_7909() instanceof ExperienceStorageItem;
    }

    public boolean isFullServer() {
        return this.isFull;
    }

    public void setFull(boolean full) {
        this.isFull = full;
    }

    public void setHasXPStorage(boolean hasXPStorage) {
        this.hasXPStorage = hasXPStorage;
    }

    public boolean hasXPStorage() {
        return this.hasXPStorage;
    }

    private static void searchForNearbyEntities(@NotNull BlackHoleChestBlockEntity blockEntity) {
        List itemEntities = blockEntity.method_10997().method_18023((class_5575)class_1299.field_6052, BlackHoleChestBlockEntity.getBoxWithRadius(blockEntity.field_11867, 12), class_1297::method_5805);
        for (class_1542 itemEntity : itemEntities) {
            if (!itemEntity.method_5805() || itemEntity.method_6983().method_7960()) continue;
            itemEntity.method_32876(SpectrumGameEvents.ENTITY_SPAWNED);
        }
        List experienceOrbEntities = blockEntity.method_10997().method_18023((class_5575)class_1299.field_6044, BlackHoleChestBlockEntity.getBoxWithRadius(blockEntity.field_11867, 12), class_1297::method_5805);
        for (class_1303 experienceOrbEntity : experienceOrbEntities) {
            if (!experienceOrbEntity.method_5805()) continue;
            experienceOrbEntity.method_32876(SpectrumGameEvents.ENTITY_SPAWNED);
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    protected static class_238 getBoxWithRadius(class_2338 blockPos, int radius) {
        return class_238.method_30048((class_243)class_243.method_24953((class_2382)blockPos), (double)radius, (double)radius, (double)radius);
    }

    @Override
    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.isOpen = data > 0;
        }
        return super.method_11004(type, data);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.black_hole_chest");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new BlackHoleChestScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        FilterConfigurable.writeFilterNbt(tag, this.filterItems);
        tag.method_10544("age", this.age);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        FilterConfigurable.readFilterNbt(tag, this.filterItems);
        this.age = tag.method_10537("age");
    }

    public int method_5439() {
        return 28;
    }

    public ItemAndExperienceEventQueue getEventListener() {
        return this.itemAndExperienceEventQueue;
    }

    @Override
    public boolean canAcceptEvent(class_1937 world, class_5714 listener, class_5712.class_7447 event, class_243 sourcePos) {
        if (SpectrumChestBlock.isChestBlocked((class_1936)world, this.field_11867)) {
            return false;
        }
        class_1297 entity = event.method_43727().comp_713();
        if (entity instanceof class_1542) {
            return true;
        }
        return entity instanceof class_1303 && this.hasExperienceStorageItem();
    }

    @Override
    public void triggerEvent(class_1937 world, class_5714 listener, Object entry) {
        if (SpectrumChestBlock.isChestBlocked((class_1936)world, this.field_11867)) {
            return;
        }
        if (entry instanceof ExperienceOrbEventQueue.EventEntry) {
            ExperienceOrbEventQueue.EventEntry experienceEntry = (ExperienceOrbEventQueue.EventEntry)entry;
            class_1303 experienceOrbEntity = experienceEntry.experienceOrbEntity;
            if (experienceOrbEntity != null && experienceOrbEntity.method_5805() && this.hasExperienceStorageItem()) {
                ExperienceStorageItem.addStoredExperience((class_1799)this.inventory.get(27), experienceOrbEntity.method_5919());
                BlackHoleChestBlockEntity.sendPlayExperienceOrbEntityAbsorbedParticle((class_3218)world, experienceOrbEntity);
                world.method_8396(null, experienceOrbEntity.method_24515(), class_3417.field_14627, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
                experienceOrbEntity.method_5650(class_1297.class_5529.field_26999);
            }
        } else if (entry instanceof ItemEntityEventQueue.EventEntry) {
            ItemEntityEventQueue.EventEntry itemEntry = (ItemEntityEventQueue.EventEntry)entry;
            class_1542 itemEntity = itemEntry.itemEntity;
            if (itemEntity != null && itemEntity.method_5805() && this.acceptsItemStack(itemEntity.method_6983())) {
                int previousAmount = itemEntity.method_6983().method_7947();
                class_1799 remainingStack = InventoryHelper.smartAddToInventory(itemEntity.method_6983(), (class_1263)this, class_2350.field_11036);
                if (remainingStack.method_7960()) {
                    BlackHoleChestBlockEntity.sendPlayItemEntityAbsorbedParticle((class_3218)world, itemEntity);
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_15197, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
                    itemEntity.method_6979(class_1799.field_8037);
                    itemEntity.method_31472();
                } else if (remainingStack.method_7947() != previousAmount) {
                    BlackHoleChestBlockEntity.sendPlayItemEntityAbsorbedParticle((class_3218)world, itemEntity);
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_15197, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
                    itemEntity.method_6979(remainingStack);
                }
            }
        }
    }

    public static void sendPlayItemEntityAbsorbedParticle(class_3218 world, @NotNull class_1542 itemEntity) {
        SpectrumS2CPacketSender.playParticleWithExactVelocity(world, itemEntity.method_19538(), (class_2394)SpectrumParticleTypes.BLUE_BUBBLE_POP, 1, class_243.field_1353);
    }

    public static void sendPlayExperienceOrbEntityAbsorbedParticle(class_3218 world, @NotNull class_1303 experienceOrbEntity) {
        SpectrumS2CPacketSender.playParticleWithExactVelocity(world, experienceOrbEntity.method_19538(), (class_2394)SpectrumParticleTypes.GREEN_BUBBLE_POP, 1, class_243.field_1353);
    }

    @Override
    public class_3414 getOpenSound() {
        return SpectrumSoundEvents.BLACK_HOLE_CHEST_OPEN;
    }

    @Override
    public class_3414 getCloseSound() {
        return SpectrumSoundEvents.BLACK_HOLE_CHEST_CLOSE;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        FilterConfigurable.writeScreenOpeningData(buf, this.filterItems, 1, 5, 5);
    }

    public List<ItemVariant> getItemFilters() {
        return this.filterItems;
    }

    public void setFilterItem(int slot, ItemVariant item) {
        this.filterItems.set(slot, item);
        this.method_5431();
    }

    public boolean acceptsItemStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        boolean allAir = true;
        for (int i = 0; i < 5; ++i) {
            ItemVariant filterItem = this.filterItems.get(i);
            if (filterItem.getItem().equals(itemStack.method_7909())) {
                return true;
            }
            if (filterItem.getItem().equals(class_1802.field_8162)) continue;
            allAir = false;
        }
        return allAir;
    }

    public boolean hasExperienceStorageItem() {
        return ((class_1799)this.inventory.get(27)).method_7909() instanceof ExperienceStorageItem;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.rangeClosed(0, 26).toArray();
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public static enum State {
        OPEN_INACTIVE,
        OPEN_ACTIVE,
        CLOSED_ACTIVE,
        CLOSED_INACTIVE,
        FULL;

    }
}

