/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.chests.BlackHoleChestBlockEntity;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class BlackHoleChestBlockEntityRenderer
implements class_827<BlackHoleChestBlockEntity> {
    private static final class_4730 defaultSprite = new class_4730(class_1723.field_21668, SpectrumCommon.locate("block/black_hole_chest"));
    private static final class_4730 experienceSprite = new class_4730(class_1723.field_21668, SpectrumCommon.locate("block/black_hole_chest_experience"));
    private final class_630 root;
    private final class_630 shell;
    private final class_630 cap;
    private final class_630 storage;
    private final class_630 orb;

    public BlackHoleChestBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_5607 texturedModelData = BlackHoleChestBlockEntityRenderer.getTexturedModelData();
        this.root = texturedModelData.method_32109();
        this.shell = this.root.method_32086("shell");
        this.cap = this.root.method_32086("cap");
        this.storage = this.root.method_32086("storage");
        this.orb = this.root.method_32086("orb");
    }

    @NotNull
    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 shell = modelPartData.method_32117("shell", class_5606.method_32108().method_32101(0, 0).method_32098(-7.0f, -9.0f, -7.0f, 14.0f, 9.0f, 14.0f, new class_5605(0.0f)).method_32101(0, 39).method_32098(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 cap = modelPartData.method_32117("cap", class_5606.method_32108().method_32101(40, 39).method_32098(-5.0f, -6.0f, -5.0f, 10.0f, 4.0f, 10.0f, new class_5605(0.0f)).method_32101(82, 2).method_32098(-4.0f, -5.0f, -4.0f, 8.0f, 3.0f, 8.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 storage = modelPartData.method_32117("storage", class_5606.method_32108().method_32101(42, 0).method_32098(-5.0f, -2.0f, -5.0f, 10.0f, 2.0f, 10.0f, new class_5605(0.0f)).method_32101(56, 13).method_32098(-4.0f, -2.0f, -4.0f, 8.0f, 2.0f, 8.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 orb = modelPartData.method_32117("orb", class_5606.method_32108().method_32101(0, 0).method_32098(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new class_5605(0.0f)).method_32101(30, 39).method_32098(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)15.4f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)128, (int)128);
    }

    public void render(BlackHoleChestBlockEntity chest, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay) {
        int orbLight;
        matrixStack.method_22903();
        class_4730 sprite = chest.hasXPStorage() ? experienceSprite : defaultSprite;
        boolean bl = chest.method_10997() != null;
        class_2680 blockState = bl ? chest.method_11010() : (class_2680)SpectrumBlocks.BLACK_HOLE_CHEST.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        float f = blockState.method_28498((class_2769)class_2281.field_10768) ? ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144() : 0.0f;
        matrixStack.method_22904(0.5, 1.5, 0.5);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-f));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        long time = chest.getRenderTime();
        double orbTransform = Math.sin(((float)time + tickDelta) / 9.0f);
        float potentialYaw = ((float)time + tickDelta) / 6.0f;
        switch (chest.getState()) {
            case OPEN_ACTIVE: {
                chest.storageTarget = 9.0f;
                chest.capTarget = 12.0f;
                chest.orbTarget = (float)(15.0 + orbTransform);
                chest.yawTarget = potentialYaw;
                break;
            }
            case OPEN_INACTIVE: {
                chest.storageTarget = 9.0f;
                chest.orbTarget = chest.capTarget = 12.0f;
                break;
            }
            case CLOSED_ACTIVE: {
                chest.capTarget = 0.0f;
                chest.storageTarget = 0.0f;
                chest.orbTarget = (float)(12.5 + orbTransform * 2.5);
                chest.yawTarget = potentialYaw;
                break;
            }
            case CLOSED_INACTIVE: {
                chest.storageTarget = chest.capTarget = 0.0f;
                chest.orbTarget = chest.capTarget;
                break;
            }
            case FULL: {
                chest.storageTarget = chest.capTarget = 9.0f;
                chest.orbTarget = chest.capTarget;
            }
        }
        float interp = class_3532.method_15363((float)(((float)chest.interpTicks + tickDelta) / (float)chest.interpLength), (float)0.0f, (float)1.0f);
        chest.capPos = class_3532.method_16439((float)interp, (float)chest.lastCapTarget, (float)chest.capTarget);
        chest.storagePos = class_3532.method_16439((float)interp, (float)chest.lastStorageTarget, (float)chest.storageTarget);
        chest.orbPos = class_3532.method_16439((float)interp, (float)chest.lastOrbTarget, (float)chest.orbTarget);
        chest.orbYaw = class_3532.method_16439((float)interp, (float)chest.lastYawTarget, (float)chest.yawTarget);
        this.cap.field_3656 = 24.0f - chest.capPos;
        this.storage.field_3656 = 24.0f - chest.storagePos;
        this.orb.field_3656 = 15.4f - chest.orbPos;
        this.orb.field_3675 = chest.yawTarget;
        this.storage.field_38456 = this.storage.field_3656 > 23.99f;
        class_4588 vertexConsumer = sprite.method_24145(vertexConsumers, class_1921::method_23580);
        this.cap.method_22698(matrixStack, vertexConsumer, light, overlay);
        this.shell.method_22698(matrixStack, vertexConsumer, light, overlay);
        this.storage.method_22698(matrixStack, vertexConsumer, light, overlay);
        if (chest.hasXPStorage()) {
            float xpDelta = (float)chest.storedXP / (float)chest.maxStoredXP;
            int altLight = Math.round(class_3532.method_37166((float)0.0f, (float)15.0f, (float)xpDelta));
            orbLight = class_765.method_23687((int)altLight, (int)altLight);
        } else {
            orbLight = light;
        }
        this.orb.method_35745(matrixStack, (matrix, path, index, cuboid) -> cuboid.method_32089(matrixStack.method_23760(), vertexConsumer, index == 0 ? orbLight : light, overlay, 1.0f, 1.0f, 1.0f, 1.0f));
        matrixStack.method_22909();
    }
}

