/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.inventories.RestockingChestScreenHandler;
import de.dafuqs.spectrum.items.magic_items.CraftingTabletItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class RestockingChestBlockEntity
extends SpectrumChestBlockEntity
implements class_1278 {
    public static final int INVENTORY_SIZE = 35;
    public static final int[] CHEST_SLOTS = IntStream.rangeClosed(0, 26).toArray();
    public static final int[] RECIPE_SLOTS = IntStream.rangeClosed(27, 30).toArray();
    public static final int[] RESULT_SLOTS = IntStream.rangeClosed(31, 34).toArray();
    private List<class_1799> cachedOutputs = new ArrayList<class_1799>(4);
    private int coolDownTicks = 0;
    private boolean isOpen;
    private boolean isFull;
    private boolean hasValidRecipes;
    private State state;
    float rimTarget;
    float rimPos;
    float lastRimTarget;
    float tabletTarget;
    float tabletPos;
    float lastTabletTarget;
    float assemblyTarget;
    float assemblyPos;
    float lastAssemblyTarget;
    float ringTarget;
    float ringPos;
    float lastRingTarget;
    float itemTarget;
    float itemPos;
    float lastItemTarget;
    float alphaTarget;
    float alphaValue;
    float lastAlphaTarget;
    float yawModTarget;
    float yawMod;
    float lastYawModTarget;
    float yaw;
    float lastYaw;
    long interpTicks;
    long interpLength = 1L;
    long age;

    public RestockingChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.RESTOCKING_CHEST, blockPos, blockState);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, RestockingChestBlockEntity chest) {
        ++chest.age;
        if (world.field_9236) {
            chest.lastYaw = chest.yaw;
            chest.yaw += chest.yawMod;
            if (chest.isOpen) {
                if (chest.canFunction()) {
                    chest.changeState(State.OPEN_CRAFTING);
                    chest.interpLength = 5L;
                } else {
                    chest.changeState(State.OPEN);
                    chest.interpLength = 7L;
                }
            } else if (chest.isFull) {
                chest.changeState(State.FULL);
                chest.interpLength = 9L;
            } else if (chest.canFunction()) {
                chest.changeState(State.CLOSED_CRAFTING);
                chest.interpLength = 7L;
            } else {
                chest.changeState(State.CLOSED);
                chest.interpLength = 13L;
            }
            if (chest.interpTicks < chest.interpLength) {
                ++chest.interpTicks;
            }
            chest.lidAnimator.method_31672();
        } else if (RestockingChestBlockEntity.tickCooldown(chest)) {
            for (int i = 0; i < 4; ++i) {
                boolean couldCraft;
                class_1799 outputItemStack = (class_1799)chest.inventory.get(RESULT_SLOTS[i]);
                class_1799 craftingTabletItemStack = (class_1799)chest.inventory.get(RECIPE_SLOTS[i]);
                if (craftingTabletItemStack.method_7960() || !outputItemStack.method_7960() && outputItemStack.method_7947() >= outputItemStack.method_7914() || !(couldCraft = chest.tryCraft(chest, i))) continue;
                chest.setCooldown(chest, 20);
                chest.method_5431();
                chest.updateFullState();
                return;
            }
            chest.updateFullState();
        }
    }

    public void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.lastRimTarget = this.rimPos;
            this.lastTabletTarget = this.tabletPos;
            this.lastAssemblyTarget = this.assemblyPos;
            this.lastRingTarget = this.ringPos;
            this.lastItemTarget = this.itemPos;
            this.lastAlphaTarget = this.alphaValue;
            this.lastYawModTarget = this.yawMod;
            this.interpTicks = 0L;
        }
    }

    @Override
    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.isOpen = data > 0;
        }
        return super.method_11004(type, data);
    }

    private static boolean tickCooldown(RestockingChestBlockEntity restockingChestBlockEntity) {
        --restockingChestBlockEntity.coolDownTicks;
        if (restockingChestBlockEntity.coolDownTicks > 0) {
            return false;
        }
        restockingChestBlockEntity.coolDownTicks = 0;
        return true;
    }

    public List<class_1799> getRecipeOutputs() {
        if (this.field_11863.method_8608()) {
            return this.cachedOutputs;
        }
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (int slot : RECIPE_SLOTS) {
            class_1799 output;
            class_1860<?> recipe;
            class_1799 tablet = (class_1799)this.inventory.get(slot);
            if (!tablet.method_31574(SpectrumItems.CRAFTING_TABLET) || !RestockingChestBlockEntity.isRecipeValid(recipe = CraftingTabletItem.getStoredRecipe(this.field_11863, tablet)) || (output = recipe.method_8110(this.field_11863.method_30349())).method_7960()) continue;
            list.add(output);
        }
        return list;
    }

    public long getRenderTime() {
        return this.age % 50000L;
    }

    public boolean hasValidRecipes() {
        if (this.field_11863.method_8608()) {
            return this.hasValidRecipes;
        }
        for (int i = 0; i < 4; ++i) {
            class_1860<?> recipe;
            class_1799 tablet = (class_1799)this.inventory.get(RECIPE_SLOTS[i]);
            if (!tablet.method_31574(SpectrumItems.CRAFTING_TABLET) || !RestockingChestBlockEntity.isRecipeValid(recipe = CraftingTabletItem.getStoredRecipe(this.field_11863, tablet)) || !this.isRecipeCraftable(recipe, i) || !this.canSlotFitCraftingOutput((class_1799)this.inventory.get(RESULT_SLOTS[i]), recipe)) continue;
            return true;
        }
        return false;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.restocking_chest");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new RestockingChestScreenHandler(syncId, playerInventory, (class_1263)this);
    }

    private void setCooldown(RestockingChestBlockEntity restockingChestBlockEntity, int cooldownTicks) {
        restockingChestBlockEntity.coolDownTicks = cooldownTicks;
    }

    private boolean tryCraft(RestockingChestBlockEntity chest, int index) {
        class_1860<?> recipe;
        class_1799 craftingTabletItemStack = (class_1799)chest.inventory.get(RECIPE_SLOTS[index]);
        if (craftingTabletItemStack.method_31574(SpectrumItems.CRAFTING_TABLET) && RestockingChestBlockEntity.isRecipeValid(recipe = CraftingTabletItem.getStoredRecipe(this.field_11863, craftingTabletItemStack))) {
            class_2371 ingredients = recipe.method_8117();
            class_1799 outputItemStack = recipe.method_8110(this.field_11863.method_30349());
            class_1799 currentItemStack = (class_1799)chest.inventory.get(RESULT_SLOTS[index]);
            if (InventoryHelper.canCombineItemStacks(currentItemStack, outputItemStack) && InventoryHelper.hasInInventory((List<class_1856>)ingredients, (class_1263)chest)) {
                List<class_1799> remainders = InventoryHelper.removeFromInventoryWithRemainders((List<class_1856>)ingredients, (class_1263)chest);
                if (currentItemStack.method_7960()) {
                    chest.inventory.set(RESULT_SLOTS[index], (Object)outputItemStack.method_7972());
                } else {
                    currentItemStack.method_7933(outputItemStack.method_7947());
                }
                for (class_1799 remainder : remainders) {
                    InventoryHelper.smartAddToInventory(remainder, (class_1263)chest, null);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isRecipeValid(class_1860<?> recipe) {
        return recipe instanceof class_1867 || recipe instanceof class_1869;
    }

    private boolean isRecipeCraftable(class_1860<?> recipe, int index) {
        class_2371 ingredients = recipe.method_8117();
        if (!InventoryHelper.hasInInventory((List<class_1856>)ingredients, (class_1263)this)) {
            return false;
        }
        List<class_1799> remainders = InventoryHelper.getRemainders((List<class_1856>)ingredients, (class_1263)this);
        return InventoryHelper.canFitStacks(remainders, (class_1263)this);
    }

    public int method_5439() {
        return 35;
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("cooldown", this.coolDownTicks);
        tag.method_10544("age", this.age);
        if (this.field_11863.method_8608()) {
            tag.method_10548("yaw", this.yaw);
            tag.method_10548("lastYaw", this.lastYaw);
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("cooldown")) {
            this.coolDownTicks = tag.method_10550("cooldown");
        }
        if (tag.method_10545("age")) {
            this.age = tag.method_10537("age");
        }
        if (tag.method_10545("yaw")) {
            this.yaw = tag.method_10583("yaw");
        }
        if (tag.method_10545("lastYaw")) {
            this.lastYaw = tag.method_10583("lastYaw");
        }
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return RESULT_SLOTS;
        }
        return CHEST_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot <= CHEST_SLOTS[CHEST_SLOTS.length - 1];
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public boolean canFunction() {
        return !this.isFull && this.hasValidRecipes();
    }

    public void updateFullState() {
        if (!this.field_11863.method_8608()) {
            this.isFull = this.isFull();
            this.hasValidRecipes = this.hasValidRecipes();
            SpectrumS2CPacketSender.sendRestockingChestStatusUpdate(this);
        }
    }

    public boolean isFullServer() {
        return this.isFull;
    }

    public boolean isFull() {
        int invalids = 0;
        for (int i = 0; i < 4; ++i) {
            class_1799 tablet = (class_1799)this.inventory.get(RECIPE_SLOTS[i]);
            if (!tablet.method_31574(SpectrumItems.CRAFTING_TABLET)) continue;
            class_1860<?> recipe = CraftingTabletItem.getStoredRecipe(this.field_11863, tablet);
            if (!RestockingChestBlockEntity.isRecipeValid(recipe)) {
                ++invalids;
                continue;
            }
            class_1799 outputSlot = (class_1799)this.inventory.get(RESULT_SLOTS[i]);
            if (!this.canSlotFitCraftingOutput(outputSlot, recipe)) continue;
            return false;
        }
        return invalids != 4;
    }

    public boolean canSlotFitCraftingOutput(class_1799 slot, class_1860<?> recipe) {
        return slot.method_7960() || slot.method_7947() + recipe.method_8110(this.field_11863.method_30349()).method_7947() < slot.method_7914();
    }

    public void updateState(boolean full, boolean hasValidRecipes, List<class_1799> cachedOutputs) {
        this.isFull = full;
        this.hasValidRecipes = hasValidRecipes;
        this.cachedOutputs = cachedOutputs;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        OPEN,
        OPEN_CRAFTING,
        CLOSED_CRAFTING,
        CLOSED,
        FULL;

    }
}

