/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.enchanter;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlock;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconHelper;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class EnchanterBlock
extends InWorldInteractionBlock {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("midgame/build_enchanting_structure");

    public EnchanterBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        if (world.field_9236) {
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.ENCHANTER));
        }
    }

    public static boolean verifyStructure(class_1937 world, class_2338 blockPos, @Nullable class_3222 serverPlayerEntity) {
        Multiblock multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.ENCHANTER);
        boolean valid = multiblock.validate(world, blockPos.method_10087(3), class_2470.field_11467);
        if (valid) {
            if (serverPlayerEntity != null) {
                SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger(serverPlayerEntity, multiblock);
            }
        } else if (world.field_9236) {
            ModonomiconHelper.renderMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.ENCHANTER), SpectrumMultiblocks.ENCHANTER_TEXT, blockPos.method_10087(4), class_2470.field_11467);
        }
        return valid;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EnchanterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return EnchanterBlock.method_31618(type, SpectrumBlockEntities.ENCHANTER, EnchanterBlockEntity::clientTick);
        }
        return EnchanterBlock.method_31618(type, SpectrumBlockEntities.ENCHANTER, EnchanterBlockEntity::serverTick);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            EnchanterBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity;
        if (world.field_9236) {
            EnchanterBlock.verifyStructure(world, pos, null);
            return class_1269.field_5812;
        }
        if (EnchanterBlock.verifyStructure(world, pos, (class_3222)player) && (blockEntity = world.method_8321(pos)) instanceof EnchanterBlockEntity) {
            int inputInventorySlotIndex;
            EnchanterBlockEntity enchanterBlockEntity = (EnchanterBlockEntity)blockEntity;
            class_1799 handStack = player.method_5998(hand);
            if (player.method_5715() || handStack.method_7960()) {
                for (int i = 0; i < 2; ++i) {
                    if (!this.retrieveStack(world, pos, player, hand, handStack, enchanterBlockEntity, i)) continue;
                    enchanterBlockEntity.setItemFacingDirection(player.method_5735());
                    enchanterBlockEntity.setOwner(player);
                    enchanterBlockEntity.inventoryChanged();
                    break;
                }
                return class_1269.field_21466;
            }
            int n = handStack.method_7909() instanceof ExperienceStorageItem ? (enchanterBlockEntity.method_5438(1).method_7960() ? 1 : 0) : (inputInventorySlotIndex = 0);
            if (this.exchangeStack(world, pos, player, hand, handStack, enchanterBlockEntity, inputInventorySlotIndex)) {
                enchanterBlockEntity.setItemFacingDirection(player.method_5735());
                enchanterBlockEntity.setOwner(player);
                enchanterBlockEntity.inventoryChanged();
            }
        }
        return class_1269.field_21466;
    }
}

