/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fluid;

import de.dafuqs.spectrum.blocks.fluid.SpectrumFluid;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.recipe.fluid_converting.FluidConvertingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5819;

public abstract class LiquidCrystalFluid
extends SpectrumFluid {
    public class_3611 method_15751() {
        return SpectrumFluids.LIQUID_CRYSTAL;
    }

    public class_3611 method_15750() {
        return SpectrumFluids.FLOWING_LIQUID_CRYSTAL;
    }

    public class_1792 method_15774() {
        return SpectrumItems.LIQUID_CRYSTAL_BUCKET;
    }

    protected class_2680 method_15790(class_3610 fluidState) {
        return (class_2680)SpectrumBlocks.LIQUID_CRYSTAL.method_9564().method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(LiquidCrystalFluid.method_15741((class_3610)fluidState)));
    }

    @Override
    public boolean method_15780(class_3611 fluid) {
        return fluid == SpectrumFluids.LIQUID_CRYSTAL || fluid == SpectrumFluids.FLOWING_LIQUID_CRYSTAL;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_15776(class_1937 world, class_2338 pos, class_3610 state, class_5819 random) {
        class_2338 topPos = pos.method_10084();
        class_2680 topState = world.method_8320(topPos);
        if (topState.method_26215() && !topState.method_26216((class_1922)world, topPos) && random.method_43048(1000) == 0) {
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.LIQUID_CRYSTAL_AMBIENT, class_3419.field_15245, 0.2f + random.method_43057() * 0.2f, 0.9f + random.method_43057() * 0.15f, false);
        }
    }

    @Override
    protected void method_15730(class_1936 world, class_2338 pos, class_2680 state) {
        if (state.method_26164(class_3481.field_20339)) {
            class_2248.method_9610((class_2680)SpectrumBlocks.RESONANT_LILY.method_9564(), (class_1936)world, (class_2338)pos, null);
        } else {
            super.method_15730(world, pos, state);
        }
    }

    public class_2394 method_15787() {
        return SpectrumParticleTypes.DRIPPING_LIQUID_CRYSTAL;
    }

    @Override
    public class_2394 getSplashParticle() {
        return SpectrumParticleTypes.LIQUID_CRYSTAL_SPLASH;
    }

    @Override
    public void onEntityCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.onEntityCollision(state, world, pos, entity);
        if (!world.field_9236 && entity instanceof class_1309) {
            class_1293 regenerationInstance;
            class_1309 livingEntity = (class_1309)entity;
            if (world.method_8510() % 200L == 0L && (regenerationInstance = livingEntity.method_6112(class_1294.field_5924)) == null) {
                class_1293 newRegenerationInstance = new class_1293(class_1294.field_5924, 80);
                livingEntity.method_6092(newRegenerationInstance);
            }
        }
    }

    @Override
    public class_3956<? extends FluidConvertingRecipe> getDippingRecipeType() {
        return SpectrumRecipeTypes.LIQUID_CRYSTAL_CONVERTING;
    }

    public static class Still
    extends LiquidCrystalFluid {
        @Override
        protected boolean method_15737(class_1937 world) {
            return false;
        }

        public int method_15779(class_3610 fluidState) {
            return 8;
        }

        public boolean method_15793(class_3610 fluidState) {
            return true;
        }
    }

    public static class Flowing
    extends LiquidCrystalFluid {
        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(new class_2769[]{field_15900});
        }

        @Override
        protected boolean method_15737(class_1937 world) {
            return false;
        }

        public int method_15779(class_3610 fluidState) {
            return (Integer)fluidState.method_11654((class_2769)field_15900);
        }

        public boolean method_15793(class_3610 fluidState) {
            return false;
        }
    }
}

