/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fusion_shrine;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlock;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconHelper;
import de.dafuqs.spectrum.inventories.storage.DroppedItemStorage;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorageUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.context.SingleSlotContainerItemContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class FusionShrineBlock
extends InWorldInteractionBlock {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("collect_all_basic_pigments_besides_brown");
    public static final class_2758 LIGHT_LEVEL = class_2758.method_11867((String)"light_level", (int)0, (int)15);
    protected static final class_265 SHAPE;

    public FusionShrineBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        if (world.field_9236 && world.method_8608()) {
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.FUSION_SHRINE));
        }
    }

    public static boolean verifySkyAccess(class_3218 world, class_2338 shrinePos) {
        if (!world.method_8320(shrinePos.method_10084()).method_26215()) {
            world.method_8396(null, shrinePos, SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 1.0f, 1.0f);
            SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity(world, shrinePos.method_10084().method_46558(), (class_2394)SpectrumParticleTypes.RED_SPARKLE_RISING, 8, class_243.field_1353, new class_243(0.1, 0.1, 0.1));
            return false;
        }
        int topY = world.method_8624(class_2902.class_2903.field_13202, shrinePos.method_10263(), shrinePos.method_10260());
        class_2338.class_2339 mutablePos = new class_2338.class_2339(shrinePos.method_10263(), topY, shrinePos.method_10260());
        for (int y = topY; y > shrinePos.method_10264(); --y) {
            mutablePos.method_33098(y - 1);
            class_2680 posState = world.method_8320((class_2338)mutablePos);
            if (posState.method_26193((class_1922)world, (class_2338)mutablePos) > 0) break;
        }
        if (mutablePos.method_10264() == shrinePos.method_10264()) {
            return true;
        }
        SpectrumS2CPacketSender.playParticleWithExactVelocity(world, new class_243((double)shrinePos.method_10263() + 0.5, (double)(shrinePos.method_10264() + 1), (double)shrinePos.method_10260() + 0.5), (class_2394)SpectrumParticleTypes.RED_SPARKLE_RISING, 1, new class_243(0.0, 0.5, 0.0));
        SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity(world, new class_243((double)shrinePos.method_10263() + 0.5, (double)topY - 0.5, (double)shrinePos.method_10260() + 0.5), (class_2394)SpectrumParticleTypes.RED_SPARKLE_RISING, 8, class_243.field_1353, new class_243(0.1, 0.1, 0.1));
        world.method_8396(null, shrinePos, SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 1.0f, 1.0f);
        return false;
    }

    public static boolean verifyStructure(class_1937 world, class_2338 blockPos, @Nullable class_3222 serverPlayerEntity) {
        Multiblock multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.FUSION_SHRINE);
        boolean valid = multiblock.validate(world, blockPos.method_10074(), class_2470.field_11467);
        if (valid) {
            if (serverPlayerEntity != null) {
                SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger(serverPlayerEntity, multiblock);
            }
        } else if (world.field_9236) {
            ModonomiconHelper.renderMultiblock(multiblock, SpectrumMultiblocks.FUSION_SHRINE_TEXT, blockPos.method_10087(2), class_2470.field_11467);
        } else {
            class_2586 class_25862 = world.method_8321(blockPos);
            if (class_25862 instanceof FusionShrineBlockEntity) {
                FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)class_25862;
                fusionShrineBlockEntity.scatterContents(world);
            }
        }
        return valid;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIGHT_LEVEL});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FusionShrineBlockEntity(pos, state);
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity blockEntity = (FusionShrineBlockEntity)class_25862;
            class_2371<class_1799> inventory = blockEntity.getItems();
            int i = 0;
            float f = 0.0f;
            for (int j = 0; j < inventory.size(); ++j) {
                class_1799 itemStack = blockEntity.method_5438(j);
                if (itemStack.method_7960()) continue;
                f += (float)itemStack.method_7947() / (float)Math.min(blockEntity.method_5444(), itemStack.method_7914());
                ++i;
            }
            if (blockEntity.fluidStorage.amount > 0L) {
                f += (float)blockEntity.fluidStorage.amount / (float)blockEntity.fluidStorage.getCapacity();
                ++i;
            }
            return class_3532.method_15375((float)(f / ((float)inventory.size() + 1.0f) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            FusionShrineBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    @Override
    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!world.field_9236) {
            class_2586 blockEntity = world.method_8321(pos);
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                if (blockEntity instanceof FusionShrineBlockEntity) {
                    class_1792 item;
                    DroppedItemStorage slot;
                    SingleSlotContainerItemContext ctx;
                    Storage fluidStorage;
                    FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
                    SingleVariantStorage<FluidVariant> storage = fusionShrineBlockEntity.fluidStorage;
                    class_1799 itemStack = itemEntity.method_6983();
                    if (itemStack.method_7947() == 1 && (fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)(ctx = new SingleSlotContainerItemContext((SingleSlotStorage)(slot = new DroppedItemStorage(item = itemStack.method_7909(), itemStack.method_7969())))))) != null) {
                        boolean anyInserted = false;
                        for (StorageView view : fluidStorage) {
                            Transaction transaction = Transaction.openOuter();
                            try {
                                long extracted;
                                FluidVariant variant = (FluidVariant)view.getResource();
                                long inserted = variant.isBlank() ? 0L : storage.insert((TransferVariant)variant, view.getAmount(), (TransactionContext)transaction);
                                if (inserted != (extracted = fluidStorage.extract((Object)variant, inserted, (TransactionContext)transaction)) || inserted == 0L) continue;
                                anyInserted = true;
                                transaction.commit();
                            }
                            finally {
                                if (transaction == null) continue;
                                transaction.close();
                            }
                        }
                        if (!anyInserted && !((FluidVariant)storage.getResource()).isBlank()) {
                            try (Transaction transaction = Transaction.openOuter();){
                                long inserted = fluidStorage.insert((Object)((FluidVariant)storage.getResource()), storage.getAmount(), (TransactionContext)transaction);
                                long extracted = storage.extract((TransferVariant)((FluidVariant)storage.getResource()), inserted, (TransactionContext)transaction);
                                if (inserted == extracted && inserted != 0L) {
                                    transaction.commit();
                                }
                            }
                        }
                        itemEntity.method_6979(((ItemVariant)slot.getResource()).toStack(itemStack.method_7947()));
                        fusionShrineBlockEntity.inventoryChanged();
                        return;
                    }
                }
            }
            if (entity.method_19538().field_1352 % 0.5 != 0.0 && entity.method_19538().field_1350 % 0.5 != 0.0) {
                super.method_9554(world, state, pos, entity, fallDistance);
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            FusionShrineBlock.verifyStructure(world, pos, null);
            return class_1269.field_5812;
        }
        FusionShrineBlock.verifySkyAccess((class_3218)world, pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
            if (FusionShrineBlock.verifyStructure(world, pos, (class_3222)player)) {
                fusionShrineBlockEntity.setOwner(player);
                class_1799 handStack = player.method_5998(hand);
                if (FluidStorageUtil.interactWithFluidStorage(fusionShrineBlockEntity.fluidStorage, (class_1657)player, (class_1268)hand)) {
                    fusionShrineBlockEntity.inventoryChanged();
                    return class_1269.field_21466;
                }
                if ((player.method_5715() || handStack.method_7960()) && this.retrieveLastStack(world, pos, player, hand, handStack, fusionShrineBlockEntity)) {
                    fusionShrineBlockEntity.inventoryChanged();
                    return class_1269.field_21466;
                }
                if (!handStack.method_7960() && this.inputHandStack(world, player, hand, handStack, fusionShrineBlockEntity)) {
                    fusionShrineBlockEntity.inventoryChanged();
                    return class_1269.field_21466;
                }
            }
        }
        return class_1269.field_21466;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return FusionShrineBlock.method_31618(type, SpectrumBlockEntities.FUSION_SHRINE, FusionShrineBlockEntity::clientTick);
        }
        return FusionShrineBlock.method_31618(type, SpectrumBlockEntities.FUSION_SHRINE, FusionShrineBlockEntity::serverTick);
    }

    static {
        class_265 neck = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
        class_265 head = class_2248.method_9541((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        class_265 crystal = class_2248.method_9541((double)6.5, (double)13.0, (double)6.5, (double)9.5, (double)23.0, (double)9.5);
        neck = class_259.method_1084((class_265)neck, (class_265)head);
        SHAPE = class_259.method_1084((class_265)neck, (class_265)crystal);
    }
}

