/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.PastelRenderHelper;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetworkManager;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ClientPastelNetworkManager
implements PastelNetworkManager {
    private final List<PastelNetwork> networks = new ArrayList<PastelNetwork>();

    @Override
    public PastelNetwork joinOrCreateNetwork(PastelNodeBlockEntity node, UUID uuid) {
        PastelNetwork foundNetwork = null;
        for (int i = 0; i < this.networks.size(); ++i) {
            PastelNetwork network = this.networks.get(i);
            if (network.getUUID().equals(uuid)) {
                network.addNodeAndLoadMemory(node);
                foundNetwork = network;
                continue;
            }
            if (network.removeNode(node, NodeRemovalReason.MOVED)) {
                --i;
            }
            if (network.hasNodes()) continue;
            this.networks.remove(network);
        }
        if (foundNetwork != null) {
            return foundNetwork;
        }
        PastelNetwork network = this.createNetwork(node.method_10997(), uuid);
        network.addNodeAndLoadMemory(node);
        return network;
    }

    @Override
    public Optional<? extends PastelNetwork> getNetwork(UUID uuid) {
        return this.networks.stream().filter(n -> n.uuid.equals(uuid)).findFirst();
    }

    @Override
    public void connectNodes(PastelNodeBlockEntity node, PastelNodeBlockEntity parent) {
        PastelNetwork otherNetwork;
        PastelNetwork parentNetwork;
        if (parent.getParentNetwork() != null) {
            parentNetwork = parent.getParentNetwork();
            otherNetwork = node.getParentNetwork();
            if (otherNetwork == null) {
                parentNetwork.addNodeAndConnect(node, parent);
                node.setParentNetwork(parentNetwork);
                return;
            }
        } else if (node.getParentNetwork() != null) {
            parentNetwork = node.getParentNetwork();
            otherNetwork = parent.getParentNetwork();
            if (otherNetwork == null) {
                parentNetwork.addNodeAndConnect(parent, node);
                parent.setParentNetwork(parentNetwork);
                return;
            }
        } else {
            PastelNetwork parentNetwork2 = this.createNetwork(node.method_10997(), null);
            parentNetwork2.addNode(parent);
            parent.setParentNetwork(parentNetwork2);
            parentNetwork2.addNodeAndConnect(node, parent);
            node.setParentNetwork(parentNetwork2);
            return;
        }
        if (parentNetwork == otherNetwork) {
            return;
        }
        parentNetwork.incorporate(otherNetwork, node, parent);
        this.networks.remove(otherNetwork);
    }

    @Override
    public void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        PastelNetwork network = node.getParentNetwork();
        if (network != null) {
            network.removeNode(node, reason);
            if (network.nodes.size() == 0) {
                this.networks.remove(network);
            }
        }
    }

    private PastelNetwork createNetwork(class_1937 world, UUID uuid) {
        PastelNetwork network = new PastelNetwork(world, uuid);
        this.networks.add(network);
        return network;
    }

    public void renderLines(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        for (PastelNetwork network : this.networks) {
            if (network.getWorld().method_8597() != context.world().method_8597()) continue;
            Graph<PastelNodeBlockEntity, DefaultEdge> graph = network.getGraph();
            int color = network.getColor();
            float[] colors = PastelRenderHelper.unpackNormalizedColor(color);
            for (DefaultEdge edge : graph.edgeSet()) {
                PastelNodeBlockEntity source = (PastelNodeBlockEntity)graph.getEdgeSource((Object)edge);
                PastelNodeBlockEntity target = (PastelNodeBlockEntity)graph.getEdgeTarget((Object)edge);
                class_4587 matrices = context.matrixStack();
                class_243 pos = context.camera().method_19326();
                matrices.method_22903();
                matrices.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
                PastelRenderHelper.renderLineTo(context.matrixStack(), context.consumers(), colors, source.method_11016(), target.method_11016());
                if (client.field_1690.field_1866) {
                    class_243 offset = class_243.method_24953((class_2382)target.method_11016()).method_1020(class_243.method_24954((class_2382)source.method_11016()));
                    class_243 normalized = offset.method_1029();
                    Matrix4f positionMatrix = context.matrixStack().method_23760().method_23761();
                    PastelRenderHelper.renderDebugLine(context.consumers(), color, offset, normalized, positionMatrix);
                }
                matrices.method_22909();
            }
        }
    }
}

