/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.helpers.SchedulerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class PastelNetwork {
    protected final Map<PastelNodeType, Set<PastelNodeBlockEntity>> nodes = new ConcurrentHashMap<PastelNodeType, Set<PastelNodeBlockEntity>>();
    protected final Set<PastelNodeBlockEntity> priorityNodes = new HashSet<PastelNodeBlockEntity>();
    protected final Set<PastelNodeBlockEntity> highPriorityNodes = new HashSet<PastelNodeBlockEntity>();
    @Nullable
    protected Graph<PastelNodeBlockEntity, DefaultEdge> graph;
    protected final class_1937 world;
    protected final UUID uuid;
    protected final SchedulerMap<PastelTransmission> transmissions = new SchedulerMap();

    public PastelNetwork(class_1937 world, @Nullable UUID uuid) {
        this.world = world;
        this.uuid = uuid == null ? UUID.randomUUID() : uuid;
        for (PastelNodeType type : PastelNodeType.values()) {
            this.nodes.put(type, new HashSet());
        }
    }

    public void incorporate(PastelNetwork networkToIncorporate, PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        for (Map.Entry<PastelNodeType, Set<PastelNodeBlockEntity>> nodesToIncorporate : networkToIncorporate.getNodes().entrySet()) {
            PastelNodeType type = nodesToIncorporate.getKey();
            for (PastelNodeBlockEntity nodeToIncorporate : nodesToIncorporate.getValue()) {
                this.nodes.get((Object)type).add(nodeToIncorporate);
                nodeToIncorporate.setParentNetwork(this);
                this.updateNodePriority(nodeToIncorporate, nodeToIncorporate.getPriority());
            }
        }
        node.remember(otherNode);
        otherNode.remember(node);
        this.graph = PastelNetwork.buildGraph(this);
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public Graph<PastelNodeBlockEntity, DefaultEdge> getGraph() {
        if (this.graph == null) {
            this.graph = PastelNetwork.buildGraph(this);
        }
        return this.graph;
    }

    @NotNull
    private static SimpleGraph<PastelNodeBlockEntity, DefaultEdge> buildGraph(@NotNull PastelNetwork network) {
        SimpleGraph g = new SimpleGraph(DefaultEdge.class);
        class_1937 world = network.world;
        for (PastelNodeBlockEntity node : network.getAllNodes()) {
            g.addVertex((Object)node);
        }
        for (PastelNodeBlockEntity node : network.getAllNodes()) {
            Set<class_2338> memory = node.getRememberedConnections();
            for (class_2338 pos : memory) {
                PastelNodeBlockEntity rememberedNode;
                if (!world.method_33598(pos.method_10263(), pos.method_10260()) || (rememberedNode = network.getNodeAt(pos)) == null || !network.getAllNodes().contains(rememberedNode)) continue;
                g.addEdge((Object)node, (Object)rememberedNode);
            }
        }
        return g;
    }

    public void addNode(PastelNodeBlockEntity node) {
        if (this.addNodeOrReturn(node)) {
            return;
        }
        this.graph.addVertex((Object)node);
        this.addPriorityNode(node);
    }

    public void addNodeAndLoadMemory(PastelNodeBlockEntity node) {
        if (this.addNodeOrReturn(node)) {
            return;
        }
        this.graph.addVertex((Object)node);
        for (class_2338 memory : node.getRememberedConnections()) {
            PastelNodeBlockEntity rememberedNode;
            if (!this.world.method_33598(memory.method_10263(), memory.method_10260()) || (rememberedNode = this.getNodeAt(memory)) == null || !this.getAllNodes().contains(rememberedNode)) continue;
            this.graph.addEdge((Object)node, (Object)rememberedNode);
        }
        this.addPriorityNode(node);
    }

    public void addNodeAndConnect(PastelNodeBlockEntity newNode, PastelNodeBlockEntity parent) {
        if (this.addNodeOrReturn(newNode, true)) {
            return;
        }
        this.graph.addVertex((Object)newNode);
        this.addAndRememberEdge(newNode, parent);
        this.addPriorityNode(newNode);
    }

    public void addAndRememberEdge(PastelNodeBlockEntity newNode, PastelNodeBlockEntity parent) {
        this.getGraph().addEdge((Object)newNode, (Object)parent);
        newNode.remember(parent);
        parent.remember(newNode);
    }

    public void removeAndForgetEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity parent) {
        if (this.graph != null) {
            this.graph.removeEdge((Object)node, (Object)parent);
        }
        node.forget(parent);
        parent.forget(node);
    }

    public boolean hasEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        if (this.graph == null) {
            return false;
        }
        if (!this.graph.containsVertex((Object)node) || !this.graph.containsVertex((Object)otherNode)) {
            return false;
        }
        return this.graph.containsEdge((Object)node, (Object)otherNode);
    }

    private boolean addNodeOrReturn(PastelNodeBlockEntity node, boolean allowGraphCreation) {
        if (!this.nodes.get((Object)node.getNodeType()).add(node)) {
            return true;
        }
        if (this.graph == null && allowGraphCreation) {
            this.graph = PastelNetwork.buildGraph(this);
            return false;
        }
        return this.graph == null;
    }

    private boolean addNodeOrReturn(PastelNodeBlockEntity node) {
        return this.addNodeOrReturn(node, false);
    }

    private void addPriorityNode(PastelNodeBlockEntity node) {
        switch (node.getPriority().ordinal()) {
            case 1: {
                this.priorityNodes.add(node);
                break;
            }
            case 2: {
                this.highPriorityNodes.add(node);
            }
        }
    }

    public void updateNodePriority(PastelNodeBlockEntity node, Priority oldPriority) {
        this.removePriorityNode(node, oldPriority);
        this.addPriorityNode(node);
    }

    protected boolean removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        boolean hadNode = this.nodes.get((Object)node.getNodeType()).remove(node);
        if (!hadNode) {
            return false;
        }
        if (this.graph != null) {
            this.removeAndForget(node);
        }
        node.forgetAll();
        this.removePriorityNode(node, node.getPriority());
        return true;
    }

    private void removeAndForget(PastelNodeBlockEntity node) {
        assert (this.graph != null);
        for (DefaultEdge edge : this.graph.edgesOf((Object)node)) {
            PastelNodeBlockEntity target = (PastelNodeBlockEntity)this.graph.getEdgeSource((Object)edge);
            if (target == node) {
                target = (PastelNodeBlockEntity)this.graph.getEdgeTarget((Object)edge);
            }
            target.forget(node);
        }
        this.graph.removeVertex((Object)node);
    }

    private void removePriorityNode(PastelNodeBlockEntity node, Priority priority) {
        switch (priority.ordinal()) {
            case 1: {
                this.priorityNodes.remove(node);
                break;
            }
            case 2: {
                this.highPriorityNodes.remove(node);
            }
        }
    }

    public boolean hasNodes() {
        for (Set<PastelNodeBlockEntity> nodeList : this.nodes.values()) {
            if (nodeList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set<PastelNodeBlockEntity> getNodes(PastelNodeType type) {
        return this.getNodes(type, Priority.GENERIC);
    }

    public Set<PastelNodeBlockEntity> getNodes(PastelNodeType type, Priority priority) {
        Set<PastelNodeBlockEntity> nodeType = this.nodes.get((Object)type);
        if (priority == Priority.MODERATE) {
            return nodeType.stream().filter(this.priorityNodes::contains).collect(Collectors.toSet());
        }
        if (priority == Priority.HIGH) {
            return nodeType.stream().filter(this.highPriorityNodes::contains).collect(Collectors.toSet());
        }
        return nodeType;
    }

    public Map<PastelNodeType, Set<PastelNodeBlockEntity>> getNodes() {
        return this.nodes;
    }

    public int getNodeCount() {
        int nodes = 0;
        for (Set<PastelNodeBlockEntity> nodeList : this.nodes.values()) {
            nodes += nodeList.size();
        }
        return nodes;
    }

    public List<PastelNodeBlockEntity> getAllNodes() {
        ArrayList<PastelNodeBlockEntity> nodes = new ArrayList<PastelNodeBlockEntity>();
        for (Map.Entry<PastelNodeType, Set<PastelNodeBlockEntity>> nodeList : this.nodes.entrySet()) {
            nodes.addAll((Collection<PastelNodeBlockEntity>)this.nodes.get((Object)nodeList.getKey()));
        }
        return nodes;
    }

    public boolean canConnect(PastelNodeBlockEntity newNode) {
        if (newNode.method_10997() != this.getWorld()) {
            return false;
        }
        for (Set<PastelNodeBlockEntity> nodeList : this.nodes.values()) {
            for (PastelNodeBlockEntity currentNode : nodeList) {
                if (!currentNode.canConnect(newNode)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick() {
        this.transmissions.tick();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void addTransmission(PastelTransmission transmission, int travelTime) {
        transmission.setNetwork(this);
        this.transmissions.put(transmission, travelTime);
    }

    public int getColor() {
        return ColorHelper.getRandomColor(this.uuid.hashCode());
    }

    public boolean equals(Object other) {
        if (other instanceof PastelNetwork) {
            PastelNetwork p = (PastelNetwork)other;
            return this.uuid.equals(p.uuid);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.uuid.toString());
        for (PastelNodeType type : PastelNodeType.values()) {
            builder.append("-").append(this.getNodes(type).size());
        }
        return builder.toString();
    }

    public String getNodeDebugText() {
        return "Prov: " + this.getNodes(PastelNodeType.PROVIDER).size() + " - Send: " + this.getNodes(PastelNodeType.SENDER).size() + " - Gath: " + this.getNodes(PastelNodeType.GATHER).size() + " - Stor: " + this.getNodes(PastelNodeType.STORAGE).size() + " - Buff: " + this.getNodes(PastelNodeType.BUFFER).size() + " - Conn: " + this.getNodes(PastelNodeType.CONNECTION).size();
    }

    public PastelNodeBlockEntity getNodeAt(class_2338 blockPos) {
        if (!this.getWorld().method_22340(blockPos)) {
            return null;
        }
        class_2586 blockEntity = this.getWorld().method_8321(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }

    public static enum Priority {
        GENERIC,
        MODERATE,
        HIGH;

    }
}

