/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public interface PastelNetworkManager {
    public PastelNetwork joinOrCreateNetwork(PastelNodeBlockEntity var1, @Nullable UUID var2);

    public void connectNodes(PastelNodeBlockEntity var1, PastelNodeBlockEntity var2);

    public void removeNode(PastelNodeBlockEntity var1, NodeRemovalReason var2);

    public Optional<? extends PastelNetwork> getNetwork(UUID var1);

    default public boolean tryAddEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        if (node.getParentNetwork() == null) {
            throw new IllegalStateException("Attempted to add an edge to a null network");
        }
        if (node.getParentNetwork() != otherNode.getParentNetwork()) {
            throw new IllegalArgumentException("Can't add an edge between nodes in different networks");
        }
        if (node == otherNode || node.getParentNetwork().hasEdge(node, otherNode)) {
            return false;
        }
        node.getParentNetwork().addAndRememberEdge(node, otherNode);
        return true;
    }

    default public boolean tryRemoveEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        if (node.getParentNetwork() == null) {
            throw new IllegalStateException("Attempted to remove an edge from a null network");
        }
        if (node.getParentNetwork() != otherNode.getParentNetwork()) {
            throw new IllegalArgumentException("Can't remove an edge between nodes in different networks - how did you even do this");
        }
        PastelNetwork network = node.getParentNetwork();
        if (!network.hasEdge(node, otherNode)) {
            return false;
        }
        node.getParentNetwork().removeAndForgetEdge(node, otherNode);
        return true;
    }
}

