/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.helpers.InWorldInteractionHelper;
import de.dafuqs.spectrum.helpers.SchedulerMap;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelTransmission
implements SchedulerMap.Callback {
    @Nullable
    private PastelNetwork network;
    private final List<class_2338> nodePositions;
    private final ItemVariant variant;
    private final long amount;
    private final int vertexTime;

    public PastelTransmission(List<class_2338> nodePositions, ItemVariant variant, long amount, int vertexTime) {
        this.nodePositions = nodePositions;
        this.variant = variant;
        this.amount = amount;
        this.vertexTime = vertexTime;
    }

    public void setNetwork(@NotNull PastelNetwork network) {
        this.network = network;
    }

    @Nullable
    public PastelNetwork getNetwork() {
        return this.network;
    }

    public List<class_2338> getNodePositions() {
        return this.nodePositions;
    }

    public int getVertexTime() {
        return this.vertexTime;
    }

    public int getTransmissionDuration() {
        return this.vertexTime * (this.nodePositions.size() - 1);
    }

    public ItemVariant getVariant() {
        return this.variant;
    }

    public long getAmount() {
        return this.amount;
    }

    public class_2338 getStartPos() {
        return this.nodePositions.get(0);
    }

    @Override
    public void trigger() {
        this.arriveAtDestination();
    }

    private void arriveAtDestination() {
        if (this.nodePositions.size() == 0) {
            return;
        }
        class_2338 destinationPos = this.nodePositions.get(this.nodePositions.size() - 1);
        PastelNodeBlockEntity destinationNode = this.network.getNodeAt(destinationPos);
        class_1937 world = this.network.getWorld();
        if (!world.field_9236) {
            Storage<ItemVariant> destinationStorage;
            int inserted = 0;
            if (destinationNode != null && (destinationStorage = destinationNode.getConnectedStorage()) != null) {
                try (Transaction transaction = Transaction.openOuter();){
                    if (destinationStorage.supportsInsertion()) {
                        inserted = (int)destinationStorage.insert((Object)this.variant, this.amount, (TransactionContext)transaction);
                        destinationNode.addItemCountUnderway(-inserted);
                        transaction.commit();
                    }
                }
            }
            if ((long)inserted != this.amount) {
                InWorldInteractionHelper.scatter(world, (double)destinationPos.method_10263() + 0.5, (double)destinationPos.method_10264() + 0.5, (double)destinationPos.method_10260() + 0.5, this.variant, this.amount - (long)inserted);
            }
        }
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10566("Variant", (class_2520)this.variant.toNbt());
        compound.method_10544("Amount", this.amount);
        compound.method_10569("VertexTime", this.vertexTime);
        class_2499 posList = new class_2499();
        for (class_2338 pos : this.nodePositions) {
            class_2487 posCompound = new class_2487();
            posCompound.method_10569("X", pos.method_10263());
            posCompound.method_10569("Y", pos.method_10264());
            posCompound.method_10569("Z", pos.method_10260());
            posList.add((Object)posCompound);
        }
        compound.method_10566("NodePositions", (class_2520)posList);
        return compound;
    }

    public static PastelTransmission fromNbt(class_2487 nbt) {
        ItemVariant variant = ItemVariant.fromNbt((class_2487)nbt.method_10562("Variant"));
        long amount = nbt.method_10537("Amount");
        int time = nbt.method_10550("VertexTime");
        ArrayList<class_2338> posList = new ArrayList<class_2338>();
        for (class_2520 e : nbt.method_10554("NodePositions", 10)) {
            class_2487 compound = (class_2487)e;
            class_2338 blockPos = new class_2338(compound.method_10550("X"), compound.method_10550("Y"), compound.method_10550("Z"));
            posList.add(blockPos);
        }
        return new PastelTransmission(posList, variant, amount, time);
    }

    public static void writeToBuf(class_2540 buf, PastelTransmission transfer) {
        buf.writeInt(transfer.nodePositions.size());
        for (class_2338 pos : transfer.nodePositions) {
            buf.method_10807(pos);
        }
        transfer.variant.toPacket(buf);
        buf.writeLong(transfer.amount);
        buf.writeInt(transfer.vertexTime);
    }

    public static PastelTransmission fromPacket(class_2540 buf) {
        int posCount = buf.readInt();
        ArrayList<class_2338> posList = new ArrayList<class_2338>();
        for (int i = 0; i < posCount; ++i) {
            posList.add(buf.method_10811());
        }
        ItemVariant variant = ItemVariant.fromPacket((class_2540)buf);
        long amount = buf.readLong();
        int time = buf.readInt();
        return new PastelTransmission(posList, variant, amount, time);
    }
}

