/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.nodes;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.decoration.SpectrumFacingBlock;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelNodeBlock
extends SpectrumFacingBlock
implements class_2343 {
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 EMITTING = class_2741.field_12484;
    public static final Map<class_2350, class_265> SHAPES = new HashMap<class_2350, class_265>(){
        {
            this.put(class_2350.field_11036, class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0));
            this.put(class_2350.field_11033, class_2248.method_9541((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
            this.put(class_2350.field_11043, class_2248.method_9541((double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)16.0));
            this.put(class_2350.field_11035, class_2248.method_9541((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)4.0));
            this.put(class_2350.field_11034, class_2248.method_9541((double)0.0, (double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0));
            this.put(class_2350.field_11039, class_2248.method_9541((double)12.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
        }
    };
    protected final PastelNodeType pastelNodeType;

    public PastelNodeBlock(class_4970.class_2251 settings, PastelNodeType pastelNodeType) {
        super(settings.method_9631(s -> (Boolean)s.method_11654((class_2769)LIT) != false ? 13 : 0));
        this.pastelNodeType = pastelNodeType;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EMITTING, (Comparable)Boolean.valueOf(false)));
    }

    public class_2464 method_9604(class_2680 state) {
        return SpectrumCommon.CONFIG.MinimalNodes ? class_2464.field_11456 : class_2464.field_11458;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 targetDirection = ((class_2350)state.method_11654((class_2769)field_10927)).method_10153();
        class_2338 targetPos = pos.method_10093(targetDirection);
        return world.method_8320(targetPos).method_51367();
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        PastelNodeBlockEntity blockEntity;
        if (!newState.method_27852(state.method_26204()) && (blockEntity = this.getBlockEntity((class_1936)world, pos)) != null) {
            blockEntity.onBroken();
            blockEntity.getOuterRing().ifPresent(r -> PastelNodeBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)r.upgradeItem.method_7854()));
            blockEntity.getInnerRing().ifPresent(r -> PastelNodeBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)r.upgradeItem.method_7854()));
            blockEntity.getRedstoneRing().ifPresent(r -> PastelNodeBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)r.upgradeItem.method_7854()));
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8038();
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(direction.method_10153()));
        return blockState.method_27852((class_2248)this) && blockState.method_11654((class_2769)field_10927) == direction ? (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)direction.method_10153()) : (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)direction);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (w, p, s, b) -> PastelNodeBlockEntity.tick(w, p, s, (PastelNodeBlockEntity)b);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        tooltip.addAll(this.pastelNodeType.getTooltips());
        tooltip.add((class_2561)class_2561.method_43469((String)"block.spectrum.pastel_network_nodes.tooltip.range", (Object[])new Object[]{12}).method_27692(class_124.field_1080));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LIT, EMITTING});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : state;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        @Nullable PastelNodeBlockEntity blockEntity = this.getBlockEntity((class_1936)world, pos);
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715() && stack.method_7960()) {
            class_1799 removed;
            if (AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)SpectrumAdvancements.PASTEL_NODE_UPGRADING) && !(removed = blockEntity.tryRemoveUpgrade()).method_7960()) {
                if (!player.method_31549().field_7477) {
                    player.method_31548().method_7398(removed);
                }
                blockEntity.updateUpgrades();
                return class_1269.method_29236((boolean)world.method_8608());
            }
            return class_1269.field_5814;
        }
        if (stack.method_31574(SpectrumItems.TUNING_STAMP)) {
            return class_1269.field_5811;
        }
        if (stack.method_31574(SpectrumItems.PAINTBRUSH)) {
            return PastelNodeBlock.sendDebugMessage(world, player, blockEntity);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)SpectrumAdvancements.PASTEL_NODE_UPGRADING) && stack.method_31573(SpectrumItemTags.PASTEL_NODE_UPGRADES) && blockEntity.tryInteractRings(stack, this.pastelNodeType)) {
            if (!world.method_8608()) {
                SpectrumAdvancementCriteria.PASTEL_NODE_UPGRADING.trigger((class_3222)player, stack);
            }
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            world.method_45446(pos, SpectrumSoundEvents.MEDIUM_CRYSTAL_RING, class_3419.field_15245, 0.25f, 0.9f + world.method_8409().method_43057() * 0.2f, true);
            blockEntity.updateUpgrades();
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (this.pastelNodeType.usesFilters()) {
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            player.method_17355((class_3908)blockEntity);
            return class_1269.field_21466;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)EMITTING) != false ? 15 : 0;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)EMITTING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    private static class_1269 sendDebugMessage(class_1937 world, class_1657 player, PastelNodeBlockEntity blockEntity) {
        if (world.field_9236) {
            if (blockEntity != null) {
                PastelNetwork network = blockEntity.parentNetwork;
                player.method_43496((class_2561)class_2561.method_43471((String)"block.spectrum.pastel_network_nodes.connection_debug"));
                if (network == null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"C: No connected network :("));
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)("C: " + network.getUUID().toString())));
                    player.method_43496((class_2561)class_2561.method_43470((String)("C: " + network.getNodeDebugText())));
                }
            }
            return class_1269.field_5812;
        }
        if (blockEntity != null) {
            PastelNetwork network = blockEntity.parentNetwork;
            if (network == null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"S: No connected network :("));
            } else {
                player.method_43496((class_2561)class_2561.method_43470((String)("S: " + network.getUUID().toString())));
                player.method_43496((class_2561)class_2561.method_43470((String)("S: " + network.getNodeDebugText())));
            }
        }
        return class_1269.field_21466;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654((class_2769)field_10927));
    }

    @Nullable
    public PastelNodeBlockEntity getBlockEntity(class_1936 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PastelNodeBlockEntity(pos, state);
    }
}

