/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.nodes;

import com.google.common.base.Predicates;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.FilterConfigurable;
import de.dafuqs.spectrum.api.item.StampDataCategory;
import de.dafuqs.spectrum.api.item.Stampable;
import de.dafuqs.spectrum.api.pastel.PastelUpgradeSignature;
import de.dafuqs.spectrum.api.pastel.PastelUpgradeable;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetworkManager;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlock;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.BlockReference;
import de.dafuqs.spectrum.helpers.LoreHelper;
import de.dafuqs.spectrum.inventories.FilteringScreenHandler;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumPastelUpgrades;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStampDataCategories;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelNodeBlockEntity
extends class_2586
implements FilterConfigurable,
ExtendedScreenHandlerFactory,
Stampable,
PastelUpgradeable {
    public static final int MAX_FILTER_SLOTS = 25;
    public static final int SLOTS_PER_ROW = 5;
    public static final int DEFAULT_FILTER_SLOT_ROWS = 1;
    public static final int RANGE = 12;
    @Nullable
    protected PastelNetwork parentNetwork;
    protected Optional<UUID> parentID = Optional.empty();
    protected Optional<PastelUpgradeSignature> outerRing;
    protected Optional<PastelUpgradeSignature> innerRing;
    protected Optional<PastelUpgradeSignature> redstoneRing;
    protected Set<class_2338> connectionMemory = new HashSet<class_2338>();
    protected long lastTransferTick = 0L;
    protected final long cachedRedstonePowerTick = 0L;
    protected boolean cachedUnpowered = true;
    protected PastelNetwork.Priority priority = PastelNetwork.Priority.GENERIC;
    protected long itemCountUnderway = 0L;
    protected boolean lit;
    protected boolean triggerTransfer;
    protected boolean triggered;
    protected boolean waiting;
    protected boolean lamp;
    protected boolean sensor;
    protected int transferCount = 1;
    protected int transferTime = 30;
    protected int filterSlotRows = 1;
    protected BlockApiCache<Storage<ItemVariant>, class_2350> connectedStorageCache = null;
    protected class_2350 cachedDirection = null;
    private final List<ItemVariant> filterItems = class_2371.method_10213((int)25, (Object)ItemVariant.blank());
    float rotationTarget;
    float crystalRotation;
    float lastRotationTarget;
    float heightTarget;
    float crystalHeight;
    float lastHeightTarget;
    float alphaTarget;
    float ringAlpha;
    float lastAlphaTarget;
    long creationStamp = -1L;
    long interpTicks;
    long interpLength = -1L;
    long spinTicks;
    private State state;
    public static final String GREATER_THAN_KEYWORD = "above";
    public static final String LESSER_THAN_KEYWORD = "below";
    public static final String DAMAGED_KEYWORD = "damaged";
    public static final String NOT_DAMAGED_KEYWORD = "not damaged";
    public static final String STRING_EMPTY_KEYWORD = "is empty";
    public static final String STRING_NOT_EMPTY_KEYWORD = "is not empty";
    public static final String ENCHANTMENT_MATCH_KEYWORD = "with";
    public static final String ENCHANTMENT_LEVEL_KEYWORD = "level";

    public PastelNodeBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.PASTEL_NODE, blockPos, blockState);
        this.outerRing = Optional.empty();
        this.innerRing = Optional.empty();
        this.redstoneRing = Optional.empty();
    }

    @Nullable
    public Storage<ItemVariant> getConnectedStorage() {
        if (this.connectedStorageCache == null) {
            class_2680 state = this.method_11010();
            if (!(state.method_26204() instanceof PastelNodeBlock)) {
                return null;
            }
            this.cachedDirection = (class_2350)state.method_11654((class_2769)PastelNodeBlock.field_10927);
            this.connectedStorageCache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016().method_10093(this.cachedDirection.method_10153()));
        }
        return (Storage)this.connectedStorageCache.find((Object)this.cachedDirection);
    }

    public static void tick(@NotNull class_1937 world, class_2338 pos, class_2680 state, PastelNodeBlockEntity node) {
        if (node.lamp && ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue() != node.canTransfer()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(node.cachedUnpowered)));
        }
        if (node.triggerTransfer) {
            boolean powered = world.method_49803(pos);
            if (node.waiting && !powered) {
                node.waiting = false;
            }
            if (!node.triggered && !node.waiting && powered) {
                node.triggered = true;
            }
        }
        if (world.method_8608()) {
            if (node.parentNetwork == null) {
                node.changeState(State.DISCONNECTED);
                node.interpLength = 17L;
            } else if (!node.canTransfer()) {
                node.changeState(State.INACTIVE);
                node.interpLength = 21L;
            } else if (node.spinTicks > 0L) {
                node.changeState(State.ACTIVE);
                node.interpLength = 17L;
            } else {
                node.changeState(State.CONNECTED);
                node.interpLength = 13L;
            }
            if (node.interpTicks < node.interpLength) {
                ++node.interpTicks;
            }
            if (node.spinTicks > 0L) {
                --node.spinTicks;
            }
        }
    }

    public void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.lastRotationTarget = this.crystalRotation;
            this.lastHeightTarget = this.crystalHeight;
            this.lastAlphaTarget = this.ringAlpha;
            this.interpTicks = 0L;
        }
    }

    public Optional<PastelUpgradeSignature> getInnerRing() {
        return this.innerRing;
    }

    public Optional<PastelUpgradeSignature> getOuterRing() {
        return this.outerRing;
    }

    public Optional<PastelUpgradeSignature> getRedstoneRing() {
        return this.redstoneRing;
    }

    public PastelNetwork.Priority getPriority() {
        return this.priority;
    }

    public boolean tryInteractRings(class_1799 item, PastelNodeType type) {
        PastelUpgradeSignature upgrade = SpectrumPastelUpgrades.of(item);
        if (upgrade.category.isRedstone()) {
            if (this.redstoneRing.isEmpty()) {
                this.redstoneRing = Optional.of(upgrade);
                return true;
            }
            return false;
        }
        if (this.outerRing.isEmpty() && type.hasOuterRing()) {
            this.outerRing = Optional.of(upgrade);
            return true;
        }
        if (this.innerRing.isEmpty()) {
            this.innerRing = Optional.of(upgrade);
            return true;
        }
        return false;
    }

    public class_1799 tryRemoveUpgrade() {
        class_1799 stack = class_1799.field_8037;
        if (this.redstoneRing.isPresent()) {
            stack = this.redstoneRing.get().upgradeItem.method_7854();
            this.redstoneRing = Optional.empty();
        } else if (this.innerRing.isPresent()) {
            stack = this.innerRing.get().upgradeItem.method_7854();
            this.innerRing = Optional.empty();
        } else if (this.outerRing.isPresent()) {
            stack = this.outerRing.get().upgradeItem.method_7854();
            this.outerRing = Optional.empty();
        }
        if (!stack.method_7960()) {
            this.field_11863.method_45446(this.field_11867, SpectrumSoundEvents.SHATTER_LIGHT, class_3419.field_15245, 0.25f, 0.9f + this.field_11863.method_8409().method_43057() * 0.2f, true);
            this.method_5431();
        }
        return stack;
    }

    public void updateUpgrades() {
        this.transferCount = 1;
        this.transferTime = 30;
        int oldFilterSlotCount = this.filterSlotRows;
        this.filterSlotRows = 1;
        this.triggerTransfer = false;
        this.lit = false;
        this.lamp = false;
        this.sensor = false;
        PastelNetwork.Priority oldPriority = this.priority;
        this.priority = PastelNetwork.Priority.GENERIC;
        this.outerRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, Collections.emptyList()));
        this.innerRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, this.outerRing.map(List::of).orElse(Collections.emptyList())));
        this.redstoneRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, Collections.emptyList()));
        this.transferCount = Math.max(this.transferCount, 1);
        this.transferTime = class_3532.method_15340((int)this.transferTime, (int)2, (int)100);
        this.filterSlotRows = class_3532.method_15340((int)this.filterSlotRows, (int)1, (int)5);
        if (this.lit && this.lamp) {
            this.lit = false;
        }
        if (this.parentNetwork != null) {
            this.parentNetwork.updateNodePriority(this, oldPriority);
        }
        if (this.field_11863 != null && (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12548) != this.lit) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(this.lit)));
        }
        if (this.filterSlotRows < oldFilterSlotCount) {
            for (int i = this.getDrawnSlots(); i < this.filterItems.size(); ++i) {
                this.filterItems.set(i, ItemVariant.blank());
            }
        }
        this.method_5431();
    }

    public Set<class_2338> getRememberedConnections() {
        return this.connectionMemory;
    }

    public void remember(PastelNodeBlockEntity otherNode) {
        if (this == otherNode) {
            throw new IllegalArgumentException("Tried to make a pastel node remember itself");
        }
        this.connectionMemory.add(otherNode.field_11867);
        this.method_5431();
    }

    public void forget(PastelNodeBlockEntity otherNode) {
        this.connectionMemory.remove(otherNode.field_11867);
        this.method_5431();
    }

    public void forgetAll() {
        this.connectionMemory.clear();
        this.method_5431();
    }

    @Override
    public void notifySensor() {
        if (this.field_11863 != null) {
            class_2680 state = this.method_11010();
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true)));
            if (!this.field_11863.method_8397().method_8674(this.field_11867, (Object)state.method_26204())) {
                this.field_11863.method_39279(this.field_11867, state.method_26204(), 2);
            }
        }
    }

    public long getMaxTransferredAmount() {
        return this.transferCount;
    }

    public int getTransferTime() {
        return this.transferTime;
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        if (this.creationStamp == -1L) {
            this.creationStamp = (world.method_8510() + (long)world.method_8409().method_43048(7)) % 20L;
        }
        if (!world.field_9236 && this.parentID.isPresent() && this.parentNetwork == null) {
            this.parentNetwork = Pastel.getServerInstance().joinOrCreateNetwork(this, this.parentID.get());
            this.parentID = Optional.empty();
        }
    }

    public float getRedstoneAlphaMult() {
        return this.redstoneRing.isPresent() ? 0.5f : 0.25f;
    }

    public boolean canTransfer() {
        boolean canTransfer;
        class_1269 result = this.redstoneRing.map(r -> r.preProcessor.apply(new PastelUpgradeSignature.RedstoneContext(this, this.field_11863, this.field_11867, this.cachedUnpowered))).orElse(class_1269.field_5811);
        if (result == class_1269.field_5812) {
            return true;
        }
        if (result == class_1269.field_5814) {
            return false;
        }
        long time = this.method_10997().method_8510();
        if (time > this.cachedRedstonePowerTick && !((Boolean)this.method_11010().method_11654((class_2769)PastelNodeBlock.EMITTING)).booleanValue()) {
            this.cachedUnpowered = this.field_11863.method_49804(this.field_11867) == 0;
        }
        boolean notPowered = this.redstoneRing.map(r -> {
            class_1269 post = r.postProcessor.apply(new PastelUpgradeSignature.RedstoneContext(this, this.field_11863, this.field_11867, this.cachedUnpowered));
            if (post == class_1269.field_5812) {
                return true;
            }
            if (post == class_1269.field_5814) {
                return false;
            }
            return this.cachedUnpowered;
        }).orElse(this.cachedUnpowered);
        boolean bl = canTransfer = this.method_10997().method_8510() > this.lastTransferTick;
        if (this.triggerTransfer) {
            return this.triggered && canTransfer;
        }
        return canTransfer && notPowered;
    }

    public void markTransferred() {
        if (this.triggerTransfer) {
            this.markTriggered();
        }
        this.lastTransferTick = this.field_11863.method_8510();
        this.method_5431();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("Network")) {
            UUID networkUUID = nbt.method_25926("Network");
            this.parentID = Optional.of(networkUUID);
            if (this.method_10997() != null) {
                this.parentNetwork = Pastel.getInstance(this.field_11863.field_9236).joinOrCreateNetwork(this, networkUUID);
            }
        }
        if (nbt.method_10545("Triggered")) {
            this.triggered = nbt.method_10577("Triggered");
        }
        if (nbt.method_10545("Waiting")) {
            this.waiting = nbt.method_10577("Waiting");
        }
        if (nbt.method_10545("creationStamp")) {
            this.creationStamp = nbt.method_10537("creationStamp");
        }
        if (nbt.method_10573("LastTransferTick", 4)) {
            this.lastTransferTick = nbt.method_10537("LastTransferTick");
        }
        if (nbt.method_10573("ItemCountUnderway", 4)) {
            this.itemCountUnderway = nbt.method_10537("ItemCountUnderway");
        }
        if (nbt.method_10545("OuterRing")) {
            this.outerRing = Optional.ofNullable((PastelUpgradeSignature)SpectrumRegistries.PASTEL_UPGRADE.method_10223(class_2960.method_12829((String)nbt.method_10558("OuterRing"))));
        }
        if (nbt.method_10545("InnerRing")) {
            this.innerRing = Optional.ofNullable((PastelUpgradeSignature)SpectrumRegistries.PASTEL_UPGRADE.method_10223(class_2960.method_12829((String)nbt.method_10558("InnerRing"))));
        }
        if (nbt.method_10545("RedstoneRing")) {
            this.redstoneRing = Optional.ofNullable((PastelUpgradeSignature)SpectrumRegistries.PASTEL_UPGRADE.method_10223(class_2960.method_12829((String)nbt.method_10558("RedstoneRing"))));
        }
        if (nbt.method_10545("ConnectionMemory")) {
            this.connectionMemory = Arrays.stream(nbt.method_10565("ConnectionMemory")).mapToObj(class_2338::method_10092).collect(Collectors.toSet());
        }
        if (this.getNodeType().usesFilters()) {
            FilterConfigurable.readFilterNbt(nbt, this.filterItems);
        }
        this.updateUpgrades();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.parentNetwork != null) {
            nbt.method_25927("Network", this.parentNetwork.getUUID());
        }
        if (this.creationStamp != -1L) {
            nbt.method_10544("creationStamp", this.creationStamp);
        }
        nbt.method_10556("Triggered", this.triggered);
        nbt.method_10556("Waiting", this.waiting);
        nbt.method_10544("LastTransferTick", this.lastTransferTick);
        nbt.method_10544("ItemCountUnderway", this.itemCountUnderway);
        if (this.getNodeType().usesFilters()) {
            FilterConfigurable.writeFilterNbt(nbt, this.filterItems);
        }
        this.outerRing.ifPresent(r -> nbt.method_10582("OuterRing", SpectrumPastelUpgrades.toString(r)));
        this.innerRing.ifPresent(r -> nbt.method_10582("InnerRing", SpectrumPastelUpgrades.toString(r)));
        this.redstoneRing.ifPresent(r -> nbt.method_10582("RedstoneRing", SpectrumPastelUpgrades.toString(r)));
        nbt.method_10538("ConnectionMemory", this.connectionMemory.stream().map(class_2338::method_10063).toList());
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    public void method_11012() {
        super.method_11012();
        Pastel.getInstance(this.field_11863.field_9236).removeNode(this, NodeRemovalReason.UNLOADED);
    }

    public void onBroken() {
        Pastel.getInstance(this.field_11863.field_9236).removeNode(this, NodeRemovalReason.BROKEN);
    }

    public boolean canConnect(PastelNodeBlockEntity node) {
        return this.field_11867.method_19771((class_2382)node.field_11867, 12.0);
    }

    @Nullable
    public PastelNetwork getParentNetwork() {
        return this.parentNetwork;
    }

    public PastelNodeType getNodeType() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof PastelNodeBlock) {
            PastelNodeBlock pastelNodeBlock = (PastelNodeBlock)class_22482;
            return pastelNodeBlock.pastelNodeType;
        }
        return PastelNodeType.CONNECTION;
    }

    public void setParentNetwork(PastelNetwork parentNetwork) {
        this.parentNetwork = parentNetwork;
        if (this.method_10997() != null && !this.method_10997().method_8608()) {
            this.updateInClientWorld();
            this.method_5431();
        }
    }

    public long getItemCountUnderway() {
        return this.itemCountUnderway;
    }

    public void addItemCountUnderway(long count) {
        this.itemCountUnderway += count;
        this.itemCountUnderway = Math.max(0L, this.itemCountUnderway);
        this.method_5431();
    }

    public void updateInClientWorld() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
    }

    @Override
    public List<ItemVariant> getItemFilters() {
        return this.filterItems;
    }

    @Override
    public void setFilterItem(int slot, ItemVariant item) {
        this.filterItems.set(slot, item);
    }

    public Predicate<ItemVariant> getTransferFilterTo(PastelNodeBlockEntity other) {
        if (this.getNodeType().usesFilters() && !this.hasEmptyFilter()) {
            if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
                return Predicates.and(this::filter, other::filter);
            }
            return this::filter;
        }
        if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
            return other::filter;
        }
        return itemVariant -> true;
    }

    private boolean filter(ItemVariant variant) {
        return this.filterItems.stream().anyMatch(filterItem -> {
            class_1799 filterStack = filterItem.toStack();
            if (LoreHelper.hasLore(filterStack)) {
                if (variant.getNbt() == null) {
                    return false;
                }
                for (class_2561 text : LoreHelper.getLoreList(filterStack)) {
                    if (this.testNBTPredicates(text.getString(), filterStack, variant)) continue;
                    return false;
                }
            }
            if (!filterStack.method_7938() || !filterStack.method_31573(SpectrumItemTags.TAG_FILTERING_ITEMS)) {
                return filterStack.method_7909() == variant.getItem();
            }
            String name = StringUtils.trim((String)filterStack.method_7964().getString());
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{"*", "any", "all", "everything", "c:*", "c:any", "c:all", "c:everything"})) {
                return true;
            }
            class_2960 id = class_2960.method_12829((String)StringUtils.remove((String)name, (char)'#'));
            if (id == null) {
                return false;
            }
            class_6862 tag = SpectrumCommon.CACHED_ITEM_TAG_MAP.computeIfAbsent(id, tagId -> class_7923.field_41178.method_40273().filter((? super T t) -> t.comp_327().equals(tagId)).findFirst().orElse(null));
            if (tag == null) {
                return false;
            }
            return variant.getItem().method_40131().method_40220(tag);
        });
    }

    public boolean testNBTPredicates(String description, class_1799 stack, ItemVariant variant) {
        class_2487 tested = variant.getNbt();
        String cleanString = StringUtils.trim((String)description);
        String[] pieces = StringUtils.splitByWholeSeparator((String)cleanString, null);
        String target = pieces[0];
        String predicateString = StringUtils.remove((String)cleanString, (String)target);
        class_2487 source = stack.method_7969();
        boolean nullSourceFilter = false;
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)target, (CharSequence[])new CharSequence[]{"durability", "uses"})) {
            target = "Damage";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)target, (CharSequence[])new CharSequence[]{"enchs", "enchants", "enchantment"})) {
            target = "Enchantments";
        }
        assert (source != null);
        if (source.method_10545(target) && !tested.method_10545(target)) {
            return false;
        }
        if (!source.method_10545(target) && tested.method_10545(target)) {
            nullSourceFilter = true;
        }
        class_2520 sourceData = source.method_10580(target);
        class_2520 testedData = tested.method_10580(target);
        assert (nullSourceFilter || sourceData != null);
        assert (testedData != null);
        if (!nullSourceFilter && sourceData.method_10711() != testedData.method_10711()) {
            return false;
        }
        boolean lessThan = StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)LESSER_THAN_KEYWORD);
        boolean moreThan = StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)GREATER_THAN_KEYWORD);
        if (target.equals("Enchantments") || target.equals("StoredEnchantments")) {
            if (testedData.method_10711() != 9) {
                return false;
            }
            Map testedEnchants = class_1890.method_22445((class_2499)((class_2499)testedData));
            if (StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)ENCHANTMENT_MATCH_KEYWORD)) {
                String potentialEnchant;
                String noKeyWordString = StringUtils.remove((String)predicateString, (String)ENCHANTMENT_MATCH_KEYWORD);
                String[] potentialEnchants = StringUtils.splitByWholeSeparator((String)noKeyWordString, null);
                Optional enchantment = Optional.empty();
                String[] stringArray = potentialEnchants;
                int n = stringArray.length;
                for (int i = 0; i < n && !(enchantment = class_7923.field_41176.method_17966(class_2960.method_12829((String)(potentialEnchant = stringArray[i])))).isPresent(); ++i) {
                }
                if (enchantment.isEmpty()) {
                    return false;
                }
                if (!testedEnchants.containsKey(enchantment.get())) {
                    return false;
                }
                if (StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)ENCHANTMENT_LEVEL_KEYWORD)) {
                    return (long)((Integer)testedEnchants.get(enchantment.get())).intValue() == Math.round(PastelNodeBlockEntity.getNumber(noKeyWordString));
                }
                if (lessThan) {
                    return (long)((Integer)testedEnchants.get(enchantment.get())).intValue() < Math.round(PastelNodeBlockEntity.getNumber(noKeyWordString));
                }
                if (moreThan) {
                    return (long)((Integer)testedEnchants.get(enchantment.get())).intValue() > Math.round(PastelNodeBlockEntity.getNumber(noKeyWordString));
                }
                return true;
            }
            if (nullSourceFilter) {
                return true;
            }
            return class_1890.method_8222((class_1799)stack).keySet().stream().allMatch(testedEnchants::containsKey);
        }
        switch (testedData.method_10711()) {
            case 99: {
                double testedNum = ((class_2514)testedData).method_10697();
                if (target.equals("Damage")) {
                    if (StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)DAMAGED_KEYWORD)) {
                        return testedNum > 0.0;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)NOT_DAMAGED_KEYWORD)) {
                        return class_3532.method_20390((double)testedNum, (double)0.0);
                    }
                }
                if (lessThan) {
                    double comparator = PastelNodeBlockEntity.getNumber(predicateString);
                    return testedNum < comparator;
                }
                if (moreThan) {
                    double comparator = PastelNodeBlockEntity.getNumber(predicateString);
                    return testedNum < comparator;
                }
                if (nullSourceFilter) {
                    return true;
                }
                return class_3532.method_20390((double)((class_2514)sourceData).method_10697(), (double)testedNum);
            }
            case 8: {
                String testedString = testedData.method_10714();
                if (StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)STRING_EMPTY_KEYWORD)) {
                    return StringUtils.isBlank((CharSequence)testedString);
                }
                if (StringUtils.containsIgnoreCase((CharSequence)predicateString, (CharSequence)STRING_NOT_EMPTY_KEYWORD)) {
                    return StringUtils.isNotBlank((CharSequence)testedString);
                }
                if (nullSourceFilter) {
                    return true;
                }
                return StringUtils.equalsIgnoreCase((CharSequence)sourceData.method_10714(), (CharSequence)testedString);
            }
        }
        if (nullSourceFilter) {
            return true;
        }
        return sourceData.method_10714().equals(testedData.method_10714());
    }

    private static double getNumber(String predicateString) {
        double comparator;
        try {
            comparator = Double.parseDouble(StringUtils.getDigits((String)predicateString));
        }
        catch (NumberFormatException ignored) {
            comparator = 0.0;
        }
        return comparator;
    }

    public long getCreationStamp() {
        return this.creationStamp;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.spectrum.pastel_node");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new FilteringScreenHandler(syncId, inv, this);
    }

    @Override
    public int getFilterRows() {
        return this.filterSlotRows;
    }

    @Override
    public int getDrawnSlots() {
        return this.getFilterRows() * 5;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        FilterConfigurable.writeScreenOpeningData(buf, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PastelNodeBlockEntity)) return false;
        PastelNodeBlockEntity blockEntity = (PastelNodeBlockEntity)obj;
        if (!this.field_11867.equals((Object)blockEntity.field_11867)) return false;
        return true;
    }

    public int hashCode() {
        return this.field_11867.hashCode();
    }

    @Override
    public Stampable.StampData recordStampData(Optional<class_1657> user, BlockReference reference, class_1937 world) {
        return new Stampable.StampData(user.map(class_1297::method_5667), reference, (Stampable)this);
    }

    @Override
    public boolean handleImpression(Optional<UUID> stamper, Optional<class_1657> user, BlockReference reference, class_1937 world) {
        PastelNodeBlockEntity sourceNode = (PastelNodeBlockEntity)reference.tryGetBlockEntity().orElseThrow(() -> new IllegalStateException("Attempted to connect a non-existent node - what did you do?!"));
        PastelNetworkManager manager = Pastel.getInstance(world.method_8608());
        if (!sourceNode.canConnect(this)) {
            return false;
        }
        if (sourceNode.parentNetwork != null && sourceNode.parentNetwork == this.parentNetwork) {
            if (manager.tryRemoveEdge(this, sourceNode)) {
                return true;
            }
            return manager.tryAddEdge(this, sourceNode);
        }
        if (sourceNode.parentID.map(uuid -> uuid.equals(this.parentID.orElse(null))).orElse(false).booleanValue()) {
            return false;
        }
        manager.connectNodes(this, sourceNode);
        if (this.parentNetwork != null) {
            user.filter((? super T u) -> u instanceof class_3222).ifPresent(p -> SpectrumAdvancementCriteria.PASTEL_NETWORK_CREATING.trigger((class_3222)p, (ServerPastelNetwork)this.parentNetwork));
        }
        return true;
    }

    @Override
    public void clearImpression() {
        if (this.parentNetwork != null) {
            Pastel.getInstance(this.field_11863.method_8608()).removeNode(this, NodeRemovalReason.DISCONNECT);
            this.parentNetwork = null;
            this.parentID = Optional.empty();
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public StampDataCategory getStampCategory() {
        return SpectrumStampDataCategories.PASTEL;
    }

    @Override
    public boolean canUserStamp(Optional<class_1657> stamper) {
        return true;
    }

    @Override
    public void onImpressedOther(Stampable.StampData data, boolean success) {
    }

    public void setSpinTicks(long spinTicks) {
        this.spinTicks = spinTicks;
    }

    @Override
    public void markLit() {
        this.lit = true;
    }

    @Override
    public void markLamp() {
        this.lamp = true;
    }

    @Override
    public void markTriggerTransfer() {
        this.triggerTransfer = true;
    }

    @Override
    public void markSensor() {
        this.sensor = true;
    }

    @Override
    public void markTriggered() {
        this.triggered = false;
        this.waiting = true;
    }

    @Override
    public boolean isTriggerTransfer() {
        return this.triggerTransfer;
    }

    @Override
    public boolean isSensor() {
        return this.sensor;
    }

    @Override
    public void applySlotUpgrade(PastelUpgradeSignature upgrade) {
        this.filterSlotRows += this.getNodeType().hasOuterRing() ? upgrade.slotRows : upgrade.slotRows * 2;
    }

    @Override
    public void applySimple(PastelUpgradeSignature upgrade) {
        this.transferCount += upgrade.stack;
        this.transferTime += upgrade.speed;
    }

    @Override
    public void applyCompounding(PastelUpgradeSignature upgrade) {
        this.transferCount = Math.round((float)this.transferCount * upgrade.stackMult);
        this.transferTime = Math.round((float)this.transferTime * upgrade.speedMult);
    }

    @Override
    public void upgradePriority() {
        this.priority = this.priority == PastelNetwork.Priority.GENERIC ? PastelNetwork.Priority.MODERATE : PastelNetwork.Priority.HIGH;
    }

    public static enum State {
        DISCONNECTED,
        CONNECTED,
        ACTIVE,
        INACTIVE;

    }
}

