/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.redstone;

import de.dafuqs.spectrum.blocks.redstone.BlockBreakerBlockEntity;
import de.dafuqs.spectrum.blocks.redstone.RedstoneInteractionBlock;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_4970;
import net.minecraft.class_5000;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class BlockBreakerBlock
extends RedstoneInteractionBlock
implements class_2343 {
    private static class_1799 BREAK_STACK;

    public BlockBreakerBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BlockBreakerBlockEntity(pos, state);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        if (placer instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)placer;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof BlockBreakerBlockEntity) {
                BlockBreakerBlockEntity blockBreakerBlockEntity = (BlockBreakerBlockEntity)blockEntity;
                blockBreakerBlockEntity.setOwner((class_1657)serverPlayerEntity);
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        boolean isTriggered = world.method_49803(pos) || world.method_49803(pos.method_10084());
        boolean wasTriggered = (Boolean)state.method_11654((class_2769)TRIGGERED);
        if (isTriggered && !wasTriggered) {
            if (!world.field_9236) {
                this.destroy(world, pos, ((class_5000)state.method_11654((class_2769)ORIENTATION)).method_26426());
            }
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isTriggered && wasTriggered) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    protected void destroy(class_1937 world, class_2338 breakerPos, class_2350 direction) {
        class_2338 breakingPos = breakerPos.method_10093(direction);
        class_2680 blockState = world.method_8320(breakingPos);
        if (blockState.method_26215() || blockState.method_26204() instanceof class_4770) {
            return;
        }
        float hardness = blockState.method_26214((class_1922)world, breakingPos);
        if (hardness < 0.0f || hardness > 50.0f) {
            world.method_8396(null, breakerPos, class_3417.field_15082, class_3419.field_15245, 0.15f, 2.0f + world.field_9229.method_43057());
            return;
        }
        class_2586 blockEntity = world.method_8321(breakerPos);
        if (!(blockEntity instanceof BlockBreakerBlockEntity)) {
            return;
        }
        BlockBreakerBlockEntity blockBreakerBlockEntity = (BlockBreakerBlockEntity)blockEntity;
        class_1657 owner = blockBreakerBlockEntity.getOwnerIfOnline();
        if (!GenericClaimModsCompat.canBreak(world, breakingPos, (class_1297)owner)) {
            return;
        }
        this.breakBlock(world, breakingPos, owner);
        class_243 centerPos = class_243.method_24953((class_2382)breakingPos);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11236, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), 1, 0.0, 0.0, 0.0, 1.0);
    }

    public void breakBlock(class_1937 world, class_2338 pos, class_1657 breaker) {
        class_2586 blockEntity;
        class_2680 blockState = world.method_8320(pos);
        class_3610 fluidState = world.method_8316(pos);
        world.method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
        world.method_8396(null, pos, blockState.method_26231().method_10595(), class_3419.field_15245, 0.2f, (1.0f + world.field_9229.method_43057()) * 2.0f);
        class_2586 class_25862 = blockEntity = blockState.method_31709() ? world.method_8321(pos) : null;
        if (BREAK_STACK == null) {
            BREAK_STACK = new class_1799((class_1935)SpectrumItems.MALACHITE_WORKSTAFF);
        }
        class_2248.method_9511((class_2680)blockState, (class_1937)world, (class_2338)pos, (class_2586)blockEntity, (class_1297)breaker, (class_1799)BREAK_STACK);
        if (world.method_30092(pos, fluidState.method_15759(), 3, 512)) {
            world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)breaker, (class_2680)blockState));
        }
    }
}

