/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.shooting_star;

import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumLootTables;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public interface ShootingStar {

    public static enum Type {
        GLISTERING("glistering", SpectrumLootTables.GLISTERING_SHOOTING_STAR),
        FIERY("fiery", SpectrumLootTables.FIERY_SHOOTING_STAR),
        COLORFUL("colorful", SpectrumLootTables.COLORFUL_SHOOTING_STAR),
        PRISTINE("pristine", SpectrumLootTables.PRISTINE_SHOOTING_STAR),
        GEMSTONE("gemstone", SpectrumLootTables.GEMSTONE_SHOOTING_STAR);

        private final String name;
        private final class_2960 lootTable;

        private Type(String name, class_2960 lootTable) {
            this.name = name;
            this.lootTable = lootTable;
        }

        public static Type getWeightedRandomType(@NotNull class_5819 random) {
            int r = random.method_43048(8);
            if (r == 0) {
                return FIERY;
            }
            if (r == 1) {
                return PRISTINE;
            }
            if (r < 3) {
                return GLISTERING;
            }
            if (r < 5) {
                return COLORFUL;
            }
            return GEMSTONE;
        }

        public static Type getType(int type) {
            Type[] types = Type.values();
            if (type < 0 || type >= types.length) {
                type = 0;
            }
            return types[type];
        }

        public static Type getType(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }

        @Contract(value="_ -> new")
        @NotNull
        public static class_2960 getLootTableIdentifier(int index) {
            return Type.values()[index].getLootTableIdentifier();
        }

        @NotNull
        public class_2960 getLootTableIdentifier() {
            return this.lootTable;
        }

        public String getName() {
            return this.name;
        }

        public class_2248 getBlock() {
            switch (this.ordinal()) {
                case 3: {
                    return SpectrumBlocks.PRISTINE_SHOOTING_STAR;
                }
                case 4: {
                    return SpectrumBlocks.GEMSTONE_SHOOTING_STAR;
                }
                case 1: {
                    return SpectrumBlocks.FIERY_SHOOTING_STAR;
                }
                case 2: {
                    return SpectrumBlocks.COLORFUL_SHOOTING_STAR;
                }
            }
            return SpectrumBlocks.GLISTERING_SHOOTING_STAR;
        }

        @NotNull
        public Vector3f getRandomParticleColor(class_5819 random) {
            switch (this.ordinal()) {
                case 0: {
                    int r = random.method_43048(5);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(class_1767.field_7947);
                    }
                    if (r == 1) {
                        return ColorHelper.getRGBVec(class_1767.field_7952);
                    }
                    if (r == 2) {
                        return ColorHelper.getRGBVec(class_1767.field_7946);
                    }
                    if (r == 3) {
                        return ColorHelper.getRGBVec(class_1767.field_7961);
                    }
                    return ColorHelper.getRGBVec(class_1767.field_7966);
                }
                case 2: {
                    return ColorHelper.getRGBVec(ColorHelper.VANILLA_DYE_COLORS.get(random.method_43048(ColorHelper.VANILLA_DYE_COLORS.size())));
                }
                case 1: {
                    int r = random.method_43048(2);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(class_1767.field_7946);
                    }
                    return ColorHelper.getRGBVec(class_1767.field_7964);
                }
                case 3: {
                    int r = random.method_43048(3);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(class_1767.field_7966);
                    }
                    if (r == 1) {
                        return ColorHelper.getRGBVec(class_1767.field_7951);
                    }
                    return ColorHelper.getRGBVec(class_1767.field_7955);
                }
            }
            int r = random.method_43048(4);
            if (r == 0) {
                return ColorHelper.getRGBVec(class_1767.field_7955);
            }
            if (r == 1) {
                return ColorHelper.getRGBVec(class_1767.field_7958);
            }
            if (r == 2) {
                return ColorHelper.getRGBVec(class_1767.field_7952);
            }
            return ColorHelper.getRGBVec(class_1767.field_7947);
        }
    }
}

