/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.upgrade;

import de.dafuqs.spectrum.blocks.upgrade.UpgradeBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.effect.ColoredTransmission;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5707;
import net.minecraft.class_5716;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeBlock
extends class_2237 {
    protected static final class_265 SHAPE_UP = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    private static final List<class_2248> upgradeBlocks = new ArrayList<class_2248>();
    private final List<class_2382> possibleUpgradeBlockOffsets = new ArrayList<class_2382>(){
        {
            this.add(new class_2382(3, -2, 3));
            this.add(new class_2382(-3, -2, 3));
            this.add(new class_2382(3, -2, -3));
            this.add(new class_2382(-3, -2, -3));
            this.add(new class_2382(2, 0, 2));
            this.add(new class_2382(-2, 0, 2));
            this.add(new class_2382(2, 0, -2));
            this.add(new class_2382(-2, 0, -2));
            this.add(new class_2382(3, 0, 3));
            this.add(new class_2382(-3, 0, 3));
            this.add(new class_2382(3, 0, -3));
            this.add(new class_2382(-3, 0, -3));
            this.add(new class_2382(4, -1, 4));
            this.add(new class_2382(-4, -1, 4));
            this.add(new class_2382(4, -1, -4));
            this.add(new class_2382(-4, -1, -4));
            this.add(new class_2382(1, -1, 2));
            this.add(new class_2382(-1, -1, 2));
            this.add(new class_2382(1, -1, -2));
            this.add(new class_2382(-1, -1, -2));
            this.add(new class_2382(2, -1, 1));
            this.add(new class_2382(-2, -1, 1));
            this.add(new class_2382(2, -1, -1));
            this.add(new class_2382(-2, -1, -1));
        }
    };
    private final Upgradeable.UpgradeType upgradeType;
    private final int upgradeMod;
    private final class_1767 effectColor;

    public UpgradeBlock(class_4970.class_2251 settings, Upgradeable.UpgradeType upgradeType, int upgradeMod, class_1767 effectColor) {
        super(settings);
        this.upgradeType = upgradeType;
        this.upgradeMod = upgradeMod;
        this.effectColor = effectColor;
        upgradeBlocks.add((class_2248)this);
    }

    public static List<class_2248> getUpgradeBlocks() {
        return upgradeBlocks;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_UP;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.field_9236) {
            this.updateConnectedUpgradeBlock((class_3218)world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!world.field_9236) {
            this.updateConnectedUpgradeBlock((class_3218)world, pos);
        }
    }

    private void updateConnectedUpgradeBlock(@NotNull class_3218 world, @NotNull class_2338 pos) {
        for (class_2382 possibleUpgradeBlockOffset : this.possibleUpgradeBlockOffsets) {
            class_2338 currentPos = pos.method_10081(possibleUpgradeBlockOffset);
            class_2586 blockEntity = world.method_8321(currentPos);
            if (!(blockEntity instanceof Upgradeable)) continue;
            Upgradeable upgradeable = (Upgradeable)blockEntity;
            upgradeable.resetUpgrades();
            this.playConnectedParticles(world, pos, currentPos);
        }
    }

    private void playConnectedParticles(@NotNull class_3218 world, @NotNull class_2338 pos, class_2338 currentPos) {
        class_1767 particleColor = this.getEffectColor();
        world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.ENCHANTER_DING, class_3419.field_15245, 1.0f, 1.0f);
        SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity(world, class_243.method_24953((class_2382)pos), SpectrumParticleTypes.getSparkleRisingParticle(particleColor), 10, new class_243(0.5, 0.5, 0.5), new class_243(0.1, 0.1, 0.1));
        SpectrumS2CPacketSender.playColorTransmissionParticle(world, new ColoredTransmission(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5), (class_5716)new class_5707(currentPos), 6, particleColor));
    }

    private class_1767 getEffectColor() {
        return this.effectColor;
    }

    public Upgradeable.UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public int getUpgradeMod() {
        return this.upgradeMod;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new UpgradeBlockEntity(pos, state);
    }
}

