/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.weathering;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5547;

public interface Weathering
extends class_5547<WeatheringLevel> {
    public static final Supplier<BiMap<class_2248, class_2248>> WEATHERING_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)SpectrumBlocks.POLISHED_SHALE_CLAY, (Object)SpectrumBlocks.EXPOSED_POLISHED_SHALE_CLAY).put((Object)SpectrumBlocks.EXPOSED_POLISHED_SHALE_CLAY, (Object)SpectrumBlocks.WEATHERED_POLISHED_SHALE_CLAY).put((Object)SpectrumBlocks.POLISHED_SHALE_CLAY_STAIRS, (Object)SpectrumBlocks.EXPOSED_POLISHED_SHALE_CLAY_STAIRS).put((Object)SpectrumBlocks.EXPOSED_POLISHED_SHALE_CLAY_STAIRS, (Object)SpectrumBlocks.WEATHERED_POLISHED_SHALE_CLAY_STAIRS).put((Object)SpectrumBlocks.POLISHED_SHALE_CLAY_SLAB, (Object)SpectrumBlocks.EXPOSED_POLISHED_SHALE_CLAY_SLAB).put((Object)SpectrumBlocks.EXPOSED_POLISHED_SHALE_CLAY_SLAB, (Object)SpectrumBlocks.WEATHERED_POLISHED_SHALE_CLAY_SLAB).put((Object)SpectrumBlocks.SHALE_CLAY_BRICKS, (Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_BRICKS).put((Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_BRICKS, (Object)SpectrumBlocks.WEATHERED_SHALE_CLAY_BRICKS).put((Object)SpectrumBlocks.SHALE_CLAY_BRICK_STAIRS, (Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_BRICK_STAIRS).put((Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_BRICK_STAIRS, (Object)SpectrumBlocks.WEATHERED_SHALE_CLAY_BRICK_STAIRS).put((Object)SpectrumBlocks.SHALE_CLAY_BRICK_SLAB, (Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_BRICK_SLAB).put((Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_BRICK_SLAB, (Object)SpectrumBlocks.WEATHERED_SHALE_CLAY_BRICK_SLAB).put((Object)SpectrumBlocks.SHALE_CLAY_TILES, (Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_TILES).put((Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_TILES, (Object)SpectrumBlocks.WEATHERED_SHALE_CLAY_TILES).put((Object)SpectrumBlocks.SHALE_CLAY_TILE_STAIRS, (Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_TILE_STAIRS).put((Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_TILE_STAIRS, (Object)SpectrumBlocks.WEATHERED_SHALE_CLAY_TILE_STAIRS).put((Object)SpectrumBlocks.SHALE_CLAY_TILE_SLAB, (Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_TILE_SLAB).put((Object)SpectrumBlocks.EXPOSED_SHALE_CLAY_TILE_SLAB, (Object)SpectrumBlocks.WEATHERED_SHALE_CLAY_TILE_SLAB).build());
    public static final Supplier<BiMap<class_2248, class_2248>> WEATHERING_LEVEL_DECREASES = Suppliers.memoize(() -> WEATHERING_LEVEL_INCREASES.get().inverse());

    public static Optional<class_2248> getDecreasedWeatheredBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)WEATHERING_LEVEL_DECREASES.get().get((Object)block));
    }

    public static class_2248 getUnaffectedWeatheredBlock(class_2248 block) {
        class_2248 returnBlock = block;
        class_2248 block3 = (class_2248)WEATHERING_LEVEL_DECREASES.get().get((Object)block);
        while (block3 != null) {
            returnBlock = block3;
            block3 = (class_2248)WEATHERING_LEVEL_DECREASES.get().get((Object)block3);
        }
        return returnBlock;
    }

    public static Optional<class_2680> getDecreasedWeatheredState(class_2680 state) {
        return Weathering.getDecreasedWeatheredBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2248> getIncreasedWeatheredBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)WEATHERING_LEVEL_INCREASES.get().get((Object)block));
    }

    public static class_2680 getUnaffectedWeatheredState(class_2680 state) {
        return Weathering.getUnaffectedWeatheredBlock(state.method_26204()).method_34725(state);
    }

    default public Optional<class_2680> method_31639(class_2680 state) {
        return Weathering.getIncreasedWeatheredBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    default public float method_33620() {
        return this.method_33622() == WeatheringLevel.UNAFFECTED ? 0.75f : 1.0f;
    }

    default public boolean shouldTryWeather(class_1937 world, class_2338 pos) {
        float chance;
        float f = chance = world.method_8311(pos) ? 0.5f : 0.0f;
        if (world.method_8419() && ((class_1959)world.method_23753(pos).comp_349()).method_48162(pos) != class_1959.class_1963.field_9384) {
            chance = (float)((double)chance + 0.5);
        }
        return world.field_9229.method_43057() < chance;
    }

    public static enum WeatheringLevel {
        UNAFFECTED,
        EXPOSED,
        WEATHERED;

    }
}

