/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.cca;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeProvider;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEntityTypeTags;
import de.dafuqs.spectrum.sound.OnPrimordialFireSoundInstance;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalEntityTypeTags;
import net.minecraft.class_1113;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1900;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class OnPrimordialFireComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final float BASE_PERCENT_DAMAGE = 0.01f;
    public static final float FIRE_RESISTANCE_DAMAGE_RESISTANCE = 0.25f;
    public static final float FIRE_PROT_DAMAGE_RESISTANCE = 0.05f;
    @Environment(value=EnvType.CLIENT)
    private static Optional<OnPrimordialFireSoundInstance> soundInstance = Optional.empty();
    public static final ComponentKey<OnPrimordialFireComponent> ON_PRIMORDIAL_FIRE_COMPONENT = ComponentRegistry.getOrCreate((class_2960)SpectrumCommon.locate("on_primordial_fire"), OnPrimordialFireComponent.class);
    private class_1309 provider;
    private long primordialFireTicks = 0L;

    public OnPrimordialFireComponent() {
    }

    public OnPrimordialFireComponent(class_1309 entity) {
        this.provider = entity;
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        if (this.primordialFireTicks > 0L) {
            tag.method_10544("ticks", this.primordialFireTicks);
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.primordialFireTicks = tag.method_10573("ticks", 4) ? tag.method_10537("ticks") : 0L;
    }

    public static void setPrimordialFireTicks(class_1309 livingEntity, int ticks) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        component.primordialFireTicks = ticks;
        ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)component.provider);
    }

    public static void addPrimordialFireTicks(class_1309 livingEntity, int ticks) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        ticks = class_1900.method_8238((class_1309)livingEntity, (int)ticks);
        component.primordialFireTicks += (long)ticks;
        ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)component.provider);
    }

    public static boolean isOnPrimordialFire(class_1309 livingEntity) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        return component.primordialFireTicks > 0L;
    }

    public static boolean putOut(class_1309 livingEntity) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        if (component.primordialFireTicks > 0L) {
            component.primordialFireTicks = 0L;
            ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)component.provider);
            return true;
        }
        return false;
    }

    public void serverTick() {
        if (this.provider.method_5864().method_20210(SpectrumEntityTypeTags.PRIMORDIAL_FIRE_IMMUNE)) {
            this.primordialFireTicks = 0L;
            ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)this.provider);
            return;
        }
        if (this.primordialFireTicks > 0L) {
            if (!this.isAffectingConstruct()) {
                float damageScaling = this.getDamageHealthScaling(this.provider);
                this.provider.method_5643(SpectrumDamageTypes.primordialFire(this.provider.method_37908()), AzureDikeProvider.absorbDamage(this.provider, damageScaling * this.provider.method_6063()));
            } else if (this.provider.field_6012 % 10 == 0) {
                this.provider.method_5643(SpectrumDamageTypes.primordialFire(this.provider.method_37908()), 1.0f);
            }
            this.primordialFireTicks -= this.provider.method_5861(class_3486.field_15517) > 0.0 ? 3L : 1L;
            if (this.primordialFireTicks <= 0L) {
                ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)this.provider);
            }
        }
    }

    public boolean isAffectingConstruct() {
        return this.provider.method_5864().method_20210(SpectrumEntityTypeTags.SOULLESS);
    }

    public float getDamageHealthScaling(class_1309 entity) {
        float baseDamage = 0.01f;
        if (entity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) {
            baseDamage /= 20.0f;
        }
        return baseDamage * this.getDamagePenalties(entity) * this.getDamageBonuses(entity);
    }

    public float getDamagePenalties(class_1309 entity) {
        float fireProt = Math.min(0.05f * (float)class_1890.method_8203((class_1887)class_1893.field_9095, (class_1309)this.provider), 0.5f);
        int fireResLevel = Optional.ofNullable(this.provider.method_6112(class_1294.field_5918)).map(class_1293::method_5578).orElse(-1) + 1;
        float fireRes = 0.0f;
        if (fireResLevel > 0) {
            fireRes = 0.25f;
        }
        for (int i = 1; i < fireResLevel; ++i) {
            fireRes += (float)(0.05 * (double)i + 0.25 * Math.pow(0.5, i));
        }
        float immunityReduction = entity.method_5753() ? 0.25f : 0.0f;
        return Math.max(1.0f - (fireRes + fireProt + immunityReduction), 0.1f);
    }

    public float getDamageBonuses(class_1309 entity) {
        return 1.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public void clientTick() {
        if (this.primordialFireTicks > 0L) {
            double fluidHeight;
            if (this.provider.equals((Object)class_310.method_1551().field_1724) && this.primordialFireTicks > 2L && soundInstance.isEmpty()) {
                soundInstance = Optional.of(new OnPrimordialFireSoundInstance((class_1657)this.provider));
                class_310.method_1551().method_1483().method_4873((class_1113)soundInstance.get());
            }
            if ((fluidHeight = this.provider.method_5861(class_3486.field_15517)) > 0.0) {
                class_1937 world = this.provider.method_37908();
                class_5819 random = world.field_9229;
                class_243 pos = this.provider.method_19538();
                for (int i = 0; i < 2; ++i) {
                    world.method_8406((class_2394)class_2398.field_11241, this.provider.method_23322(1.0), pos.method_10214() + Math.min(fluidHeight, (double)this.provider.method_17682()) * (double)random.method_43057(), this.provider.method_23325(1.0), 0.0, 0.04, 0.0);
                    world.method_8406((class_2394)class_2398.field_11251, this.provider.method_23322(1.0), pos.method_10214() + Math.min(fluidHeight, (double)this.provider.method_17682()) * (double)random.method_43057(), this.provider.method_23325(1.0), 0.0, 0.04, 0.0);
                }
                if (world.field_9229.method_43048(12) == 0) {
                    this.provider.method_5783(class_3417.field_15102, 0.2f + random.method_43057() * 0.2f, 0.9f + random.method_43057() * 0.15f);
                }
            }
        } else if (this.provider.equals((Object)class_310.method_1551().field_1724) && soundInstance.isPresent()) {
            soundInstance = Optional.empty();
        }
    }
}

