/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.commands;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionCategoryContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.dafuqs.revelationary.RevelationRegistry;
import de.dafuqs.revelationary.advancement_criteria.AdvancementCountCriterion;
import de.dafuqs.revelationary.advancement_criteria.AdvancementGottenCriterion;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.color.ColorRegistry;
import de.dafuqs.spectrum.api.item.ExtendedEnchantable;
import de.dafuqs.spectrum.api.item.GemstoneColor;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.blocks.PlacedItemBlock;
import de.dafuqs.spectrum.blocks.deeper_down.flora.WeepingGalaFrondsBlock;
import de.dafuqs.spectrum.blocks.gemstone.SpectrumBuddingBlock;
import de.dafuqs.spectrum.compat.modonomicon.pages.BookHintPage;
import de.dafuqs.spectrum.enchantments.SpectrumEnchantment;
import de.dafuqs.spectrum.items.GuidebookItem;
import de.dafuqs.spectrum.items.PigmentItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.recipe.pedestal.BuiltinGemstoneColor;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import de.dafuqs.spectrum.registries.SpectrumItemGroups;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.mininglevel.v1.FabricMineableTags;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_175;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_39;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_55;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

public class SanityCommand {
    private static final class_2960 WIP_ADVANCEMENT_ID = SpectrumCommon.locate("__wip");
    private static final List<class_2960> ADVANCEMENT_GATING_WARNING_WHITELIST = List.of(SpectrumCommon.locate("find_preservation_ruins"), SpectrumCommon.locate("fail_to_glitch_into_preservation_ruin"), SpectrumCommon.locate("midgame/craft_blacklisted_memory_success"), SpectrumCommon.locate("lategame/collect_myceylon"), SpectrumCommon.locate("lategame/strike_up_hummingstone_hymn"));
    private static final List<class_2960> GUIDEBOOK_WARNING_WHITELIST = List.of(SpectrumCommon.locate("cuisine/cookbooks/brewers_handbook"));

    public static void register(LiteralCommandNode<class_2168> root) {
        LiteralCommandNode sanity = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sanity").requires(source -> source.method_9259(2))).executes(context -> SanityCommand.execute((class_2168)context.getSource(), "spectrum"))).build();
        ArgumentCommandNode modId = ((RequiredArgumentBuilder)class_2170.method_9244((String)"mod_id", (ArgumentType)StringArgumentType.word()).executes(context -> SanityCommand.execute((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"mod_id")))).build();
        sanity.addChild((CommandNode)modId);
        root.addChild((CommandNode)sanity);
    }

    private static int execute(class_2168 source, String modId) {
        class_1887 enchantment;
        class_1799 output;
        Object previousAdvancementIdentifier;
        class_5321 registryKey;
        SpectrumCommon.logInfo("##### SANITY CHECK START ######");
        for (Map.Entry entry : class_7923.field_41175.method_29722()) {
            class_2680 blockState;
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals(modId) || (blockState = ((class_2248)entry.getValue()).method_9564()).method_26204().method_36555() <= 0.0f || blockState.method_26164(class_3481.field_33715) || blockState.method_26164(class_3481.field_33713) || blockState.method_26164(class_3481.field_33716) || blockState.method_26164(class_3481.field_33714) || blockState.method_26164(FabricMineableTags.SHEARS_MINEABLE) || blockState.method_26164(FabricMineableTags.SWORD_MINEABLE) || blockState.method_26164(class_3481.field_44469) || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_MINEABLE_DEBUG_CHECK)) continue;
            SpectrumCommon.logWarning("[SANITY: Mineable Tags] Block " + String.valueOf(registryKey.method_29177()) + " is not contained in a any vanilla mineable tag.");
        }
        for (Map.Entry entry : class_7923.field_41175.method_29722()) {
            class_2248 block;
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals(modId) || (block = (class_2248)entry.getValue()) instanceof PlacedItemBlock || block instanceof SpectrumBuddingBlock || block instanceof WeepingGalaFrondsBlock) continue;
            class_2680 blockState = ((class_2248)entry.getValue()).method_9564();
            class_2960 lootTableID = block.method_26162();
            if (blockState.method_26204().method_36555() <= -1.0f || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_LOOT_TABLE_DEBUG_CHECK)) continue;
            if (lootTableID.equals((Object)class_39.field_844) || lootTableID.method_12832().equals("blocks/air")) {
                SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + String.valueOf(registryKey.method_29177()) + " has a non-existent loot table (" + String.valueOf(lootTableID) + ")");
                continue;
            }
            class_52 lootTable = source.method_9225().method_8503().method_3857().getLootTable(lootTableID);
            class_55[] class_55Array = lootTable.field_943;
            if (class_55Array.length != 0) continue;
            SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + String.valueOf(registryKey.method_29177()) + " has an empty loot table");
        }
        HashMap usedColorsForEachTier = new HashMap();
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap<BuiltinGemstoneColor, Integer> colorMap = new HashMap<BuiltinGemstoneColor, Integer>();
            for (BuiltinGemstoneColor gemstoneColor : BuiltinGemstoneColor.values()) {
                colorMap.put(gemstoneColor, 0);
            }
            usedColorsForEachTier.put((Object)((Object)pedestalRecipeTier), colorMap);
        }
        MinecraftServer minecraftServer = source.method_9225().method_8503();
        class_1863 recipeManager = minecraftServer.method_3772();
        class_2989 advancementLoader = minecraftServer.method_3851();
        for (PedestalRecipe pedestalRecipe : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            if ((pedestalRecipe.getTier() == PedestalRecipeTier.BASIC || pedestalRecipe.getTier() == PedestalRecipeTier.SIMPLE) && pedestalRecipe.getPowderInputs().getOrDefault(BuiltinGemstoneColor.BLACK, 0) > 0) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + String.valueOf(pedestalRecipe.method_8114()) + "' of tier '" + String.valueOf((Object)pedestalRecipe.getTier()) + "' is using onyx powder as input! Players will not have access to Onyx at that tier");
            }
            if (pedestalRecipe.getTier() != PedestalRecipeTier.COMPLEX && pedestalRecipe.getPowderInputs().getOrDefault(BuiltinGemstoneColor.WHITE, 0) > 0) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + String.valueOf(pedestalRecipe.method_8114()) + "' of tier '" + String.valueOf((Object)pedestalRecipe.getTier()) + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
            }
            for (Map.Entry entry : pedestalRecipe.getPowderInputs().entrySet()) {
                ((Map)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).put((GemstoneColor)entry.getKey(), (Integer)((Map)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).get(entry.getKey()) + (Integer)entry.getValue());
            }
        }
        for (Map.Entry item : class_7923.field_41178.method_29722()) {
            if (!((class_5321)item.getKey()).method_29177().method_12836().equals(modId) || class_2477.method_10517().method_4678(((class_1792)item.getValue()).method_7876())) continue;
            SpectrumCommon.logWarning("[SANITY: Item Lang] Missing translation string " + ((class_1792)item.getValue()).method_7876());
        }
        for (Object block : class_7923.field_41175.method_29722()) {
            if (!((class_5321)block.getKey()).method_29177().method_12836().equals(modId) || class_2477.method_10517().method_4678(((class_2248)block.getValue()).method_9539())) continue;
            SpectrumCommon.logWarning("[SANITY: Block Lang] Missing translation string " + ((class_2248)block.getValue()).method_9539());
        }
        HashSet recipeGroups = new HashSet();
        recipeManager.method_8127().forEach(identifier -> {
            Object patt0$temp;
            Optional recipe = recipeManager.method_8130(identifier);
            if (recipe.isPresent() && (patt0$temp = recipe.get()) instanceof GatedSpectrumRecipe) {
                GatedSpectrumRecipe gatedSpectrumRecipe = (GatedSpectrumRecipe)patt0$temp;
                String group = gatedSpectrumRecipe.method_8112();
                if (group == null) {
                    SpectrumCommon.logWarning("Recipe with null group found! :" + String.valueOf(gatedSpectrumRecipe.method_8114()));
                } else if (!group.isEmpty()) {
                    recipeGroups.add(group);
                }
            }
        });
        for (String recipeGroup : recipeGroups) {
            if (class_2477.method_10517().method_4678("recipeGroup.spectrum." + recipeGroup)) continue;
            SpectrumCommon.logWarning("[SANITY: Recipe Group Lang] Recipe group " + recipeGroup + " is not localized.");
        }
        for (Object recipe : recipeManager.method_8126()) {
            GatedRecipe gatedRecipe;
            class_2960 advancementIdentifier;
            if (!(recipe instanceof GatedRecipe) || (advancementIdentifier = (gatedRecipe = (GatedRecipe)recipe).getRequiredAdvancementIdentifier()) == null || advancementLoader.method_12896(advancementIdentifier) != null) continue;
            SpectrumCommon.logWarning("[SANITY: " + gatedRecipe.getRecipeTypeShortID() + " Recipe Unlocks] Advancement '" + String.valueOf(gatedRecipe.getRequiredAdvancementIdentifier()) + "' in recipe '" + String.valueOf(recipe.method_8114()) + "' does not exist");
        }
        class_5455 registryManager = source.method_30497();
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.FUSION_SHRINE, "Fusion Shrine", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTER, "Enchanting", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, "Enchantment Upgrade", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.SPIRIT_INSTILLING, "Spirit Instiller", recipeManager, registryManager);
        for (Map.Entry entry : RevelationRegistry.getBlockStateEntries().entrySet()) {
            if (advancementLoader.method_12896((class_2960)entry.getKey()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Block Cloaks] Advancement '" + ((class_2960)entry.getKey()).toString() + "' for block cloaking does not exist. Registered cloaks: " + ((List)entry.getValue()).size());
        }
        for (Map.Entry entry : RevelationRegistry.getItemEntries().entrySet()) {
            if (advancementLoader.method_12896((class_2960)entry.getKey()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Item Cloaks] Advancement '" + ((class_2960)entry.getKey()).toString() + "' for item cloaking does not exist. Registered cloaks: " + ((List)entry.getValue()).size());
        }
        for (class_161 class_1612 : advancementLoader.method_12893()) {
            for (class_175 criterion : class_1612.method_682().values()) {
                String[][] conditions = criterion.method_774();
                if (conditions instanceof AdvancementGottenCriterion.Conditions) {
                    class_161 advancementCriterionAdvancement;
                    AdvancementGottenCriterion.Conditions hasAdvancementConditions = (AdvancementGottenCriterion.Conditions)conditions;
                    class_2960 advancementIdentifier = hasAdvancementConditions.getAdvancementIdentifier();
                    if (advancementIdentifier.equals((Object)WIP_ADVANCEMENT_ID) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier)) != null) continue;
                    SpectrumCommon.logWarning("[SANITY: Has_Advancement Criteria] Advancement '" + String.valueOf(class_1612.method_688()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
                    continue;
                }
                if (!(conditions instanceof AdvancementCountCriterion.Conditions)) continue;
                AdvancementCountCriterion.Conditions hasAdvancementConditions = (AdvancementCountCriterion.Conditions)conditions;
                for (class_2960 advancementIdentifier : hasAdvancementConditions.getAdvancementIdentifiers()) {
                    class_161 advancementCriterionAdvancement;
                    if (advancementIdentifier.equals((Object)WIP_ADVANCEMENT_ID) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier)) != null) continue;
                    SpectrumCommon.logWarning("[SANITY: Advancement_Count Criteria] Advancement '" + String.valueOf(class_1612.method_688()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
                }
            }
        }
        for (class_161 class_1613 : advancementLoader.method_12893()) {
            String path = class_1613.method_688().method_12832();
            if (!class_1613.method_688().method_12836().equals(modId) || path.startsWith("hidden") || path.startsWith("progression") || path.startsWith("milestones") || class_1613.method_687() == null) continue;
            previousAdvancementIdentifier = null;
            for (String[] requirement : class_1613.method_680()) {
                if (requirement.length <= 0 || !requirement[0].equals("gotten_previous")) continue;
                class_1799[] conditions = ((class_175)class_1613.method_682().get("gotten_previous")).method_774();
                if (conditions instanceof AdvancementGottenCriterion.Conditions) {
                    AdvancementGottenCriterion.Conditions advancementConditions = (AdvancementGottenCriterion.Conditions)conditions;
                    previousAdvancementIdentifier = advancementConditions.getAdvancementIdentifier();
                    break;
                }
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(class_1613.method_688()) + "' has a \"gotten_previous\" requirement, but its not revelationary:advancement_gotten");
            }
            if (ADVANCEMENT_GATING_WARNING_WHITELIST.contains(class_1613.method_688())) continue;
            if (previousAdvancementIdentifier == null) {
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(class_1613.method_688()) + "' does not have its parent set as requirement");
                continue;
            }
            class_161 parent = class_1613.method_687();
            if (parent.method_688().equals(previousAdvancementIdentifier) || parent.method_687() != null && parent.method_687().method_688().equals(previousAdvancementIdentifier)) continue;
            SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(class_1613.method_688()) + "' has its \"gotten_previous\" advancement set to something else than their parent. Intended?");
        }
        for (PedestalRecipe pedestalRecipe : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            class_2960 id = pedestalRecipe.method_8114();
            if (id.method_12832().startsWith("mod_integration/") || id.method_12832().contains("/glass/") || id.method_12832().contains("/saplings/") || id.method_12832().contains("/detectors/") || id.method_12832().contains("/gemstone_lights/") || id.method_12832().contains("/decostones/") || id.method_12832().contains("/runes/") || id.method_12832().contains("/pastel_network/") || id.method_12832().contains("/gemstone_chimes/") || id.method_12832().contains("/pastel_network/") || id.method_12832().contains("/semi_permeable_glass/") || id.method_12832().contains("/colored_lamps/") || id.method_12832().contains("/colored_spore_blossoms/") || id.method_12832().contains("/glowblocks/")) continue;
            if (pedestalRecipe.getTier() == PedestalRecipeTier.BASIC && !id.method_12832().contains("/tier1/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] BASIC recipe not in the correct tier folder: '" + String.valueOf(id) + "'");
                continue;
            }
            if (pedestalRecipe.getTier() == PedestalRecipeTier.SIMPLE && !id.method_12832().contains("/tier2/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] SIMPLE recipe not in the correct tier folder: '" + String.valueOf(id) + "'");
                continue;
            }
            if (pedestalRecipe.getTier() == PedestalRecipeTier.ADVANCED && !id.method_12832().contains("/tier3/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] ADVANCED recipe not in the correct tier folder: '" + String.valueOf(id) + "'");
                continue;
            }
            if (pedestalRecipe.getTier() != PedestalRecipeTier.COMPLEX || id.method_12832().contains("/tier4/")) continue;
            SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] COMPLEX recipe not in the correct tier folder: '" + String.valueOf(id) + "'");
        }
        for (AnvilCrushingRecipe anvilCrushingRecipe : recipeManager.method_30027(SpectrumRecipeTypes.ANVIL_CRUSHING)) {
            class_3414 soundEvent = anvilCrushingRecipe.getSoundEvent();
            if (soundEvent != null) continue;
            SpectrumCommon.logWarning("[SANITY: Item Crushing] Recipe '" + String.valueOf(anvilCrushingRecipe.method_8114()) + "' has a nonexistent sound set");
        }
        for (Map.Entry entry : class_7923.field_41176.method_29722()) {
            SpectrumEnchantment spectrumEnchantment;
            class_2960 advancementIdentifier;
            class_161 advancementCriterionAdvancement;
            previousAdvancementIdentifier = entry.getValue();
            if (!(previousAdvancementIdentifier instanceof SpectrumEnchantment) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier = (spectrumEnchantment = (SpectrumEnchantment)((Object)previousAdvancementIdentifier)).getUnlockAdvancementIdentifier())) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantments] Enchantment '" + String.valueOf(((class_5321)entry.getKey()).method_29177()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
        }
        for (Map.Entry entry : class_7923.field_41178.method_29722()) {
            class_1792 i = (class_1792)entry.getValue();
            if (!(i instanceof ExtendedEnchantable)) continue;
            if (!new class_1799((class_1935)i).method_7923()) {
                SpectrumCommon.logWarning("[SANITY: Enchantability] Item '" + String.valueOf(((class_5321)entry.getKey()).method_29177()) + "' is not set to be enchantable.");
            }
            if (i.method_7837() >= 1) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantability] Item '" + String.valueOf(((class_5321)entry.getKey()).method_29177()) + "' is ExtendedEnchantable, but has enchantability of < 1");
        }
        HashMap<class_1887, class_1767> craftingColors = new HashMap<class_1887, class_1767>();
        HashMap<class_1887, class_1767> hashMap = new HashMap<class_1887, class_1767>();
        for (GatedSpectrumRecipe recipe : recipeManager.method_30027(SpectrumRecipeTypes.ENCHANTER)) {
            Map enchantments;
            output = ((EnchanterRecipe)recipe).method_8110(source.method_30497());
            if (output.method_7909() != class_1802.field_8598 || (enchantments = class_1890.method_8222((class_1799)output)).isEmpty()) continue;
            for (class_1856 ingredient : ((EnchanterRecipe)recipe).method_8117()) {
                for (class_1799 matchingStack : ingredient.method_8105()) {
                    class_1792 class_17922 = matchingStack.method_7909();
                    if (!(class_17922 instanceof PigmentItem)) continue;
                    PigmentItem pigmentItem = (PigmentItem)class_17922;
                    craftingColors.put((class_1887)enchantments.keySet().stream().toList().get(0), pigmentItem.getColor());
                }
            }
        }
        for (GatedSpectrumRecipe recipe : recipeManager.method_30027(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE)) {
            Map enchantments;
            class_1856 ingredient;
            output = ((EnchantmentUpgradeRecipe)recipe).method_8110(source.method_30497());
            if (output.method_7909() != class_1802.field_8598 || (enchantments = class_1890.method_8222((class_1799)output)).isEmpty() || !((ingredient = ((EnchantmentUpgradeRecipe)recipe).getRequiredItem()) instanceof PigmentItem)) continue;
            PigmentItem pigmentItem = (PigmentItem)ingredient;
            hashMap.put((class_1887)enchantments.keySet().stream().toList().get(0), pigmentItem.getColor());
        }
        for (Map.Entry entry : class_7923.field_41176.method_29722()) {
            enchantment = (class_1887)entry.getValue();
            if (!craftingColors.containsKey(enchantment)) {
                SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + String.valueOf(((class_5321)entry.getKey()).method_29177()) + "' does not have a crafting recipe");
            }
            if (!hashMap.containsKey(enchantment) && enchantment.method_8183() > 1) {
                SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + String.valueOf(((class_5321)entry.getKey()).method_29177()) + "' does not have a upgrading recipe");
            }
            if (!craftingColors.containsKey(enchantment) || !hashMap.containsKey(enchantment) || craftingColors.get(enchantment) == hashMap.get(enchantment)) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment recipes for '" + String.valueOf(((class_5321)entry.getKey()).method_29177()) + "' use different pigments");
        }
        for (Map.Entry entry : class_7923.field_41176.method_29722()) {
            enchantment = (class_1887)entry.getValue();
            if (!((class_5321)entry.getKey()).method_29177().method_12836().equals(modId) || SpectrumEnchantmentTags.isIn(SpectrumEnchantmentTags.SPECTRUM_ENCHANTMENT, enchantment)) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantment Tags] Enchantment '" + String.valueOf(((class_5321)entry.getKey()).method_29177()) + "' is missing in the spectrum:enchantments tag");
        }
        for (Object item : class_7923.field_41178.method_29722()) {
            SpectrumTrinketItem trinketItem;
            class_2960 advancementIdentifier;
            class_161 advancementCriterionAdvancement;
            Object enchantments = item.getValue();
            if (!(enchantments instanceof SpectrumTrinketItem) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier = (trinketItem = (SpectrumTrinketItem)((Object)enchantments)).getUnlockIdentifier())) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Trinkets] Trinket '" + String.valueOf(((class_5321)item.getKey()).method_29177()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
        }
        Collection itemGroupStacks = SpectrumItemGroups.MAIN.method_45414();
        for (Object item : class_7923.field_41178.method_29722()) {
            if (!((class_5321)item.getKey()).method_29177().method_12836().equals(modId) || ((class_1792)item.getValue()).method_40131().method_40220(SpectrumItemTags.COMING_SOON_TOOLTIP)) continue;
            boolean found = false;
            for (class_1799 stack : itemGroupStacks) {
                if (!stack.method_31574((class_1792)item.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            SpectrumCommon.logWarning("[SANITY: ItemGroups] Item '" + String.valueOf(((class_5321)item.getKey()).method_29177()) + "' is missing from the Spectrum item group.");
        }
        Book book = BookDataManager.get().getBook(GuidebookItem.GUIDEBOOK_ID);
        for (Map.Entry entry : book.getEntries().entrySet()) {
            BookConditionCategoryContext context;
            if (GUIDEBOOK_WARNING_WHITELIST.contains(entry.getKey())) continue;
            BookCondition condition = ((BookEntry)entry.getValue()).getCondition();
            if (!condition.test((BookConditionContext)(context = new BookConditionCategoryContext(book, ((BookEntry)entry.getValue()).getCategory())), (class_1657)source.method_44023())) {
                SpectrumCommon.logWarning("[SANITY: Guidebook] Entry '" + String.valueOf(entry.getKey()) + "' is still locked for the executing player. Does the player have the required advancements? Can it be unlocked?");
            }
            for (BookPage page : ((BookEntry)entry.getValue()).getPages()) {
                BookHintPage bookHintPage;
                class_2960 completionAdvancement;
                class_161 advancement;
                if (!page.getCondition().test((BookConditionContext)context, (class_1657)source.method_44023())) {
                    SpectrumCommon.logWarning("[SANITY: Guidebook] Entry '" + String.valueOf(entry.getKey()) + "' page " + page.getPageNumber() + " of type '" + String.valueOf(page.getType()) + "' is still locked for the executing player. Does the player have the required advancements? Can it be unlocked? Or is it only a missing mod compat recipe page?");
                }
                if (!(page instanceof BookHintPage) || (advancement = advancementLoader.method_12896(completionAdvancement = (bookHintPage = (BookHintPage)page).getCompletionAdvancement())) != null) continue;
                SpectrumCommon.logWarning("[SANITY: Guidebook] Hint Page '" + String.valueOf(entry.getKey()) + "' page " + page.getPageNumber() + " is missing it's completion advancement '" + String.valueOf(completionAdvancement) + "'");
            }
        }
        SpectrumCommon.logInfo("##### SANITY CHECK FINISHED ######");
        SpectrumCommon.logInfo("##### SANITY CHECK PEDESTAL RECIPE STATISTICS ######");
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            Map entry = (Map)usedColorsForEachTier.get((Object)pedestalRecipeTier);
            SpectrumCommon.logInfo("[SANITY: Pedestal Recipe Gemstone Usages] Gemstone Powder for tier " + StringUtils.leftPad((String)pedestalRecipeTier.toString(), (int)8) + ": C:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.CYAN)).toString(), (int)4) + " M:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.MAGENTA)).toString(), (int)4) + " Y:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.YELLOW)).toString(), (int)4) + " K:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.BLACK)).toString(), (int)4) + " W:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.WHITE)).toString(), (int)4));
        }
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_12972;
            serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"commands.spectrum.progression_sanity.success"), false);
        }
        return 0;
    }

    private static <R extends GatedRecipe<C>, C extends class_1263> void testIngredientsAndOutputInColorRegistry(class_3956<R> recipeType, String name, class_1863 recipeManager, class_5455 registryManager) {
        for (GatedRecipe recipe : recipeManager.method_30027(recipeType)) {
            for (class_1856 inputIngredient : recipe.method_8117()) {
                for (class_1799 matchingItemStack : inputIngredient.method_8105()) {
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.method_7909()).isEmpty()) continue;
                    SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Input '" + String.valueOf(class_7923.field_41178.method_10221((Object)matchingItemStack.method_7909())) + "' in recipe '" + String.valueOf(recipe.method_8114()) + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            class_1792 outputItem = recipe.method_8110(registryManager).method_7909();
            if (outputItem == null || outputItem == class_1802.field_8162 || !ColorRegistry.ITEM_COLORS.getMapping(outputItem).isEmpty()) continue;
            SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Output '" + String.valueOf(class_7923.field_41178.method_10221((Object)outputItem)) + "' in recipe '" + String.valueOf(recipe.method_8114()) + "', does not exist in the item color registry. Add it for nice effects!");
        }
    }
}

