/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.FilterConfigurable;
import de.dafuqs.spectrum.blocks.idols.FirestarterIdolBlock;
import de.dafuqs.spectrum.blocks.idols.FreezingIdolBlock;
import de.dafuqs.spectrum.compat.emi.SpectrumEmiRecipeCategories;
import de.dafuqs.spectrum.compat.emi.handlers.CinderhearthRecipeHandler;
import de.dafuqs.spectrum.compat.emi.handlers.CraftingTabletRecipeHandler;
import de.dafuqs.spectrum.compat.emi.handlers.PedestalRecipeHandler;
import de.dafuqs.spectrum.compat.emi.handlers.PotionWorkshopRecipeHandler;
import de.dafuqs.spectrum.compat.emi.recipes.AnvilCrushingEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.BlockToBlockWithChanceEmiRecipe;
import de.dafuqs.spectrum.compat.emi.recipes.CinderhearthEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.CrystallarieumEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.EnchanterEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.EnchantmentUpgradeEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.FluidConvertingEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.FusionShrineEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.InkConvertingEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.PedestalCraftingEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.PotionWorkshopEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.PotionWorkshopReactingEmiRecipe;
import de.dafuqs.spectrum.compat.emi.recipes.PrimordialFireBurningEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.SpectrumWorldInteractionRecipe;
import de.dafuqs.spectrum.compat.emi.recipes.SpiritInstillingEmiRecipeGated;
import de.dafuqs.spectrum.compat.emi.recipes.TitrationBarrelEmiRecipeGated;
import de.dafuqs.spectrum.data_loaders.NaturesStaffConversionDataLoader;
import de.dafuqs.spectrum.inventories.BlackHoleChestScreen;
import de.dafuqs.spectrum.inventories.FilteringScreen;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.inventories.slots.ShadowSlot;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.recipe.fluid_converting.DragonrotConvertingRecipe;
import de.dafuqs.spectrum.recipe.fluid_converting.FluidConvertingRecipe;
import de.dafuqs.spectrum.recipe.fluid_converting.LiquidCrystalConvertingRecipe;
import de.dafuqs.spectrum.recipe.fluid_converting.MidnightSolutionConvertingRecipe;
import de.dafuqs.spectrum.recipe.fluid_converting.MudConvertingRecipe;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopRecipe;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.config.FluidUnit;
import dev.emi.emi.runtime.EmiReloadLog;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1735;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_465;
import net.minecraft.class_7923;

public class SpectrumEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        this.registerCategories(registry);
        this.registerRecipes(registry);
        this.registerRecipeHandlers(registry);
        this.registerDragDropHandlers(registry);
    }

    public void registerDragDropHandlers(EmiRegistry registry) {
        EmiDragDropHandler.SlotBased handlerOne = new EmiDragDropHandler.SlotBased((_ignored, slot) -> slot instanceof ShadowSlot && slot.field_7871 instanceof FilterConfigurable.FilterInventory, (screen, slot, ingredient) -> {
            if (ingredient instanceof ItemEmiStack) {
                ItemEmiStack stack = (ItemEmiStack)ingredient;
                ((FilterConfigurable.FilterInventory)slot.field_7871).getClicker().clickShadowSlot(screen.method_17577().field_7763, (class_1735)slot, stack.getItemStack());
            }
        });
        this.registerDragDropHandler(registry, (Class<? extends class_465<?>>)BlackHoleChestScreen.class, (EmiDragDropHandler<class_465<?>>)handlerOne);
        this.registerDragDropHandler(registry, (Class<? extends class_465<?>>)FilteringScreen.class, (EmiDragDropHandler<class_465<?>>)handlerOne);
    }

    private void registerDragDropHandler(EmiRegistry registry, Class<? extends class_465<?>> clazz, EmiDragDropHandler<class_465<?>> handler) {
        registry.addDragDropHandler(clazz, handler);
    }

    public void registerCategories(EmiRegistry registry) {
        registry.addCategory(SpectrumEmiRecipeCategories.PEDESTAL_CRAFTING);
        registry.addCategory(SpectrumEmiRecipeCategories.ANVIL_CRUSHING);
        registry.addCategory(SpectrumEmiRecipeCategories.FUSION_SHRINE);
        registry.addCategory(SpectrumEmiRecipeCategories.NATURES_STAFF);
        registry.addCategory(SpectrumEmiRecipeCategories.ENCHANTER);
        registry.addCategory(SpectrumEmiRecipeCategories.ENCHANTMENT_UPGRADE);
        registry.addCategory(SpectrumEmiRecipeCategories.POTION_WORKSHOP_BREWING);
        registry.addCategory(SpectrumEmiRecipeCategories.POTION_WORKSHOP_CRAFTING);
        registry.addCategory(SpectrumEmiRecipeCategories.POTION_WORKSHOP_REACTING);
        registry.addCategory(SpectrumEmiRecipeCategories.SPIRIT_INSTILLER);
        registry.addCategory(SpectrumEmiRecipeCategories.MUD_CONVERTING);
        registry.addCategory(SpectrumEmiRecipeCategories.LIQUID_CRYSTAL_CONVERTING);
        registry.addCategory(SpectrumEmiRecipeCategories.MIDNIGHT_SOLUTION_CONVERTING);
        registry.addCategory(SpectrumEmiRecipeCategories.DRAGONROT_CONVERTING);
        registry.addCategory(SpectrumEmiRecipeCategories.HEATING);
        registry.addCategory(SpectrumEmiRecipeCategories.FREEZING);
        registry.addCategory(SpectrumEmiRecipeCategories.INK_CONVERTING);
        registry.addCategory(SpectrumEmiRecipeCategories.CRYSTALLARIEUM);
        registry.addCategory(SpectrumEmiRecipeCategories.CINDERHEARTH);
        registry.addCategory(SpectrumEmiRecipeCategories.TITRATION_BARREL);
        registry.addCategory(SpectrumEmiRecipeCategories.PRIMORDIAL_FIRE_BURNING);
        EmiIngredient pedestals = EmiIngredient.of(List.of(EmiStack.of((class_1935)SpectrumBlocks.PEDESTAL_BASIC_TOPAZ), EmiStack.of((class_1935)SpectrumBlocks.PEDESTAL_BASIC_AMETHYST), EmiStack.of((class_1935)SpectrumBlocks.PEDESTAL_BASIC_CITRINE), EmiStack.of((class_1935)SpectrumBlocks.PEDESTAL_ALL_BASIC), EmiStack.of((class_1935)SpectrumBlocks.PEDESTAL_ONYX), EmiStack.of((class_1935)SpectrumBlocks.PEDESTAL_MOONSTONE)));
        registry.addWorkstation(SpectrumEmiRecipeCategories.PEDESTAL_CRAFTING, pedestals);
        if (SpectrumCommon.CONFIG.canPedestalCraftVanillaRecipes()) {
            registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, pedestals);
        }
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumItems.CRAFTING_TABLET));
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.RESTOCKING_CHEST));
        registry.addWorkstation(VanillaEmiRecipeCategories.BLASTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.CINDERHEARTH));
        registry.addWorkstation(SpectrumEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((class_1935)class_2246.field_10535));
        registry.addWorkstation(SpectrumEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.BEDROCK_ANVIL));
        registry.addWorkstation(SpectrumEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.STRATINE_FRAGMENT_BLOCK));
        registry.addWorkstation(SpectrumEmiRecipeCategories.ANVIL_CRUSHING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.PALTAERIA_FRAGMENT_BLOCK));
        registry.addWorkstation(SpectrumEmiRecipeCategories.FUSION_SHRINE, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.FUSION_SHRINE_BASALT));
        registry.addWorkstation(SpectrumEmiRecipeCategories.FUSION_SHRINE, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.FUSION_SHRINE_CALCITE));
        registry.addWorkstation(SpectrumEmiRecipeCategories.NATURES_STAFF, (EmiIngredient)EmiStack.of((class_1935)SpectrumItems.NATURES_STAFF));
        registry.addWorkstation(SpectrumEmiRecipeCategories.HEATING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.BLAZE_IDOL));
        registry.addWorkstation(SpectrumEmiRecipeCategories.FREEZING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.POLAR_BEAR_IDOL));
        registry.addWorkstation(SpectrumEmiRecipeCategories.ENCHANTER, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.ENCHANTER));
        registry.addWorkstation(SpectrumEmiRecipeCategories.ENCHANTMENT_UPGRADE, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.ENCHANTER));
        registry.addWorkstation(SpectrumEmiRecipeCategories.MUD_CONVERTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumItems.MUD_BUCKET));
        registry.addWorkstation(SpectrumEmiRecipeCategories.LIQUID_CRYSTAL_CONVERTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumItems.LIQUID_CRYSTAL_BUCKET));
        registry.addWorkstation(SpectrumEmiRecipeCategories.MIDNIGHT_SOLUTION_CONVERTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumItems.MIDNIGHT_SOLUTION_BUCKET));
        registry.addWorkstation(SpectrumEmiRecipeCategories.DRAGONROT_CONVERTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumItems.DRAGONROT_BUCKET));
        registry.addWorkstation(SpectrumEmiRecipeCategories.SPIRIT_INSTILLER, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.SPIRIT_INSTILLER));
        registry.addWorkstation(SpectrumEmiRecipeCategories.INK_CONVERTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.COLOR_PICKER));
        registry.addWorkstation(SpectrumEmiRecipeCategories.CRYSTALLARIEUM, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.CRYSTALLARIEUM));
        registry.addWorkstation(SpectrumEmiRecipeCategories.POTION_WORKSHOP_BREWING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.POTION_WORKSHOP));
        registry.addWorkstation(SpectrumEmiRecipeCategories.POTION_WORKSHOP_CRAFTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.POTION_WORKSHOP));
        registry.addWorkstation(SpectrumEmiRecipeCategories.POTION_WORKSHOP_REACTING, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.POTION_WORKSHOP));
        registry.addWorkstation(SpectrumEmiRecipeCategories.CINDERHEARTH, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.CINDERHEARTH));
        registry.addWorkstation(SpectrumEmiRecipeCategories.TITRATION_BARREL, (EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.TITRATION_BARREL));
        registry.addWorkstation(SpectrumEmiRecipeCategories.PRIMORDIAL_FIRE_BURNING, EmiIngredient.of(List.of(EmiStack.of((class_1935)SpectrumItems.DOOMBLOOM_SEED), EmiStack.of((class_1935)SpectrumItems.PRIMORDIAL_LIGHTER), EmiStack.of((class_1935)SpectrumBlocks.INCANDESCENT_AMALGAM), EmiStack.of((class_1935)SpectrumItems.PIPE_BOMB))));
    }

    public void registerRecipes(EmiRegistry registry) {
        this.addAll(registry, SpectrumRecipeTypes.ANVIL_CRUSHING, AnvilCrushingEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.PEDESTAL, PedestalCraftingEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.FUSION_SHRINE, FusionShrineEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.ENCHANTER, r -> new EnchanterEmiRecipeGated(SpectrumEmiRecipeCategories.ENCHANTER, (EnchanterRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, r -> new EnchantmentUpgradeEmiRecipeGated(SpectrumEmiRecipeCategories.ENCHANTMENT_UPGRADE, (EnchantmentUpgradeRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.POTION_WORKSHOP_BREWING, r -> new PotionWorkshopEmiRecipeGated(SpectrumEmiRecipeCategories.POTION_WORKSHOP_BREWING, (PotionWorkshopRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.POTION_WORKSHOP_CRAFTING, r -> new PotionWorkshopEmiRecipeGated(SpectrumEmiRecipeCategories.POTION_WORKSHOP_CRAFTING, (PotionWorkshopRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.POTION_WORKSHOP_REACTING, PotionWorkshopReactingEmiRecipe::new);
        this.addAll(registry, SpectrumRecipeTypes.SPIRIT_INSTILLING, SpiritInstillingEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.MUD_CONVERTING, r -> new FluidConvertingEmiRecipeGated(SpectrumEmiRecipeCategories.MUD_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.LIQUID_CRYSTAL_CONVERTING, r -> new FluidConvertingEmiRecipeGated(SpectrumEmiRecipeCategories.LIQUID_CRYSTAL_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING, r -> new FluidConvertingEmiRecipeGated(SpectrumEmiRecipeCategories.MIDNIGHT_SOLUTION_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.DRAGONROT_CONVERTING, r -> new FluidConvertingEmiRecipeGated(SpectrumEmiRecipeCategories.DRAGONROT_CONVERTING, (FluidConvertingRecipe)r));
        this.addAll(registry, SpectrumRecipeTypes.INK_CONVERTING, InkConvertingEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.CRYSTALLARIEUM, CrystallarieumEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.CINDERHEARTH, CinderhearthEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.TITRATION_BARREL, TitrationBarrelEmiRecipeGated::new);
        this.addAll(registry, SpectrumRecipeTypes.PRIMORDIAL_FIRE_BURNING, PrimordialFireBurningEmiRecipeGated::new);
        FreezingIdolBlock.FREEZING_STATE_MAP.forEach((key, value) -> {
            EmiStack in = EmiStack.of((class_1935)key.method_26204());
            EmiStack out = EmiStack.of((class_1935)((class_2680)value.method_15442()).method_26204()).setChance(((Float)value.method_15441()).floatValue());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            class_2960 id = SpectrumEmiPlugin.syntheticId("freezing", key.method_26204());
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(SpectrumEmiRecipeCategories.FREEZING, id, (EmiIngredient)in, out, SpectrumAdvancements.UNLOCK_IDOLS));
        });
        FreezingIdolBlock.FREEZING_MAP.forEach((key, value) -> {
            EmiStack in = EmiStack.of((class_1935)key);
            EmiStack out = EmiStack.of((class_1935)((class_2680)value.method_15442()).method_26204()).setChance(((Float)value.method_15441()).floatValue());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            class_2960 id = SpectrumEmiPlugin.syntheticId("freezing", key);
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(SpectrumEmiRecipeCategories.FREEZING, id, (EmiIngredient)in, out, SpectrumAdvancements.UNLOCK_IDOLS));
        });
        FirestarterIdolBlock.BURNING_MAP.forEach((key, value) -> {
            EmiStack in = EmiStack.of((class_1935)key);
            EmiStack out = EmiStack.of((class_1935)((class_2680)value.method_15442()).method_26204()).setChance(((Float)value.method_15441()).floatValue());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            class_2960 id = SpectrumEmiPlugin.syntheticId("heating", key);
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(SpectrumEmiRecipeCategories.HEATING, id, (EmiIngredient)in, out, SpectrumAdvancements.UNLOCK_IDOLS));
        });
        NaturesStaffConversionDataLoader.CONVERSIONS.forEach((key, value) -> {
            EmiStack in = EmiStack.of((class_1935)key);
            EmiStack out = EmiStack.of((class_1935)value.method_26204());
            if (in.isEmpty() || out.isEmpty()) {
                return;
            }
            class_2960 id = SpectrumEmiPlugin.syntheticId("natures_staff", key);
            registry.addRecipe((EmiRecipe)new BlockToBlockWithChanceEmiRecipe(SpectrumEmiRecipeCategories.NATURES_STAFF, id, (EmiIngredient)in, out, SpectrumAdvancements.UNLOCK_NATURES_STAFF));
        });
        EmiStack water = EmiStack.of((class_3611)class_3612.field_15910, (long)FluidUnit.BUCKET);
        EmiStack lava = EmiStack.of((class_3611)class_3612.field_15908, (long)FluidUnit.BUCKET);
        EmiStack dragonrot = EmiStack.of((class_3611)SpectrumFluids.DRAGONROT, (long)FluidUnit.BUCKET);
        EmiStack liquidCrystal = EmiStack.of((class_3611)SpectrumFluids.LIQUID_CRYSTAL, (long)FluidUnit.BUCKET);
        EmiStack midnightSolution = EmiStack.of((class_3611)SpectrumFluids.MIDNIGHT_SOLUTION, (long)FluidUnit.BUCKET);
        EmiStack mud = EmiStack.of((class_3611)SpectrumFluids.MUD, (long)FluidUnit.BUCKET);
        EmiStack waterCatalyst = water.copy().setRemainder(water);
        EmiStack lavaCatalyst = lava.copy().setRemainder(lava);
        EmiStack dragonrotCatalyst = dragonrot.copy().setRemainder(dragonrot);
        EmiStack liquidCrystalCatalyst = liquidCrystal.copy().setRemainder(liquidCrystal);
        EmiStack midnightSolutionCatalyst = midnightSolution.copy().setRemainder(midnightSolution);
        EmiStack mudCatalyst = mud.copy().setRemainder(mud);
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", SpectrumBlocks.SLUSH)).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((class_1935)SpectrumBlocks.SLUSH)).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_23869)).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_23869)).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_10253)).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)mudCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_10253)).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(MudConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", SpectrumBlocks.ROTTEN_GROUND)).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)liquidCrystalCatalyst, false).output(EmiStack.of((class_1935)SpectrumBlocks.ROTTEN_GROUND)).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", SpectrumBlocks.BLACK_SLUDGE)).leftInput((EmiIngredient)dragonrotCatalyst).rightInput((EmiIngredient)midnightSolutionCatalyst, false).output(EmiStack.of((class_1935)SpectrumBlocks.BLACK_SLUDGE)).requiredAdvancement(DragonrotConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(MidnightSolutionConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", SpectrumBlocks.FROSTBITE_CRYSTAL)).leftInput((EmiIngredient)liquidCrystal).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((class_1935)SpectrumBlocks.FROSTBITE_CRYSTAL)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_27114)).leftInput((EmiIngredient)liquidCrystalCatalyst).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_27114)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", SpectrumBlocks.BLAZING_CRYSTAL)).leftInput((EmiIngredient)liquidCrystal).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((class_1935)SpectrumBlocks.BLAZING_CRYSTAL)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_29031)).leftInput((EmiIngredient)liquidCrystalCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_29031)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_10460)).leftInput((EmiIngredient)liquidCrystalCatalyst).rightInput((EmiIngredient)mudCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_10460)).requiredAdvancement(LiquidCrystalConvertingRecipe.UNLOCK_IDENTIFIER).requiredAdvancement(MudConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_10415)).leftInput((EmiIngredient)midnightSolutionCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_10415)).requiredAdvancement(MidnightSolutionConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_10566)).leftInput((EmiIngredient)mudCatalyst).rightInput((EmiIngredient)waterCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_10566)).requiredAdvancement(MudConvertingRecipe.UNLOCK_IDENTIFIER).build());
        SpectrumEmiPlugin.addRecipeSafe(registry, () -> SpectrumWorldInteractionRecipe.customBuilder().id(SpectrumEmiPlugin.syntheticId("world/fluid_interaction", class_2246.field_37576)).leftInput((EmiIngredient)mudCatalyst).rightInput((EmiIngredient)lavaCatalyst, false).output(EmiStack.of((class_1935)class_2246.field_37576)).requiredAdvancement(MudConvertingRecipe.UNLOCK_IDENTIFIER).build());
    }

    public void registerRecipeHandlers(EmiRegistry registry) {
        registry.addRecipeHandler(SpectrumScreenHandlerTypes.PEDESTAL, (EmiRecipeHandler)new PedestalRecipeHandler());
        registry.addRecipeHandler(SpectrumScreenHandlerTypes.CRAFTING_TABLET, (EmiRecipeHandler)new CraftingTabletRecipeHandler());
        registry.addRecipeHandler(SpectrumScreenHandlerTypes.CINDERHEARTH, (EmiRecipeHandler)new CinderhearthRecipeHandler());
        registry.addRecipeHandler(SpectrumScreenHandlerTypes.POTION_WORKSHOP, (EmiRecipeHandler)new PotionWorkshopRecipeHandler());
    }

    public static class_2960 syntheticId(String type, class_2248 block) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        return new class_2960("spectrum:/" + type + "/" + blockId.method_12836() + "/" + blockId.method_12832());
    }

    public <C extends class_1263, T extends class_1860<C>> void addAll(EmiRegistry registry, class_3956<T> type, Function<T, EmiRecipe> constructor) {
        for (class_1860 recipe : registry.getRecipeManager().method_30027(type)) {
            registry.addRecipe(constructor.apply(recipe));
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn((String)"Exception thrown when parsing EMI recipe (no ID available)");
            EmiReloadLog.error((Throwable)e);
        }
    }
}

