/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi.recipes;

import com.google.common.collect.Lists;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.emi.GatedSpectrumEmiRecipe;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EnchanterEmiRecipeGated
extends GatedSpectrumEmiRecipe<GatedSpectrumRecipe<?>> {
    private static final class_2960 BACKGROUND_TEXTURE = SpectrumCommon.locate("textures/gui/container/enchanter.png");
    private final class_2561 description;
    private final int craftingTime;

    public EnchanterEmiRecipeGated(EmiRecipeCategory category, EnchanterRecipe recipe) {
        this(category, recipe, EnchanterEmiRecipeGated.getCraftingTimeText(recipe.getCraftingTime()), recipe.getCraftingTime());
        this.inputs = Stream.concat(this.inputs.stream(), Stream.of(EmiStack.of((class_1799)KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getRequiredExperience(), true)))).toList();
    }

    public EnchanterEmiRecipeGated(EmiRecipeCategory category, EnchantmentUpgradeRecipe recipe) {
        this(category, recipe, (class_2561)class_2561.method_43469((String)"container.spectrum.rei.enchantment_upgrade.required_item_count", (Object[])new Object[]{recipe.getRequiredItemCount()}), 0);
        this.inputs = Lists.newArrayList();
        this.inputs.add(EmiIngredient.of((class_1856)((class_1856)recipe.method_8117().get(0))));
        int requiredItemCountSplit = recipe.getRequiredItemCount() / 8;
        int requiredItemCountModulo = recipe.getRequiredItemCount() % 8;
        for (int i = 0; i < 8; ++i) {
            int addAmount = i < requiredItemCountModulo ? 1 : 0;
            this.inputs.add(EmiStack.of((class_1935)recipe.getRequiredItem(), (long)(requiredItemCountSplit + addAmount)));
        }
        this.inputs.add(EmiStack.of((class_1799)KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getRequiredExperience(), true)));
    }

    private EnchanterEmiRecipeGated(EmiRecipeCategory category, GatedSpectrumRecipe<?> recipe, class_2561 description, int craftingTime) {
        super(category, recipe, 132, 80);
        this.craftingTime = craftingTime;
        this.description = description;
        this.inputs = recipe.method_8117().stream().map(EmiIngredient::of).toList();
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND_TEXTURE, 13, 13, 54, 54, 0, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(9), 111, 5);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.ENCHANTER), 111, 51).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 31, 31);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 18, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), 44, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(3), 62, 18);
        widgets.addSlot((EmiIngredient)this.inputs.get(4), 62, 44);
        widgets.addSlot((EmiIngredient)this.inputs.get(5), 44, 62);
        widgets.addSlot((EmiIngredient)this.inputs.get(6), 18, 62);
        widgets.addSlot((EmiIngredient)this.inputs.get(7), 0, 44);
        widgets.addSlot((EmiIngredient)this.inputs.get(8), 0, 18);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 106, 26).large(true).recipeContext((EmiRecipe)this);
        if (this.craftingTime != 0) {
            widgets.addFillingArrow(80, 31, this.craftingTime * 50);
        } else {
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 80, 31);
        }
        widgets.addText(this.description, 67, 70, 0x3F3F3F, false);
    }
}

