/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetTooltipHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5684;

public class AnimatedTexturedWidget
extends Widget
implements WidgetTooltipHolder<AnimatedTexturedWidget> {
    protected final class_2960 texture;
    protected final int x;
    protected final int y;
    protected final int textureWidth;
    protected final int textureHeight;
    private final int animationCount;
    private final double animationDurationMS;
    private BiFunction<Integer, Integer, List<class_5684>> tooltipSupplier = (mouseX, mouseY) -> List.of();

    public AnimatedTexturedWidget(class_2960 texture, int x, int y, int textureWidth, int textureHeight, int animationDurationMS) {
        this.texture = texture;
        this.x = x;
        this.y = y;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.animationDurationMS = animationDurationMS;
        this.animationCount = textureHeight / textureWidth;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.textureWidth, this.textureWidth);
    }

    public AnimatedTexturedWidget tooltip(BiFunction<Integer, Integer, List<class_5684>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public List<class_5684> getTooltip(int mouseX, int mouseY) {
        return this.tooltipSupplier.apply(mouseX, mouseY);
    }

    public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap((class_332)draw);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.animationDurationMS > 0.0) {
            int index = class_3532.method_15384((double)((double)System.currentTimeMillis() / (this.animationDurationMS / (double)this.animationCount) % (double)this.animationCount));
            context.drawTexture(this.texture, this.x, this.y, 0, (float)this.textureWidth, (float)(index * this.textureWidth), this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
        } else {
            context.drawTexture(this.texture, this.x, this.y, 0, (float)this.textureWidth, (float)this.textureWidth, this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
        }
    }
}

