/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.SpectrumTrackedDataHandlerRegistry;
import de.dafuqs.spectrum.entity.entity.KindlingCoughEntity;
import de.dafuqs.spectrum.entity.variants.KindlingVariant;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.mixin.accessors.ProjectileAttackGoalAccessor;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1263;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1387;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1538;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4059;
import net.minecraft.class_4466;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_52;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6019;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class KindlingEntity
extends class_1496
implements class_1603,
class_5354,
class_5147 {
    private static final UUID HORSE_ARMOR_BONUS_ID = UUID.fromString("f55b70e7-db42-4384-8843-6e9c843336af");
    protected static final class_2940<KindlingVariant> VARIANT = class_2945.method_12791(KindlingEntity.class, SpectrumTrackedDataHandlerRegistry.KINDLING_VARIANT);
    protected static final class_1856 FOOD = class_1856.method_8106(SpectrumItemTags.KINDLING_FOOD);
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)30, (int)59);
    private static final class_2940<Integer> ANGER = class_2945.method_12791(KindlingEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> CLIPPED = class_2945.method_12791(KindlingEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> CHILL = class_2945.method_12791(KindlingEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EEPY_SNEEZE = class_2945.method_12791(KindlingEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> PLAYING = class_2945.method_12791(KindlingEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> INCITED = class_2945.method_12791(KindlingEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    protected UUID angryAt;
    public class_7094 standingAnimationState = new class_7094();
    public class_7094 walkingAnimationState = new class_7094();
    public class_7094 standingAngryAnimationState = new class_7094();
    public class_7094 walkingAngryAnimationState = new class_7094();
    public class_7094 glidingAnimationState = new class_7094();
    boolean thornsFlag = false;

    public KindlingEntity(class_1299<? extends KindlingEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, -0.75f);
        this.field_6194 = 8;
    }

    public static class_5132.class_5133 createKindlingAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23724, 25.0).method_26868(class_5134.field_23725, 12.0).method_26868(AdditionalEntityAttributes.MAGIC_PROTECTION, 6.0).method_26868(class_5134.field_23719, 0.6).method_26868(class_5134.field_23721, 25.0).method_26868(class_5134.field_23722, 1.5).method_26868(class_5134.field_23728, 12.0);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.method_18380(class_4050.field_18076);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1387((class_1496)this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new class_1359((class_1308)this, 0.5f));
        this.field_6201.method_6277(3, (class_1352)new CancellableProjectileAttackGoal(this, 1.25, 30, 20.0f));
        this.field_6201.method_6277(3, (class_1352)new MeleeChaseGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new PlayRoughGoal((class_1314)this));
        this.field_6201.method_6277(7, (class_1352)new class_1391((class_1314)this, 1.25, FOOD, false));
        this.field_6201.method_6277(8, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(9, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CoughRevengeGoal(this));
        this.field_6185.method_6277(2, new FindPlayMateGoal<class_1588>((class_1308)this, 4, 0.25f, class_1588.class));
        this.field_6185.method_6277(3, new FindPlayMateGoal<KindlingEntity>((class_1308)this, 10, 1.0f, KindlingEntity.class));
        this.field_6185.method_6277(4, new FindPlayMateGoal<class_1657>((class_1308)this, 40, 4.0f, class_1657.class));
        this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, false));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)KindlingVariant.DEFAULT);
        this.field_6011.method_12784(ANGER, (Object)0);
        this.field_6011.method_12784(CHILL, (Object)40);
        this.field_6011.method_12784(EEPY_SNEEZE, (Object)0);
        this.field_6011.method_12784(CLIPPED, (Object)0);
        this.field_6011.method_12784(PLAYING, (Object)false);
        this.field_6011.method_12784(INCITED, (Object)false);
    }

    public void method_5674(class_2940<?> data) {
        if (field_18064.equals(data)) {
            this.standingAnimationState.method_41325();
            this.walkingAnimationState.method_41325();
            this.standingAngryAnimationState.method_41325();
            this.walkingAngryAnimationState.method_41325();
            this.glidingAnimationState.method_41325();
            switch (this.method_18376()) {
                case field_18076: {
                    this.standingAnimationState.method_41322(this.field_6012);
                    break;
                }
                case field_38100: {
                    this.walkingAnimationState.method_41322(this.field_6012);
                    break;
                }
                case field_38097: {
                    this.standingAngryAnimationState.method_41322(this.field_6012);
                    break;
                }
                case field_38099: {
                    this.walkingAngryAnimationState.method_41322(this.field_6012);
                    break;
                }
                case field_18077: {
                    this.glidingAnimationState.method_41322(this.field_6012);
                    break;
                }
            }
        }
        super.method_5674(data);
    }

    public KindlingVariant getKindlingVariant() {
        return (KindlingVariant)this.field_6011.method_12789(VARIANT);
    }

    public void setKindlingVariant(KindlingVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public double method_5621() {
        return super.method_5621() - 0.25;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
        nbt.method_10582("variant", SpectrumRegistries.KINDLING_VARIANT.method_10221((Object)this.getKindlingVariant()).toString());
        nbt.method_10569("chillTime", this.getChillTime());
        nbt.method_10569("eepyTime", this.getEepyTime());
        nbt.method_10556("playing", this.isPlaying());
        if (!this.field_6962.method_5438(1).method_7960()) {
            nbt.method_10566("ArmorItem", (class_2520)this.field_6962.method_5438(1).method_7953(new class_2487()));
        }
    }

    public void method_5749(class_2487 nbt) {
        class_1799 itemStack;
        super.method_5749(nbt);
        this.method_29512(this.method_37908(), nbt);
        KindlingVariant variant = (KindlingVariant)SpectrumRegistries.KINDLING_VARIANT.method_10223(class_2960.method_12829((String)nbt.method_10558("variant")));
        this.setKindlingVariant(variant == null ? KindlingVariant.DEFAULT : variant);
        this.setChillTime(nbt.method_10550("chillTime"));
        this.setEepyTime(nbt.method_10550("eepyTime"));
        this.setPlaying(nbt.method_10577("playing"));
        if (nbt.method_10573("ArmorItem", 10) && !(itemStack = class_1799.method_7915((class_2487)nbt.method_10562("ArmorItem"))).method_7960() && this.method_6773(itemStack)) {
            this.field_6962.method_5447(1, itemStack);
        }
        this.method_6731();
    }

    public boolean method_6481(class_1799 stack) {
        return FOOD.method_8093(stack);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        KindlingEntity baby = (KindlingEntity)SpectrumEntityTypes.KINDLING.method_5883((class_1937)world);
        if (baby != null) {
            baby.setKindlingVariant(this.field_5974.method_43056() ? this.getKindlingVariant() : ((KindlingEntity)entity).getKindlingVariant());
        }
        return baby;
    }

    public class_1799 getArmorType() {
        return this.method_6118(class_1304.field_6174);
    }

    private void equipArmor(class_1799 stack) {
        this.method_5673(class_1304.field_6174, stack);
        this.method_5946(class_1304.field_6174, 0.0f);
    }

    protected void method_6731() {
        if (!this.method_37908().field_9236) {
            super.method_6731();
            this.setArmorTypeFromStack(this.field_6962.method_5438(1));
            this.method_5946(class_1304.field_6174, 0.0f);
        }
    }

    private void setArmorTypeFromStack(class_1799 stack) {
        this.equipArmor(stack);
        if (!this.method_37908().field_9236) {
            int armorBonus;
            this.method_5996(class_5134.field_23724).method_6200(HORSE_ARMOR_BONUS_ID);
            if (this.method_6773(stack) && (armorBonus = ((class_4059)stack.method_7909()).method_18455()) != 0) {
                this.method_5996(class_5134.field_23724).method_26835(new class_1322(HORSE_ARMOR_BONUS_ID, "Horse armor bonus", (double)armorBonus, class_1322.class_1323.field_6328));
            }
        }
    }

    public void method_5453(class_1263 sender) {
        class_1799 itemStack = this.getArmorType();
        super.method_5453(sender);
        class_1799 itemStack2 = this.getArmorType();
        if (this.field_6012 > 20 && this.method_6773(itemStack2) && itemStack != itemStack2) {
            this.method_5783(class_3417.field_15141, 0.5f, 1.0f);
        }
    }

    public boolean method_6735() {
        return true;
    }

    public boolean method_6773(class_1799 item) {
        return item.method_7909() instanceof class_4059;
    }

    protected class_3414 method_5994() {
        return SpectrumSoundEvents.ENTITY_KINDLING_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SpectrumSoundEvents.ENTITY_KINDLING_HURT;
    }

    protected class_3414 method_6002() {
        return SpectrumSoundEvents.ENTITY_KINDLING_DEATH;
    }

    protected class_3414 method_6747() {
        return SpectrumSoundEvents.ENTITY_KINDLING_ANGRY;
    }

    protected void method_6723() {
        this.method_5783(SpectrumSoundEvents.ENTITY_KINDLING_JUMP, 0.4f, 1.0f);
    }

    public boolean method_6763() {
        return !this.method_24828();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() instanceof KindlingEntity) {
            amount = 1.0f;
            if (this.field_5974.method_43056()) {
                this.setChillTime(0);
            }
        }
        if (amount > 1.0f) {
            this.setPlaying(false);
        }
        this.thornsFlag = source.method_49708(class_8111.field_42330);
        return super.method_5643(source, amount);
    }

    public void method_6015(@Nullable class_1309 attacker) {
        if (!this.thornsFlag) {
            super.method_6015(attacker);
        }
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.6f * dimensions.field_18068;
    }

    protected void method_5958() {
        super.method_5958();
        if (!this.method_37908().method_8608()) {
            int eepy;
            this.method_29510((class_3218)this.method_37908(), false);
            this.setClipped(this.getClipTime() - 1);
            this.setChillTime(this.getChillTime() - 1);
            if (this.method_6059(SpectrumStatusEffects.ETERNAL_SLUMBER)) {
                this.ascend(2);
            }
            if (this.method_6059(SpectrumStatusEffects.FATAL_SLUMBER)) {
                this.ascend(3);
            }
            if (this.method_6059(SpectrumStatusEffects.SOMNOLENCE) && this.getEepyTime() == 0) {
                this.setEepyTime(100);
            }
            if ((eepy = this.getEepyTime()) > 1) {
                this.setEepyTime(eepy - 1);
            } else if (eepy == 1) {
                this.setEepyTime(0);
                this.ascend(1);
            }
        }
        if (this.field_6012 % 600 == 0) {
            this.method_6025(1.0f);
        }
    }

    public boolean method_5853(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float explosionPower) {
        return super.method_5853(explosion, world, pos, state, explosionPower);
    }

    private void ascend(int blastMod) {
        class_1937 world = this.method_37908();
        world.method_8406((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318(), this.method_23321(), 1.0, 0.0, 0.0);
        world.method_8454((class_1297)this, SpectrumDamageTypes.incandescence(world), null, this.method_23317(), this.method_23318(), this.method_23321(), 10.0f * (float)blastMod, true, class_1937.class_7867.field_40890);
        this.method_5783(class_3417.field_14803, 2.0f, 0.5f);
        this.method_5783(SpectrumSoundEvents.DEEP_CRYSTAL_RING, 2.0f, 0.334f);
        this.method_5783(class_3417.field_15024, 1.0f, 2.0f);
        ((class_3218)world).method_18766(p -> p.method_5739((class_1297)this) < 64.0f).forEach(p -> Support.grantAdvancementCriterion(p, "ascend_kindling", "he_explarded"));
        for (int i = 0; i < 5; ++i) {
            ((class_3218)world).method_14199((class_2394)class_2398.field_11216, this.method_23322(1.5), this.method_23318() + this.field_5974.method_43058(), this.method_23325(1.5), this.field_5974.method_43048(6) + 1, 0.0, (double)(this.field_5974.method_43057() / 3.0f), 0.0, 0.0);
            ((class_3218)world).method_14199((class_2394)class_2398.field_11207, this.method_23322(1.5), this.method_23318() + this.field_5974.method_43058(), this.method_23325(1.5), this.field_5974.method_43048(6) + 1, 0.0, (double)(this.field_5974.method_43057() / 3.0f), 0.0, 0.0);
        }
        for (class_2338 transmutePos : class_2338.method_25996((class_2338)this.method_24515(), (int)(12 * blastMod), (int)(6 * blastMod), (int)(12 * blastMod))) {
            class_2680 candidate;
            double distance = Math.sqrt(transmutePos.method_10262((class_2382)this.method_24515()));
            if (!(distance <= (double)(6 * blastMod)) && !((double)this.field_5974.method_43057() < 1.0 / ((distance - 6.0) / 3.0)) || (candidate = world.method_8320(transmutePos)).method_26214((class_1922)world, transmutePos) < 0.0f || !GenericClaimModsCompat.canBreak(world, transmutePos, (class_1297)this)) continue;
            if (candidate.method_26215()) {
                if (!(this.field_5974.method_43057() < 0.125f)) continue;
                ((class_3218)world).method_14199((class_2394)class_2398.field_11216, (double)transmutePos.method_10263() + this.field_5974.method_43058(), (double)transmutePos.method_10264() + this.field_5974.method_43058(), (double)transmutePos.method_10260() + this.field_5974.method_43058(), this.field_5974.method_43048(3) + 1, (double)(this.field_5974.method_43057() / 5.0f) - 0.1, (double)(this.field_5974.method_43057() / 5.0f) - 0.1, (double)(this.field_5974.method_43057() / 5.0f) - 0.1, 0.0);
                continue;
            }
            if (!GenericClaimModsCompat.canModify(world, transmutePos, (class_1297)this) || candidate.method_26227().method_15767(class_3486.field_15517)) continue;
            if (this.field_5974.method_43057() < 0.025f) {
                world.method_8501(transmutePos, class_2246.field_10092.method_9564());
                continue;
            }
            if (candidate.method_26164(class_3481.field_25806) || candidate.method_26164(class_3481.field_25807)) {
                if (this.field_5974.method_43057() < 0.05f) {
                    world.method_8501(transmutePos, class_2246.field_22423.method_9564());
                    continue;
                }
                world.method_8501(transmutePos, class_2246.field_10471.method_9564());
                continue;
            }
            if (candidate.method_26164(SpectrumBlockTags.BASE_STONE_DEEPER_DOWN)) {
                world.method_8501(transmutePos, SpectrumBlocks.BLACK_MATERIA.method_9564());
                continue;
            }
            if (candidate.method_26164(class_3481.field_15475)) {
                world.method_8501(transmutePos, class_2246.field_10381.method_9564());
                continue;
            }
            if (candidate.method_26164(class_3481.field_29822)) {
                world.method_8501(transmutePos, class_2246.field_10073.method_9564());
                continue;
            }
            if (candidate.method_27852(class_2246.field_10460)) {
                world.method_8501(transmutePos, class_2246.field_10415.method_9564());
                continue;
            }
            if (candidate.method_26164(class_3481.field_15466)) {
                world.method_8501(transmutePos, class_2246.field_10087.method_9564());
                continue;
            }
            if (!candidate.method_27852(class_2246.field_10540)) continue;
            world.method_8501(transmutePos, class_2246.field_22423.method_9564());
        }
        this.method_5650(class_1297.class_5529.field_26999);
        class_1538 lightning = new class_1538(class_1299.field_6112, world);
        lightning.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
        world.method_8649((class_1297)lightning);
    }

    public void method_6007() {
        super.method_6007();
        class_243 velocity = this.method_18798();
        boolean onGround = this.method_24828();
        if (!onGround && velocity.field_1351 < 0.0) {
            this.method_18799(velocity.method_18805(1.0, 0.6, 1.0));
        }
        if (onGround || (double)this.field_6017 < 0.2) {
            boolean isMoving;
            boolean bl = isMoving = this.method_23317() - this.field_6014 != 0.0 || this.method_23321() - this.field_5969 != 0.0;
            if (this.method_29507() > 0) {
                this.method_18380(isMoving ? class_4050.field_38099 : class_4050.field_38097);
            } else {
                this.method_18380(isMoving ? class_4050.field_38098 : class_4050.field_18076);
            }
        } else {
            this.method_18380(class_4050.field_18077);
        }
    }

    protected boolean method_5776() {
        return true;
    }

    protected void method_5801() {
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean bl;
        if (this.method_29507() > 0) {
            return class_1269.field_5814;
        }
        class_1799 handStack = player.method_6047();
        if (this.method_27072() && handStack.method_31573(ConventionalItemTags.SHEARS)) {
            if (!this.method_37908().method_8608()) {
                this.method_5980((class_1309)player);
                this.takeRevenge(player.method_5667());
                this.method_6757();
                this.method_6636(class_3419.field_15248);
                this.method_32875(class_5712.field_28730, (class_1297)player);
                if (!this.method_37908().field_9236) {
                    handStack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        boolean bl2 = bl = !this.method_6109() && this.method_6727() && player.method_21823();
        if (!this.method_5782() && !bl) {
            if (!handStack.method_7960()) {
                if (this.method_6481(handStack)) {
                    return this.method_30009(player, handStack);
                }
                if (!this.method_6727()) {
                    this.method_6757();
                    return class_1269.method_29236((boolean)this.method_37908().field_9236);
                }
            }
            if (player.method_21823()) {
                return super.method_5992(player, hand);
            }
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(class_3419 shearedSoundCategory) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, shearedSoundCategory, 1.0f, 1.0f);
        this.setClipped(4800);
        for (class_1799 clippedStack : this.getClippedStacks((class_3218)this.method_37908())) {
            this.method_5699(clippedStack, 0.3f);
        }
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109() && !this.isClipped();
    }

    protected boolean method_6742(class_1657 player, class_1799 item) {
        boolean canEat = false;
        if (this.method_6032() < this.method_6063()) {
            this.method_6025(2.0f);
            canEat = true;
        }
        if (this.method_6109()) {
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            if (!this.method_37908().field_9236) {
                this.method_5615(20);
            }
            canEat = true;
        } else if (!this.method_37908().field_9236 && !this.method_6479()) {
            this.method_6480(player);
            canEat = true;
        }
        if ((canEat || !this.method_6727()) && this.method_6729() < this.method_6755()) {
            canEat = true;
            if (!this.method_37908().field_9236) {
                this.method_6745(3);
            }
        }
        if (canEat) {
            this.method_32876(class_5712.field_28735);
        }
        return canEat;
    }

    public void method_29510(class_3218 world, boolean angerPersistent) {
        class_1309 livingEntity = this.method_5968();
        UUID uUID = this.method_29508();
        if ((livingEntity == null || livingEntity.method_29504()) && uUID != null && world.method_14190(uUID) instanceof class_1308) {
            this.method_29922();
        } else if (!(this.method_29507() <= 0 || livingEntity != null && livingEntity.method_5864() == class_1299.field_6097 && angerPersistent)) {
            this.method_29514(this.method_29507() - 1);
            if (this.method_29507() == 0) {
                this.method_29922();
            }
        }
    }

    public List<class_1799> getClippedStacks(class_3218 world) {
        class_52 lootTable = world.method_8503().method_3857().getLootTable(this.getKindlingVariant().clippingLootTable());
        return lootTable.method_51878(new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)this).method_51875(class_173.field_22403));
    }

    protected void coughAt(class_1309 target) {
        KindlingCoughEntity kindlingCoughEntity = new KindlingCoughEntity(this.method_37908(), (class_1309)this);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323((double)0.33f) - kindlingCoughEntity.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = Math.sqrt(d * d + f * f) * 0.2;
        kindlingCoughEntity.method_7485(d, e + g, f, 1.5f, 10.0f);
        if (!this.method_5701()) {
            this.method_5783(SpectrumSoundEvents.ENTITY_KINDLING_SHOOT, 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        this.method_37908().method_8649((class_1297)kindlingCoughEntity);
    }

    public boolean isClipped() {
        return (Integer)this.field_6011.method_12789(CLIPPED) > 0;
    }

    public int getClipTime() {
        return (Integer)this.field_6011.method_12789(CLIPPED);
    }

    public void setClipped(int clipTime) {
        this.field_6011.method_12778(CLIPPED, (Object)clipTime);
    }

    public int getChillTime() {
        return (Integer)this.field_6011.method_12789(CHILL);
    }

    public void setChillTime(int chillTime) {
        this.field_6011.method_12778(CHILL, (Object)chillTime);
    }

    public void setEepyTime(int eepySneeze) {
        this.field_6011.method_12778(EEPY_SNEEZE, (Object)eepySneeze);
    }

    public int getEepyTime() {
        return (Integer)this.field_6011.method_12789(EEPY_SNEEZE);
    }

    public void setPlaying(boolean playing) {
        this.field_6011.method_12778(PLAYING, (Object)playing);
    }

    public boolean isPlaying() {
        return (Boolean)this.field_6011.method_12789(PLAYING);
    }

    public void setIncited(boolean incited) {
        this.field_6011.method_12778(INCITED, (Object)incited);
    }

    public boolean isIncited() {
        return (Boolean)this.field_6011.method_12789(INCITED);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER);
    }

    public void method_29514(int angerTime) {
        this.field_6011.method_12778(ANGER, (Object)angerTime);
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void takeRevenge(UUID target) {
        this.method_29513(target);
        this.setIncited(false);
        this.setPlaying(false);
        this.method_29509();
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.coughAt(target);
    }

    public boolean method_6762() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_6474(class_1429 other) {
        if (other == this) return false;
        if (!(other instanceof KindlingEntity)) return false;
        KindlingEntity otherKindling = (KindlingEntity)other;
        if (!this.method_6734()) return false;
        if (!otherKindling.method_6734()) return false;
        return true;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    protected class CancellableProjectileAttackGoal
    extends class_1381 {
        public CancellableProjectileAttackGoal(class_1603 mob, double mobSpeed, int intervalTicks, float maxShootRange) {
            super(mob, mobSpeed, intervalTicks, maxShootRange);
        }

        public boolean method_6266() {
            return KindlingEntity.this.method_29511() && super.method_6266() && KindlingEntity.this.method_5739((class_1297)this.getProjectileTarget()) > 3.0f;
        }

        public boolean method_6264() {
            return super.method_6264() && !KindlingEntity.this.isPlaying() && KindlingEntity.this.method_5739((class_1297)this.getProjectileTarget()) > 4.0f;
        }

        protected class_1309 getProjectileTarget() {
            return ((ProjectileAttackGoalAccessor)((Object)this)).getProjectileAttackTarget();
        }
    }

    protected class MeleeChaseGoal
    extends class_1366 {
        public MeleeChaseGoal(KindlingEntity kindling) {
            super((class_1314)kindling, (double)0.6f, true);
        }

        public boolean method_6264() {
            KindlingEntity kindling = KindlingEntity.this;
            UUID angryAt = kindling.method_29508();
            if (angryAt == null) {
                return false;
            }
            return super.method_6264() && kindling.method_29511() && !KindlingEntity.this.isPlaying() && KindlingEntity.this.method_5739((class_1297)this.field_6503.method_5968()) < 5.0f;
        }

        public boolean method_6266() {
            return super.method_6266() && KindlingEntity.this.method_5739((class_1297)this.field_6503.method_5968()) < 9.0f;
        }
    }

    protected class PlayRoughGoal
    extends class_1366 {
        public PlayRoughGoal(class_1314 mob) {
            super(mob, (double)0.4f, true);
        }

        public boolean method_6264() {
            return super.method_6264() && !KindlingEntity.this.method_29511() && !KindlingEntity.this.method_5782() && KindlingEntity.this.isPlaying();
        }

        public boolean method_6266() {
            KindlingEntity playMate;
            if (!super.method_6266()) {
                return false;
            }
            class_1309 class_13092 = KindlingEntity.this.method_5968();
            if (class_13092 instanceof KindlingEntity && (playMate = (KindlingEntity)class_13092).method_29511() || KindlingEntity.this.method_5782()) {
                KindlingEntity.this.method_5980(null);
                KindlingEntity.this.setIncited(false);
                return false;
            }
            return !KindlingEntity.this.method_29511();
        }

        protected void method_6288(class_1309 target, double squaredDistance) {
            double d = this.method_6289(target);
            if (squaredDistance <= d && this.method_28348() <= 0) {
                KindlingEntity playMate;
                this.method_28346();
                this.field_6503.method_6104(class_1268.field_5808);
                this.field_6503.method_6121((class_1297)target);
                if (target instanceof KindlingEntity && !(playMate = (KindlingEntity)target).method_29511() && KindlingEntity.this.field_5974.method_43056()) {
                    playMate.setIncited(true);
                }
                if (!(target instanceof class_1569)) {
                    target.method_6092(new class_1293(class_1294.field_5924, 200));
                }
                if (KindlingEntity.this.field_5974.method_43056()) {
                    this.method_6270();
                    KindlingEntity.this.setIncited(false);
                    this.field_6503.method_5980(null);
                    KindlingEntity.this.setChillTime(2400 * (target instanceof class_1657 ? 2 : 1));
                }
            }
        }
    }

    protected class CoughRevengeGoal
    extends class_1399 {
        public CoughRevengeGoal(KindlingEntity kindling) {
            super((class_1314)kindling, new Class[]{KindlingEntity.class});
        }

        public boolean method_6266() {
            return KindlingEntity.this.method_29511() && super.method_6266();
        }

        public void method_6269() {
            super.method_6269();
            class_1309 attacker = KindlingEntity.this.method_6065();
            if (attacker != null) {
                KindlingEntity.this.takeRevenge(KindlingEntity.this.method_6065().method_5667());
            }
        }

        protected void method_6319(class_1308 mob, class_1309 target) {
            if (mob instanceof class_4466 && this.field_6660.method_6057((class_1297)target)) {
                mob.method_5980(target);
            }
        }
    }

    protected class FindPlayMateGoal<T extends class_1309>
    extends class_1400<T> {
        private final float waitModifier;

        public FindPlayMateGoal(class_1308 mob, int reciprocalChance, float waitModifier, Class<T> targetClass) {
            super(mob, targetClass, reciprocalChance, true, true, null);
            this.waitModifier = waitModifier;
        }

        public boolean method_6264() {
            int chill;
            if (KindlingEntity.this.method_29511() || KindlingEntity.this.method_5782() || KindlingEntity.this.method_6479()) {
                return false;
            }
            if (!KindlingEntity.this.isIncited() && (chill = KindlingEntity.this.getChillTime()) > 0) {
                return false;
            }
            if (KindlingEntity.this.isIncited() || this.field_6641 > 0 && this.field_6660.method_6051().method_43048(this.field_6641) != 0) {
                this.method_18415();
                if (this.field_6644 != null) {
                    KindlingEntity.this.setChillTime((int)(1200.0f * this.waitModifier));
                    return true;
                }
            }
            return false;
        }

        public void method_6269() {
            super.method_6269();
            KindlingEntity.this.setPlaying(true);
        }
    }
}

