/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.blocks.shooting_star.ShootingStar;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarItem;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.effect.DynamicParticleEffectAlwaysShow;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumLootTables;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_52;
import net.minecraft.class_5459;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

public class ShootingStarEntity
extends class_1297 {
    private static final class_2940<Integer> SHOOTING_STAR_TYPE = class_2945.method_12791(ShootingStarEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> PLAYER_PLACED = class_2945.method_12791(ShootingStarEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HARDENED = class_2945.method_12791(ShootingStarEntity.class, (class_2941)class_2943.field_13323);
    protected final float hoverHeight;
    protected long age;
    protected int availableHits;
    protected int lastCollisionCount;

    public ShootingStarEntity(class_1299<? extends ShootingStarEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.hoverHeight = (float)(Math.random() * Math.PI * 2.0);
        this.availableHits = 5 + world.field_9229.method_43048(3);
        this.lastCollisionCount = 0;
    }

    public ShootingStarEntity(class_1937 world, double x, double y, double z) {
        this(SpectrumEntityTypes.SHOOTING_STAR, world);
        this.method_5814(x, y, z);
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.setShootingStarType(ShootingStar.Type.COLORFUL, false, false);
        this.lastCollisionCount = 0;
    }

    public ShootingStarEntity(class_1937 world) {
        this(world, 0.0, 0.0, 0.0);
    }

    @Environment(value=EnvType.CLIENT)
    private ShootingStarEntity(@NotNull ShootingStarEntity entity) {
        super(entity.method_5864(), entity.method_37908());
        this.setShootingStarType(entity.getShootingStarType(), false, false);
        this.method_5719(entity);
        this.availableHits = entity.availableHits;
        this.age = entity.age;
        this.hoverHeight = entity.hoverHeight;
        this.lastCollisionCount = entity.lastCollisionCount;
    }

    public static boolean canCollide(class_1297 entity, @NotNull class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public static void playHitParticles(class_1937 world, double x, double y, double z, ShootingStar.Type type, int amount) {
        class_5819 random = world.field_9229;
        for (int i = 0; i < amount; ++i) {
            float randomScale = 0.5f + random.method_43057();
            int randomLifetime = 10 + random.method_43048(20);
            DynamicParticleEffectAlwaysShow particleEffect = new DynamicParticleEffectAlwaysShow(0.98f, type.getRandomParticleColor(random), randomScale, randomLifetime, false, true);
            world.method_8406((class_2394)particleEffect, x, y, z, 0.35 - (double)random.method_43057() * 0.7, (double)random.method_43057() * 0.7, 0.35 - (double)random.method_43057() * 0.7);
        }
    }

    public boolean method_30949(class_1297 other) {
        return ShootingStarEntity.canCollide(this, other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_5810() {
        return true;
    }

    protected class_243 method_30633(class_2350.class_2351 portalAxis, class_5459.class_5460 portalRect) {
        return class_1309.method_31079((class_243)super.method_30633(portalAxis, portalRect));
    }

    protected void method_5693() {
        this.method_5841().method_12784(SHOOTING_STAR_TYPE, (Object)ShootingStar.Type.COLORFUL.ordinal());
        this.method_5841().method_12784(PLAYER_PLACED, (Object)false);
        this.method_5841().method_12784(HARDENED, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        this.method_18379();
        boolean wasOnGround = this.method_24828();
        double previousXVelocity = this.method_18798().method_10216();
        double previousYVelocity = this.method_18798().method_10214();
        double previousZVelocity = this.method_18798().method_10215();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.field_5960 = false;
        } else {
            boolean bl = this.field_5960 = !this.method_37908().method_8587((class_1297)this, this.method_5829().method_1011(1.0E-7));
            if (this.field_5960) {
                this.method_5632(this.method_23317(), (this.method_5829().field_1322 + this.method_5829().field_1325) / 2.0, this.method_23321());
            }
        }
        if (!this.method_5740()) {
            double d = this.method_5799() ? -0.005 : -0.04;
            this.method_18799(this.method_18798().method_1031(0.0, d, 0.0));
            if (!this.method_24828()) {
                this.method_18799(this.method_18798().method_1021(0.95));
            }
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        List<class_1297> collidingEntities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1009(0.25, 0.334, 0.25));
        collidingEntities = collidingEntities.stream().filter(entity -> !(entity instanceof ShootingStarEntity) && entity.method_5810()).collect(Collectors.toList());
        boolean spawnLoot = false;
        boolean playerPlaced = (Boolean)this.field_6011.method_12789(PLAYER_PLACED);
        boolean hardened = (Boolean)this.field_6011.method_12789(HARDENED);
        if (this.method_24828() && !wasOnGround) {
            this.method_5762(0.0, -previousYVelocity * 0.9, 0.0);
            collidingEntities.forEach(entity -> entity.method_5784(class_1313.field_6306, this.method_18798().method_18805(0.0, 1.0, 0.0)));
        }
        if (Math.signum(this.method_18798().field_1352) != Math.signum(previousXVelocity)) {
            this.method_5762(-previousXVelocity * 0.6, 0.0, 0.0);
            if (!hardened && Math.abs(previousXVelocity) > 0.5) {
                spawnLoot = true;
            }
        }
        if (Math.signum(this.method_18798().field_1350) != Math.signum(previousZVelocity)) {
            this.method_5762(0.0, 0.0, -previousZVelocity * 0.6);
            if (!hardened && !spawnLoot && Math.abs(previousZVelocity) > 0.5) {
                spawnLoot = true;
            }
        }
        collidingEntities.forEach(entity -> {
            if (entity.method_23318() >= this.method_5829().field_1325) {
                entity.field_6017 = 0.0f;
                if (this.method_5863()) {
                    entity.method_5814(entity.method_19538().field_1352, this.method_5829().field_1325, entity.method_19538().field_1350);
                }
                entity.method_5784(class_1313.field_6306, this.method_18798());
                entity.method_24830(true);
            }
        });
        if (world.field_9236) {
            if (!playerPlaced && !hardened) {
                if (this.method_24828()) {
                    if (world.field_9229.method_43048(10) == 0) {
                        this.playGroundParticles();
                    }
                } else if (world.field_9229.method_43056()) {
                    this.playFallingParticles();
                }
            }
        } else {
            List otherEntities;
            ++this.age;
            if (this.age > 6000L && !playerPlaced && !hardened) {
                this.method_31472();
                return;
            }
            this.method_5852();
            if (spawnLoot && this.age > 1L) {
                ++this.lastCollisionCount;
                if (this.lastCollisionCount > 8) {
                    --this.availableHits;
                    if (this.availableHits > 0) {
                        class_1799 shootingStarStack = ShootingStarItem.getWithRemainingHits((ShootingStarItem)this.asItem(), this.availableHits, (boolean)((Boolean)this.field_6011.method_12789(HARDENED)));
                        itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), shootingStarStack);
                        this.method_37908().method_8649((class_1297)itemEntity);
                    } else {
                        class_1799 starFragmentStack = SpectrumItems.STAR_FRAGMENT.method_7854();
                        itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), starFragmentStack);
                        this.method_37908().method_8649((class_1297)itemEntity);
                    }
                    this.method_31472();
                } else {
                    List<class_1799> loot = this.getLoot((class_3218)this.method_37908(), SpectrumLootTables.SHOOTING_STAR_BOUNCE);
                    for (class_1799 itemStack : loot) {
                        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
                        this.method_37908().method_8649((class_1297)itemEntity);
                    }
                    SpectrumS2CPacketSender.sendPlayShootingStarParticles(this);
                    this.method_37908().method_8396(null, this.method_24515(), SpectrumSoundEvents.SHOOTING_STAR_CRACKER, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            if (!hardened && !wasOnGround && this.method_24828() && previousYVelocity < -0.5) {
                SpectrumS2CPacketSender.playParticleWithExactVelocity((class_3218)this.method_37908(), this.method_19538(), (class_2394)class_2398.field_11236, 1, class_243.field_1353);
                if (!spawnLoot) {
                    SpectrumS2CPacketSender.sendPlayShootingStarParticles(this);
                    this.method_37908().method_8396(null, this.method_24515(), SpectrumSoundEvents.SHOOTING_STAR_CRACKER, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            if (!(otherEntities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009(0.2, -0.01, 0.2), class_1301.method_5911((class_1297)this))).isEmpty()) {
                for (class_1297 d : otherEntities) {
                    this.method_5697(d);
                }
            }
            this.method_5876();
        }
    }

    public void method_5694(class_1657 player) {
        if (!this.method_37908().method_8608() && !((Boolean)this.field_6011.method_12789(HARDENED)).booleanValue() && !this.method_24828() && this.method_18798().method_10214() < -0.5) {
            this.method_37908().method_43128(null, (double)this.method_24515().method_10263(), (double)this.method_24515().method_10264(), (double)this.method_24515().method_10260(), SpectrumSoundEvents.SHOOTING_STAR_CRACKER, class_3419.field_15248, 1.5f + this.field_5974.method_43057() * 0.4f, 0.8f + this.field_5974.method_43057() * 0.4f);
            SpectrumS2CPacketSender.sendPlayShootingStarParticles(this);
            player.method_5643(SpectrumDamageTypes.shootingStar(this.method_37908()), 18.0f);
            class_1799 itemStack = this.getShootingStarType().getBlock().method_8389().method_7854();
            int i = itemStack.method_7947();
            player.method_31548().method_7398(itemStack);
            Support.grantAdvancementCriterion((class_3222)player, "catch_shooting_star", "catch");
            player.method_7342(class_3468.field_15392.method_14956((Object)itemStack.method_7909()), i);
            this.method_31472();
        }
    }

    public void method_5697(class_1297 entity) {
        if (entity.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entity);
        }
    }

    public class_1792 asItem() {
        return this.getShootingStarType().getBlock().method_8389();
    }

    public void playGroundParticles() {
        float randomScale = 0.5f + this.field_5974.method_43057();
        int randomLifetime = 30 + this.field_5974.method_43048(20);
        DynamicParticleEffectAlwaysShow particleEffect = new DynamicParticleEffectAlwaysShow(0.05f, this.getShootingStarType().getRandomParticleColor(this.field_5974), randomScale, randomLifetime, false, true);
        this.method_37908().method_8406((class_2394)particleEffect, this.method_23317(), this.method_23320(), this.method_23321(), 0.1 - (double)this.field_5974.method_43057() * 0.2, 0.4 + (double)this.field_5974.method_43057() * 0.2, 0.1 - (double)this.field_5974.method_43057() * 0.2);
    }

    public void playFallingParticles() {
        float randomScale = this.field_5974.method_43057() * 0.4f + 0.7f;
        DynamicParticleEffectAlwaysShow particleEffect = new DynamicParticleEffectAlwaysShow((float)((this.field_5974.method_43058() - 0.5) * (double)0.05f - 0.125), this.getShootingStarType().getRandomParticleColor(this.field_5974), randomScale, 120, false, true);
        this.method_37908().method_8406((class_2394)particleEffect, this.method_23317(), this.method_23320(), this.method_23321(), 0.2 - (double)this.field_5974.method_43057() * 0.4, 0.1, 0.2 - (double)this.field_5974.method_43057() * 0.4);
    }

    public void playHitParticles() {
        ShootingStarEntity.playHitParticles(this.method_37908(), this.method_23317(), this.method_23320(), this.method_23321(), this.getShootingStarType(), 25);
    }

    public void doPlayerHitEffectsAndLoot(class_3218 serverWorld, class_3222 serverPlayerEntity) {
        class_2960 lootTableId = ShootingStar.Type.getLootTableIdentifier((Integer)this.field_6011.method_12789(SHOOTING_STAR_TYPE));
        List<class_1799> loot = this.getLoot(serverWorld, serverPlayerEntity, lootTableId);
        for (class_1799 itemStack : loot) {
            class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
            this.method_37908().method_8649((class_1297)itemEntity);
        }
        SpectrumS2CPacketSender.sendPlayShootingStarParticles(this);
        this.method_37908().method_43128(null, (double)this.method_24515().method_10263(), (double)this.method_24515().method_10264(), (double)this.method_24515().method_10260(), SpectrumSoundEvents.SHOOTING_STAR_CRACKER, class_3419.field_15248, 1.5f + this.field_5974.method_43057() * 0.4f, 0.8f + this.field_5974.method_43057() * 0.4f);
    }

    public List<class_1799> getLoot(class_3218 serverWorld, class_3222 serverPlayerEntity, class_2960 lootTableId) {
        class_52 lootTable = serverWorld.method_8503().method_3857().getLootTable(lootTableId);
        return lootTable.method_51878(new class_8567.class_8568(serverWorld).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.method_24515())).method_51874(class_181.field_1231, (Object)serverPlayerEntity.method_37908().method_48963().method_48802((class_1657)serverPlayerEntity)).method_51877(class_181.field_1233, (Object)serverPlayerEntity).method_51875(class_173.field_1173));
    }

    public List<class_1799> getLoot(class_3218 serverWorld, class_2960 lootTableId) {
        class_52 lootTable = serverWorld.method_8503().method_3857().getLootTable(lootTableId);
        return lootTable.method_51878(new class_8567.class_8568(serverWorld).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.method_24515())).method_51874(class_181.field_1231, (Object)serverWorld.method_48963().method_48830()).method_51875(class_173.field_1173));
    }

    public class_2561 method_5477() {
        class_2561 text = this.method_5797();
        return text != null ? text : this.asItem().method_7848();
    }

    public boolean method_5698(class_1297 attacker) {
        if (!this.method_31481()) {
            if (!this.method_37908().method_8608()) {
                if (!((Boolean)this.field_6011.method_12789(HARDENED)).booleanValue()) {
                    this.age = 1L;
                    --this.availableHits;
                    class_1937 class_19372 = this.method_37908();
                    if (class_19372 instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)class_19372;
                        if (attacker instanceof class_3222) {
                            class_3222 serverPlayerEntity = (class_3222)attacker;
                            this.doPlayerHitEffectsAndLoot(serverWorld, serverPlayerEntity);
                            this.lastCollisionCount = 0;
                        }
                    }
                    if (this.availableHits <= 0) {
                        SpectrumS2CPacketSender.playParticleWithExactVelocity((class_3218)this.method_37908(), this.method_19538(), (class_2394)class_2398.field_11236, 1, class_243.field_1353);
                        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), SpectrumItems.STAR_FRAGMENT.method_7854());
                        itemEntity.method_5762(0.0, 0.15, 0.0);
                        this.method_37908().method_8649((class_1297)itemEntity);
                        this.method_31472();
                        return true;
                    }
                }
                this.method_32875(class_5712.field_28736, attacker);
            }
            double attackerOffsetX = this.method_23317() - attacker.method_23317();
            double attackerOffsetZ = this.method_23321() - attacker.method_23321();
            double mod = Math.max(attackerOffsetX, attackerOffsetZ);
            this.method_5762(attackerOffsetX / mod * 0.75, 0.25, attackerOffsetZ / mod * 0.75);
            List<class_1297> collidingEntities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1009(0.25, 0.334, 0.25));
            collidingEntities = collidingEntities.stream().filter(entity -> !(entity instanceof ShootingStarEntity)).collect(Collectors.toList());
            collidingEntities.forEach(entity -> {
                if (entity.method_23318() >= this.method_5829().field_1325) {
                    entity.field_6017 = 0.0f;
                    if (this.method_5863()) {
                        entity.method_5814(entity.method_19538().field_1352, this.method_5829().field_1325, entity.method_19538().field_1350);
                    }
                    entity.method_5784(class_1313.field_6306, this.method_18798());
                    entity.method_24830(true);
                }
            });
            this.method_5785();
        }
        return false;
    }

    public void setAvailableHits(int availableHits) {
        this.availableHits = availableHits;
    }

    public boolean method_5679(@NotNull class_1282 damageSource) {
        if (damageSource.method_49708(class_8111.field_42357) || damageSource.method_49708(SpectrumDamageTypes.FLOATBLOCK)) {
            return false;
        }
        return damageSource.method_48789(class_8103.field_42246) || super.method_5679(damageSource);
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        if (amount > 5.0f && (damageSource.method_49708(class_8111.field_42357) || damageSource.method_49708(SpectrumDamageTypes.FLOATBLOCK))) {
            this.playHitParticles();
            class_1799 starFragmentStack = SpectrumItems.STAR_FRAGMENT.method_7854();
            starFragmentStack.method_7939(2);
            class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), starFragmentStack);
            this.method_37908().method_8649((class_1297)itemEntity);
            this.method_31472();
            return true;
        }
        this.method_5785();
        return false;
    }

    public ShootingStar.Type getShootingStarType() {
        return ShootingStar.Type.getType((Integer)this.method_5841().method_12789(SHOOTING_STAR_TYPE));
    }

    public void setShootingStarType(@NotNull ShootingStar.Type type, boolean playerPlaced, boolean hardened) {
        this.method_5841().method_12778(SHOOTING_STAR_TYPE, (Object)type.ordinal());
        this.method_5841().method_12778(PLAYER_PLACED, (Object)playerPlaced);
        this.method_5841().method_12778(HARDENED, (Object)hardened);
    }

    public void method_5652(@NotNull class_2487 tag) {
        tag.method_10544("Age", (long)((short)this.age));
        tag.method_10582("Type", this.getShootingStarType().getName());
        tag.method_10569("LastCollisionCount", this.lastCollisionCount);
        tag.method_10556("PlayerPlaced", ((Boolean)this.field_6011.method_12789(PLAYER_PLACED)).booleanValue());
        tag.method_10556("Hardened", ((Boolean)this.field_6011.method_12789(HARDENED)).booleanValue());
    }

    public void method_5749(@NotNull class_2487 tag) {
        this.age = tag.method_10537("Age");
        if (tag.method_10573("LastCollisionCount", 99)) {
            this.lastCollisionCount = tag.method_10550("LastCollisionCount");
        }
        boolean playerPlaced = false;
        if (tag.method_10545("PlayerPlaced")) {
            playerPlaced = tag.method_10577("PlayerPlaced");
        }
        boolean hardened = false;
        if (tag.method_10545("Hardened")) {
            hardened = tag.method_10577("Hardened");
        }
        if (tag.method_10573("Type", 8)) {
            this.setShootingStarType(ShootingStar.Type.getType(tag.method_10558("Type")), playerPlaced, hardened);
        } else {
            this.method_31472();
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.method_37908().method_8608() && player.method_5715()) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
            player.method_31548().method_7398(ShootingStarItem.getWithRemainingHits((ShootingStarItem)this.asItem(), this.availableHits, (boolean)((Boolean)this.field_6011.method_12789(HARDENED))));
            this.method_31472();
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public class_1799 method_31480() {
        return ShootingStarItem.getWithRemainingHits((ShootingStarItem)this.asItem(), this.availableHits, (boolean)((Boolean)this.field_6011.method_12789(HARDENED)));
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public class_3419 method_5634() {
        return class_3419.field_15256;
    }
}

