/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.explosion;

import de.dafuqs.spectrum.api.item.ModularExplosionProvider;
import de.dafuqs.spectrum.explosion.ExplosionArchetype;
import de.dafuqs.spectrum.explosion.ExplosionModifier;
import de.dafuqs.spectrum.explosion.ExplosionModifierType;
import de.dafuqs.spectrum.explosion.ModularExplosion;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularExplosionDefinition {
    protected ExplosionArchetype archetype = ExplosionArchetype.COSMETIC;
    protected List<ExplosionModifier> modifiers;
    protected static String NBT_ROOT_KEY = "explosion_data";
    protected static String NBT_ARCHETYPE_KEY = "archetype";
    protected static String NBT_MODIFIER_LIST_KEY = "mods";

    public ModularExplosionDefinition() {
        this.modifiers = new ArrayList<ExplosionModifier>();
    }

    public ModularExplosionDefinition(ArrayList<ExplosionModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public void addModifier(ExplosionModifier modifier) {
        this.modifiers.add(modifier);
    }

    public void addModifiers(List<ExplosionModifier> modifiers) {
        this.modifiers.addAll(modifiers);
    }

    public void setArchetype(ExplosionArchetype archetype) {
        this.archetype = archetype;
    }

    public ExplosionArchetype getArchetype() {
        return this.archetype;
    }

    public boolean isValid(ModularExplosionProvider provider) {
        if (this.modifiers.size() > provider.getMaxExplosionModifiers()) {
            return false;
        }
        HashMap<ExplosionModifierType, Integer> occurrences = new HashMap<ExplosionModifierType, Integer>();
        for (ExplosionModifier modifier : this.modifiers) {
            if (!modifier.type.acceptsArchetype(this.archetype)) {
                return false;
            }
            ExplosionModifierType type = modifier.getType();
            int typeCount = occurrences.getOrDefault(type, 0);
            if (typeCount > type.getMaxModifiersForType()) {
                return false;
            }
            occurrences.put(type, typeCount + 1);
        }
        return true;
    }

    public int getModifierCount() {
        return this.modifiers.size();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582(NBT_ARCHETYPE_KEY, this.archetype.toString());
        class_2499 modifierList = new class_2499();
        for (ExplosionModifier modifier : this.modifiers) {
            modifierList.add((Object)class_2519.method_23256((String)modifier.getId().toString()));
        }
        nbt.method_10566(NBT_MODIFIER_LIST_KEY, (class_2520)modifierList);
        return nbt;
    }

    public static ModularExplosionDefinition fromNbt(class_2487 nbt) {
        ModularExplosionDefinition set = new ModularExplosionDefinition();
        if (nbt == null) {
            return set;
        }
        if (nbt.method_10573(NBT_ARCHETYPE_KEY, 8)) {
            set.archetype = ExplosionArchetype.tryParse(nbt.method_10558(NBT_ARCHETYPE_KEY));
        }
        class_2499 modifierList = nbt.method_10554(NBT_MODIFIER_LIST_KEY, 8);
        for (class_2520 e : modifierList) {
            ExplosionModifier mod = (ExplosionModifier)SpectrumRegistries.EXPLOSION_MODIFIERS.method_10223(class_2960.method_12829((String)e.method_10714()));
            if (mod == null) continue;
            set.modifiers.add(mod);
        }
        return set;
    }

    public static ModularExplosionDefinition getFromStack(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10573(NBT_ROOT_KEY, 10)) {
            return ModularExplosionDefinition.fromNbt(nbt.method_10562(NBT_ROOT_KEY));
        }
        return new ModularExplosionDefinition();
    }

    public void attachToStack(class_1799 stack) {
        stack.method_7959(NBT_ROOT_KEY, (class_2520)this.toNbt());
    }

    public static void removeFromStack(class_1799 stack) {
        stack.method_7983(NBT_ROOT_KEY);
    }

    public void appendTooltip(List<class_2561> tooltip, ModularExplosionProvider provider) {
        int modifierCount = this.modifiers.size();
        int maxModifierCount = provider.getMaxExplosionModifiers();
        tooltip.add(this.archetype.getName());
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.tooltip.explosives.remaining_slots", (Object[])new Object[]{modifierCount, maxModifierCount}).method_27692(class_124.field_1080));
        if (modifierCount == 0) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.tooltip.explosives.modifiers").method_27692(class_124.field_1080));
        } else {
            for (ExplosionModifier explosionModifier : this.modifiers) {
                tooltip.add(explosionModifier.getName());
            }
        }
    }

    public void explode(@NotNull class_3218 world, class_2338 pos, @Nullable class_1657 owner, double baseBlastRadius, float baseDamage) {
        ModularExplosion.explode(world, pos, owner, baseBlastRadius, baseDamage, this.archetype, this.modifiers);
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, @Nullable class_1657 owner, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ModularExplosionProvider) {
            ModularExplosionProvider provider = (ModularExplosionProvider)class_17922;
            ModularExplosionDefinition definition = ModularExplosionDefinition.getFromStack(stack);
            ModularExplosion.explode(world, pos, owner, provider.getBaseExplosionBlastRadius(), provider.getBaseExplosionDamage(), definition.archetype, definition.modifiers);
        }
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, class_2350 direction, @Nullable class_1657 owner, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ModularExplosionProvider) {
            ModularExplosionProvider provider = (ModularExplosionProvider)class_17922;
            ModularExplosionDefinition definition = ModularExplosionDefinition.getFromStack(stack);
            class_2338 finalPos = pos.method_10079(direction, (int)provider.getBaseExplosionBlastRadius() - 2);
            ModularExplosion.explode(world, finalPos, owner, provider.getBaseExplosionBlastRadius(), provider.getBaseExplosionDamage(), definition.archetype, definition.modifiers);
        }
    }
}

