/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.items.PigmentItem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ColorHelper {
    public static List<class_1767> VANILLA_DYE_COLORS = Arrays.stream(class_1767.values()).filter(dyeColor -> dyeColor.method_7789() < 16).toList();

    public static Vector3f getRGBVec(class_1767 dyeColor) {
        return InkColor.ofDyeColor(dyeColor).getColorVec();
    }

    public static int getInt(class_1767 dyeColor) {
        Vector3f vec = ColorHelper.getRGBVec(dyeColor);
        return new Color(vec.x(), vec.y(), vec.z()).getRGB() & 0xFFFFFF;
    }

    public static int getRandomColor(int seed) {
        return Color.getHSBColor((float)seed / 2.1474836E9f, 0.7f, 0.9f).getRGB();
    }

    @NotNull
    public static Vector3f colorIntToVec(int color) {
        Color colorObj = new Color(color);
        float[] argb = new float[4];
        colorObj.getColorComponents(argb);
        return new Vector3f(argb[0], argb[1], argb[2]);
    }

    public static int colorVecToRGB(Vector3f color) {
        Color colorObj = new Color(color.x, color.y, color.z);
        return colorObj.getRGB();
    }

    public static Optional<class_1767> getDyeColorOfItemStack(@NotNull class_1799 itemStack) {
        if (!itemStack.method_7960()) {
            class_1792 item = itemStack.method_7909();
            if (item instanceof class_1769) {
                class_1769 dyeItem = (class_1769)item;
                return Optional.of(dyeItem.method_7802());
            }
            if (item instanceof PigmentItem) {
                PigmentItem pigmentItem = (PigmentItem)item;
                return Optional.of(pigmentItem.getColor());
            }
        }
        return Optional.empty();
    }

    public static int interpolate(Vector3f start, Vector3f end, float delta) {
        int blendedRed = Math.round(class_3532.method_16439((float)delta, (float)start.x, (float)end.x) * 255.0f);
        int blendedGreen = Math.round(class_3532.method_16439((float)delta, (float)start.y, (float)end.y) * 255.0f);
        int blendedBlue = Math.round(class_3532.method_16439((float)delta, (float)start.z, (float)end.z) * 255.0f);
        return (blendedRed & 0xFF) << 16 | (blendedGreen & 0xFF) << 8 | blendedBlue & 0xFF | 0xFF000000;
    }
}

