/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.api.item.ExtendedEnchantable;
import de.dafuqs.spectrum.enchantments.SpectrumEnchantment;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1751;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class SpectrumEnchantmentHelper {
    public static class_3545<Boolean, class_1799> addOrUpgradeEnchantment(class_1799 stack, class_1887 enchantment, int level, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts) {
        String nbtString;
        class_2487 nbtCompound;
        if (!(enchantment.method_8192(stack) || stack.method_31574(class_1802.field_8598) || SpectrumEnchantmentHelper.isEnchantableBook(stack))) {
            return new class_3545((Object)false, (Object)stack);
        }
        if (!allowEnchantmentConflicts && SpectrumEnchantmentHelper.hasEnchantmentThatConflictsWith(stack, enchantment)) {
            return new class_3545((Object)false, (Object)stack);
        }
        if (!stack.method_31574(class_1802.field_8598)) {
            ExtendedEnchantable extendedEnchantable;
            class_1792 class_17922;
            if (SpectrumEnchantmentHelper.isEnchantableBook(stack)) {
                class_1799 enchantedBookStack = new class_1799((class_1935)class_1802.field_8598, stack.method_7947());
                enchantedBookStack.method_7980(stack.method_7969());
                stack = enchantedBookStack;
            } else if (!forceEvenIfNotApplicable && !enchantment.method_8192(stack) && (class_17922 = stack.method_7909()) instanceof ExtendedEnchantable && !(extendedEnchantable = (ExtendedEnchantable)class_17922).acceptsEnchantment(enchantment)) {
                return new class_3545((Object)false, (Object)stack);
            }
        }
        if (!(nbtCompound = stack.method_7948()).method_10573(nbtString = stack.method_31574(class_1802.field_8598) || stack.method_31574(SpectrumItems.ENCHANTMENT_CANVAS) ? "StoredEnchantments" : "Enchantments", 9)) {
            nbtCompound.method_10566(nbtString, (class_2520)new class_2499());
        }
        class_2960 enchantmentIdentifier = class_7923.field_41176.method_10221((Object)enchantment);
        class_2499 nbtList = nbtCompound.method_10554(nbtString, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            boolean isEqualOrDowngrade;
            class_2487 enchantmentCompound = nbtList.method_10602(i);
            if (!enchantmentCompound.method_10573("id", 8) || !class_2960.method_12829((String)enchantmentCompound.method_10558("id")).equals((Object)enchantmentIdentifier)) continue;
            boolean bl = isEqualOrDowngrade = enchantmentCompound.method_10573("lvl", 2) && enchantmentCompound.method_10550("lvl") >= level;
            if (isEqualOrDowngrade) {
                return new class_3545((Object)false, (Object)stack);
            }
            nbtList.method_10536(i);
            --i;
        }
        nbtList.add((Object)class_1890.method_37426((class_2960)class_1890.method_37423((class_1887)enchantment), (int)((byte)level)));
        nbtCompound.method_10566(nbtString, (class_2520)nbtList);
        stack.method_7980(nbtCompound);
        return new class_3545((Object)true, (Object)stack);
    }

    public static void setStoredEnchantments(Map<class_1887, Integer> enchantments, class_1799 stack) {
        stack.method_7983("StoredEnchantments");
        for (Map.Entry<class_1887, Integer> enchantmentIntegerEntry : enchantments.entrySet()) {
            class_1887 enchantment = enchantmentIntegerEntry.getKey();
            if (enchantment == null) continue;
            class_1772.method_7807((class_1799)stack, (class_1889)new class_1889(enchantment, enchantmentIntegerEntry.getValue().intValue()));
        }
    }

    public static class_1799 clearAndCombineEnchantments(class_1799 receiverStack, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts, class_1799 ... sourceStacks) {
        class_1890.method_8214(Map.of(), (class_1799)receiverStack);
        for (class_1799 stack : sourceStacks) {
            for (Map.Entry entry : class_1890.method_8222((class_1799)stack).entrySet()) {
                receiverStack = (class_1799)SpectrumEnchantmentHelper.addOrUpgradeEnchantment(receiverStack, (class_1887)entry.getKey(), (Integer)entry.getValue(), forceEvenIfNotApplicable, allowEnchantmentConflicts).method_15441();
            }
        }
        return receiverStack;
    }

    public static boolean isEnchantableBook(@NotNull class_1799 stack) {
        return stack.method_31573(SpectrumItemTags.ENCHANTABLE_BOOKS) || stack.method_7909() instanceof class_1751;
    }

    public static boolean hasEnchantmentThatConflictsWith(class_1799 itemStack, class_1887 enchantment) {
        Map existingEnchantments = class_1890.method_8222((class_1799)itemStack);
        for (class_1887 existingEnchantment : existingEnchantments.keySet()) {
            if (existingEnchantment.equals(enchantment) || existingEnchantment.method_8188(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static Map<class_1887, Integer> collectHighestEnchantments(List<class_1799> itemStacks) {
        LinkedHashMap<class_1887, Integer> enchantmentLevelMap = new LinkedHashMap<class_1887, Integer>();
        for (class_1799 itemStack : itemStacks) {
            Map itemStackEnchantments = class_1890.method_8222((class_1799)itemStack);
            for (class_1887 enchantment : itemStackEnchantments.keySet()) {
                int level = (Integer)itemStackEnchantments.get(enchantment);
                if (enchantmentLevelMap.containsKey(enchantment)) {
                    int storedLevel = (Integer)enchantmentLevelMap.get(enchantment);
                    if (level <= storedLevel) continue;
                    enchantmentLevelMap.put(enchantment, level);
                    continue;
                }
                enchantmentLevelMap.put(enchantment, level);
            }
        }
        return enchantmentLevelMap;
    }

    public static boolean canCombineAny(Map<class_1887, Integer> existingEnchantments, Map<class_1887, Integer> newEnchantments) {
        if (existingEnchantments.isEmpty()) {
            return true;
        }
        for (class_1887 existingEnchantment : existingEnchantments.keySet()) {
            for (class_1887 newEnchantment : newEnchantments.keySet()) {
                boolean canCurrentCombine = existingEnchantment.method_8188(newEnchantment);
                if (!canCurrentCombine) continue;
                return true;
            }
        }
        return false;
    }

    public static class_3545<class_1799, Integer> removeEnchantments(@NotNull class_1799 itemStack, class_1887 ... enchantments) {
        class_2487 compound = itemStack.method_7969();
        if (compound == null) {
            return new class_3545((Object)itemStack, (Object)0);
        }
        class_2499 enchantmentList = itemStack.method_31574(class_1802.field_8598) ? compound.method_10554("StoredEnchantments", 10) : compound.method_10554("Enchantments", 10);
        ArrayList<class_2960> enchantIDs = new ArrayList<class_2960>();
        for (class_1887 enchantment : enchantments) {
            enchantIDs.add(class_7923.field_41176.method_10221((Object)enchantment));
        }
        int removals = 0;
        for (int i = 0; i < enchantmentList.size(); ++i) {
            class_2960 currentID;
            class_2487 currentCompound = enchantmentList.method_10602(i);
            if (!currentCompound.method_10573("id", 8) || !enchantIDs.contains(currentID = new class_2960(currentCompound.method_10558("id")))) continue;
            enchantmentList.method_10536(i);
            ++removals;
            break;
        }
        if (itemStack.method_31574(class_1802.field_8598)) {
            if (enchantmentList.isEmpty()) {
                class_1799 newStack = new class_1799((class_1935)class_1802.field_8529);
                newStack.method_7939(itemStack.method_7947());
                return new class_3545((Object)newStack, (Object)removals);
            }
            compound.method_10566("StoredEnchantments", (class_2520)enchantmentList);
        } else {
            compound.method_10566("Enchantments", (class_2520)enchantmentList);
        }
        itemStack.method_7980(compound);
        return new class_3545((Object)itemStack, (Object)removals);
    }

    public static <T extends class_1792> class_1799 getMaxEnchantedStack(@NotNull T item) {
        class_1799 itemStack = item.method_7854();
        for (class_1887 enchantment : class_7923.field_41176.method_10220().toList()) {
            if (!((ExtendedEnchantable)item).acceptsEnchantment(enchantment)) continue;
            int maxLevel = enchantment.method_8183();
            itemStack = (class_1799)SpectrumEnchantmentHelper.addOrUpgradeEnchantment(itemStack, enchantment, maxLevel, true, true).method_15441();
        }
        return itemStack;
    }

    public static int getUsableLevel(SpectrumEnchantment enchantment, class_1799 itemStack, class_1297 entity) {
        int level = class_1890.method_8225((class_1887)enchantment, (class_1799)itemStack);
        if (level > 0 && !enchantment.canEntityUse(entity)) {
            level = 0;
        }
        return level;
    }
}

