/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.interaction.NaturesStaffTriggered;
import de.dafuqs.spectrum.api.item.ExtendedEnchantable;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.data_loaders.NaturesStaffConversionDataLoader;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.NaturesStaffUseSoundInstance;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1752;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2301;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2968;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5328;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class NaturesStaffItem
extends class_1792
implements ExtendedEnchantable,
InkPowered {
    public static final class_1799 ITEM_COST = new class_1799((class_1935)SpectrumItems.VEGETAL, 1);
    public static final InkCost INK_COST = new InkCost(InkColors.LIME, 20L);

    public NaturesStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(itemStack, world, tooltip, tooltipContext);
        int efficiencyLevel = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)itemStack);
        if (efficiencyLevel == 0) {
            if (InkPowered.canUseClient()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.natures_staff.tooltip_with_ink", (Object[])new Object[]{INK_COST.getColor().getColoredInkName()}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.natures_staff.tooltip"));
            }
        } else {
            int chancePercent = (int)(this.getInkCostMod(itemStack) * 100.0f);
            if (InkPowered.canUseClient()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.natures_staff.tooltip_with_ink_and_chance", (Object[])new Object[]{INK_COST.getColor().getColoredInkName(), chancePercent}));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.natures_staff.tooltip_with_chance", (Object[])new Object[]{chancePercent}));
            }
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.natures_staff.tooltip_lure"));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (NaturesStaffItem.canUse(user)) {
            if (world.field_9236) {
                this.startSoundInstance(user);
            }
            class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
        }
        return super.method_7836(world, user, hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void startSoundInstance(class_1657 user) {
        class_310.method_1551().method_1483().method_4873((class_1113)new NaturesStaffUseSoundInstance(user));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 20000;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (remainingUseTicks % 10 != 0) {
            return;
        }
        if (!(user instanceof class_1657)) {
            user.method_6075();
            return;
        }
        class_1657 player = (class_1657)user;
        if (!NaturesStaffItem.canUse(player)) {
            user.method_6075();
        }
        if (world.field_9236) {
            this.usageTickClient(user);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void usageTickClient(class_1309 user) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != user) {
            return;
        }
        if (client.field_1765.method_17783() == class_239.class_240.field_1332) {
            client.field_1761.method_2896(client.field_1724, client.field_1724.method_6058(), (class_3965)client.field_1765);
        }
    }

    public float getInkCostMod(class_1799 itemStack) {
        return 3.0f / (3.0f + (float)class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)itemStack));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 user = context.method_8036();
        if (user == null) {
            return class_1269.field_5814;
        }
        if (world.field_9236) {
            if (NaturesStaffItem.canUse(user)) {
                return class_1269.field_5811;
            }
            this.playDenySound(world, user);
            return class_1269.field_5814;
        }
        if (user.method_6048() < 2) {
            return class_1269.field_5811;
        }
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            class_1799 stack = context.method_8041();
            class_2338 blockPos = context.method_8037();
            if (!GenericClaimModsCompat.canInteract(world, blockPos, (class_1297)user)) {
                this.playDenySound(world, context.method_8036());
                return class_1269.field_5814;
            }
            if (user.method_6048() % 10 == 0) {
                NaturesStaffTriggered naturesStaffTriggered;
                NaturesStaffItem.spawnParticlesAndEffect(world, context.method_8037());
                boolean success = false;
                class_2680 sourceState = world.method_8320(blockPos);
                class_2248 class_22482 = sourceState.method_26204();
                if (class_22482 instanceof NaturesStaffTriggered && (naturesStaffTriggered = (NaturesStaffTriggered)class_22482).canUseNaturesStaff(world, blockPos, sourceState)) {
                    if (naturesStaffTriggered.onNaturesStaffUse(world, blockPos, sourceState, (class_1657)player)) {
                        success = true;
                    }
                } else {
                    class_2680 destinationState = NaturesStaffConversionDataLoader.getConvertedBlockState(sourceState.method_26204());
                    if (destinationState != null) {
                        if (destinationState.method_26204() instanceof class_3737) {
                            destinationState = NaturesStaffItem.touchesWater(world, blockPos) ? (class_2680)destinationState.method_11657((class_2769)class_2301.field_9940, (Comparable)Boolean.valueOf(true)) : (class_2680)destinationState.method_11657((class_2769)class_2301.field_9940, (Comparable)Boolean.valueOf(false));
                        }
                        world.method_8652(blockPos, destinationState, 3);
                        this.payForUse((class_1657)player, stack);
                        success = true;
                    } else if (sourceState.method_26164(SpectrumBlockTags.NATURES_STAFF_STACKABLE)) {
                        class_2680 state;
                        int i = 0;
                        do {
                            state = world.method_8320(context.method_8037().method_10086(i));
                            ++i;
                        } while (state.method_27852(sourceState.method_26204()));
                        class_2338 targetPos = context.method_8037().method_10086(i - 1);
                        if (this.tryPlaceBlock(sourceState, world, targetPos, class_2350.field_11033, class_2350.field_11036)) {
                            success = true;
                        }
                    } else if (sourceState.method_26164(SpectrumBlockTags.NATURES_STAFF_SPREADABLE)) {
                        class_5819 random = world.method_8409();
                        for (int i = 0; i < 5; ++i) {
                            class_2338 randomOffsetPos = blockPos.method_10069(random.method_39332(-3, 3), random.method_39332(-3, 3), random.method_39332(-3, 3));
                            if (!this.tryPlaceBlock(sourceState, world, randomOffsetPos, class_2350.method_10162((class_5819)random), class_2350.method_10162((class_5819)random))) continue;
                            success = true;
                            break;
                        }
                    } else if (sourceState.method_26229() && sourceState.method_26164(SpectrumBlockTags.NATURES_STAFF_TICKABLE)) {
                        if (world instanceof class_3218) {
                            sourceState.method_26199((class_3218)world, blockPos, world.field_9229);
                        }
                        success = true;
                    } else if (class_1752.method_7720((class_1799)class_1802.field_8324.method_7854(), (class_1937)world, (class_2338)blockPos)) {
                        success = true;
                    } else if (sourceState.method_26206((class_1922)world, blockPos, context.method_8038()) && class_1752.method_7719((class_1799)class_1802.field_8324.method_7854(), (class_1937)world, (class_2338)blockPos.method_10093(context.method_8038()), (class_2350)context.method_8038())) {
                        success = true;
                    }
                }
                if (success) {
                    this.payForUse((class_1657)player, stack);
                    SpectrumAdvancementCriteria.NATURES_STAFF_USE.trigger(player, sourceState, world.method_8320(blockPos));
                    return class_1269.field_21466;
                }
            }
        }
        return class_1269.field_5811;
    }

    private boolean tryPlaceBlock(class_2680 blockState, class_1937 world, class_2338 pos, class_2350 facing, class_2350 side) {
        class_2680 targetState = blockState.method_26204().method_9605((class_1750)new class_2968(world, pos, facing, class_1799.field_8037, side));
        if (targetState != null && world.method_8320(pos).method_45474() && !world.method_31601(pos.method_10264()) && targetState.method_26184((class_4538)world, pos)) {
            world.method_8501(pos, targetState);
            world.method_8444(null, 2001, pos, class_2248.method_9507((class_2680)targetState));
            world.method_8396(null, pos, targetState.method_26231().method_10598(), class_3419.field_15248, 1.0f, 0.9f + world.method_8409().method_43057() * 0.2f);
            world.method_20290(2005, pos, 0);
            return true;
        }
        return false;
    }

    private static boolean touchesWater(class_1937 world, class_2338 blockPos) {
        return world.method_8316(blockPos.method_10095()).method_15767(class_3486.field_15517) || world.method_8316(blockPos.method_10078()).method_15767(class_3486.field_15517) || world.method_8316(blockPos.method_10072()).method_15767(class_3486.field_15517) || world.method_8316(blockPos.method_10067()).method_15767(class_3486.field_15517);
    }

    private static void spawnParticlesAndEffect(class_1937 world, class_2338 blockPos) {
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26164(SpectrumBlockTags.NATURES_STAFF_STACKABLE)) {
            int i = 0;
            while (world.method_8320(blockPos.method_10086(i)).method_27852(blockState.method_26204())) {
                world.method_20290(2005, blockPos.method_10086(i), 0);
                ++i;
            }
            world.method_20290(2005, blockPos, 0);
            class_1752.method_7721((class_1936)world, (class_2338)blockPos.method_10086(i + 1), (int)5);
            int j = 1;
            while (world.method_8320(blockPos.method_10087(j)).method_27852(blockState.method_26204())) {
                world.method_20290(2005, blockPos.method_10087(j), 0);
                ++j;
            }
        } else {
            world.method_20290(2005, blockPos, 0);
        }
    }

    private boolean payForUse(class_1657 player, class_1799 stack) {
        boolean paid = player.method_7337();
        if (!paid) {
            paid = InkPowered.tryDrainEnergy(player, INK_COST, this.getInkCostMod(stack));
        }
        if (!paid && player.method_31548().method_7379(ITEM_COST)) {
            int efficiencyLevel = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)stack);
            paid = efficiencyLevel == 0 ? InventoryHelper.removeFromInventoryWithRemainders(player, ITEM_COST) : (double)player.method_6051().method_43057() > 2.0 / (double)(2 + efficiencyLevel) || InventoryHelper.removeFromInventoryWithRemainders(player, ITEM_COST);
        }
        return paid;
    }

    private static boolean canUse(class_1657 player) {
        return player.method_7337() || InkPowered.hasAvailableInk(player, INK_COST) || player.method_31548().method_7379(ITEM_COST);
    }

    private void playDenySound(@NotNull class_1937 world, @NotNull class_1657 playerEntity) {
        world.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 0.8f + playerEntity.method_6051().method_43057() * 0.4f);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(INK_COST.getColor());
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    @Override
    public boolean acceptsEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9131;
    }

    public int method_7837() {
        return 10;
    }
}

