/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import de.dafuqs.spectrum.api.item.ExtendedEnchantable;
import de.dafuqs.spectrum.api.item.MergeableItem;
import de.dafuqs.spectrum.api.item.SlotReservingItem;
import de.dafuqs.spectrum.api.item.SplitDamageItem;
import de.dafuqs.spectrum.api.item.TranstargetItem;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.entity.entity.DragonTalonEntity;
import de.dafuqs.spectrum.items.tools.MalachiteBidentItem;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class DragonTalonItem
extends MalachiteBidentItem
implements MergeableItem,
SlotReservingItem,
ExtendedEnchantable,
TranstargetItem,
SlotBackgroundEffectProvider {
    protected static final UUID REACH_MODIFIER_ID = UUID.fromString("3b9a13c8-a9a7-4545-8c32-e60baf25823e");
    private final Multimap<class_1320, class_1322> attributeModifiers;
    private final Multimap<class_1320, class_1322> phantomModifiers;

    public DragonTalonItem(class_1832 toolMaterial, double damage, double extraReach, class_1792.class_1793 settings) {
        super(settings, 0.0, 0.0, 0.0f, 0.0f);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", damage + (double)toolMaterial.method_8028(), class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", -2.0, class_1322.class_1323.field_6328));
        builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new class_1322(REACH_MODIFIER_ID, "Tool modifier", extraReach, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
        ImmutableMultimap.Builder phantom = ImmutableMultimap.builder();
        this.phantomModifiers = phantom.build();
    }

    @Override
    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || slot != class_1304.field_6173) {
            return super.method_7844(slot);
        }
        return this.isReservingSlot(stack) || nbt.method_10577("cooldown") ? this.phantomModifiers : this.attributeModifiers;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dragon_talon.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dragon_talon.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dragon_talon.tooltip3").method_27692(class_124.field_1080));
    }

    @Override
    public float getThrowSpeed(class_1799 stack) {
        return 3.5f;
    }

    @Override
    protected void throwBident(class_1799 stack, class_3218 world, class_1657 playerEntity) {
        DragonTalonEntity needleEntity = new DragonTalonEntity((class_1937)world);
        needleEntity.setStack(stack);
        needleEntity.method_7432((class_1297)playerEntity);
        needleEntity.method_30634(playerEntity.method_23317(), playerEntity.method_23320() - 0.1, playerEntity.method_23321());
        needleEntity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, this.getThrowSpeed(stack), 1.0f);
        needleEntity.field_6007 = true;
        needleEntity.field_6037 = true;
        needleEntity.field_7572 = class_1665.class_1666.field_7593;
        world.method_8649((class_1297)needleEntity);
        class_3414 soundEvent = class_3417.field_15001;
        world.method_43129(null, (class_1297)needleEntity, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
        class_2487 nbt = stack.method_7948();
        this.markReserved(stack, true);
        nbt.method_25927("lastNeedle", needleEntity.method_5667());
    }

    @Override
    public class_1799 getResult(class_3222 player, class_1799 firstHalf, class_1799 secondHalf) {
        int durability = Math.max(firstHalf.method_7919(), secondHalf.method_7919());
        class_1799 result = new class_1799((class_1935)SpectrumItems.DRACONIC_TWINSWORD);
        result.method_7980(firstHalf.method_7969());
        class_2487 nbt = result.method_7948();
        nbt.method_10551("pairSignature");
        nbt.method_10551("lastNeedle");
        nbt.method_10551("cooldown");
        nbt.method_10551("reserved");
        if (this.isReservingSlot(firstHalf) || this.isReservingSlot(secondHalf)) {
            durability += player.method_31549().field_7477 ? 0 : 500;
            player.method_7357().method_7906(result.method_7909(), 400);
        }
        result.method_7974(durability);
        return result;
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1268 hand = user.method_6058();
        if (hand == class_1268.field_5808) {
            return;
        }
        if (!this.isReservingSlot(stack)) {
            super.method_7840(user.method_5998(class_1268.field_5810), world, user, remainingUseTicks);
            return;
        }
        class_2487 nbt = stack.method_7948();
        if (world.method_8608() || !nbt.method_25928("lastNeedle")) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_1297 entity = serverWorld.method_14190(nbt.method_25926("lastNeedle"));
        if (entity instanceof DragonTalonEntity) {
            DragonTalonEntity needle = (DragonTalonEntity)entity;
            needle.recall();
        }
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) && !this.isReservingSlot(stack);
    }

    @Override
    public boolean canMerge(class_3222 player, class_1799 parent, class_1799 other) {
        if (player.method_7357().method_7904(parent.method_7909())) {
            return false;
        }
        return parent.method_7909() == other.method_7909() && this.verify(parent, other);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public void playSound(class_3222 player) {
        player.method_17356(SpectrumSoundEvents.METALLIC_UNSHEATHE, class_3419.field_15248, 0.5f, 0.8f + player.method_6051().method_43057() * 0.4f);
    }

    @Override
    public boolean isReservingSlot(class_1799 stack) {
        @Nullable class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        return nbt.method_10577("reserved");
    }

    @Override
    public void markReserved(class_1799 stack, boolean reserved) {
        stack.method_7948().method_10556("reserved", reserved);
    }

    public static class_1799 findThrownStack(class_1657 player, UUID id) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            class_2487 nbt = stack.method_7969();
            if (nbt == null || !nbt.method_25928("lastNeedle") || !nbt.method_25926("lastNeedle").equals(id)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2487 nbt = stack.method_7948();
            if (player.method_7357().method_7904(stack.method_7909())) {
                if (!nbt.method_10577("cooldown")) {
                    nbt.method_10556("cooldown", true);
                }
            } else if (nbt.method_10545("cooldown")) {
                nbt.method_10551("cooldown");
            }
        }
    }

    @Override
    public SplitDamageItem.DamageComposition getDamageComposition(class_1309 attacker, class_1309 target, class_1799 stack, float damage) {
        SplitDamageItem.DamageComposition composition = new SplitDamageItem.DamageComposition();
        composition.add(SpectrumDamageTypes.evisceration(attacker.method_37908(), (class_1297)attacker), damage);
        return composition;
    }

    @Override
    public boolean acceptsEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9117 || enchantment == class_1893.field_9132 || enchantment == SpectrumEnchantments.INERTIA;
    }

    @Override
    public Map<class_1887, Integer> getDefaultEnchantments() {
        return Map.of();
    }

    @Override
    public class_1886 getRealTarget() {
        return class_1886.field_9074;
    }

    @Override
    public float getDefenseMultiplier(class_1309 target, class_1799 stack) {
        return 1.0f;
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        return SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return -1184512;
    }

    @Override
    public void expandTooltip(class_1799 stack, @Nullable class_1657 player, List<class_2561> tooltip, class_1836 context) {
    }
}

