/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.api.status_effect.Incurable;
import de.dafuqs.spectrum.items.tools.LightGreatswordItem;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.SleepStatusEffect;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1890;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class NectarLanceItem
extends LightGreatswordItem
implements SlotBackgroundEffectProvider {
    public NectarLanceItem(class_1832 material, int attackDamage, float attackSpeed, float crit, float reach, int barColor, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, crit, reach, barColor, settings);
    }

    @Override
    public float getBlockingMultiplier(class_1282 source, class_1799 stack, class_1309 entity, int usedTime) {
        if (source.method_48789(class_8103.field_42247)) {
            return 0.0f;
        }
        if (this.canPerfectParry(stack, entity, usedTime)) {
            return 0.0f;
        }
        if (this.canBluffParry(stack, entity, usedTime)) {
            return 0.1f;
        }
        if ((float)usedTime <= (float)this.getMaxShieldingTime(entity, stack) / 2.0f) {
            return 0.25f;
        }
        return 0.6f;
    }

    @Override
    public float getLungeSpeed() {
        return 2.0f;
    }

    @Override
    public int method_7881(class_1799 stack) {
        return 30;
    }

    @Override
    protected void applyLungeHitEffects(class_1799 stack, class_1309 target, class_1309 attacker) {
        float base = (float)attacker.method_26825(class_5134.field_23721) + class_1890.method_8218((class_1799)stack, (class_1310)target.method_6046());
        if (target.method_6059(class_1294.field_5899)) {
            class_1293 effect = target.method_6112(class_1294.field_5899);
            if (target.method_6016(class_1294.field_5899)) {
                assert (effect != null);
                NectarLanceItem.applyDoTProc(attacker.method_48923().method_48831(), base + 5.0f, 0.8f, target, effect, false, true);
            }
        } else if (target.method_6059(SpectrumStatusEffects.DEADLY_POISON)) {
            class_1293 effect = target.method_6112(SpectrumStatusEffects.DEADLY_POISON);
            if (target.method_6016(SpectrumStatusEffects.DEADLY_POISON)) {
                assert (effect != null);
                NectarLanceItem.applyDoTProc(attacker.method_48923().method_48831(), base + 10.0f, 1.0f, target, effect, true, true);
            }
        } else if (target.method_6059(class_1294.field_5920)) {
            class_1293 effect = target.method_6112(class_1294.field_5920);
            if (target.method_6016(class_1294.field_5920)) {
                assert (effect != null);
                NectarLanceItem.applyDoTProc(attacker.method_48923().method_48831(), base + 5.0f, 0.1f, target, effect, true, false);
            }
        } else if (SpectrumStatusEffectTags.hasEffectWithTag(target, SpectrumStatusEffectTags.SOPORIFIC)) {
            float scaling = SleepStatusEffect.getSleepScaling(target);
            if (scaling > 0.0f) {
                target.method_5643(SpectrumDamageTypes.sleep(target.method_37908(), target), scaling);
                target.method_5783(SpectrumSoundEvents.LIGHT_CRYSTAL_RING, 0.275f, 0.8f + target.method_6051().method_43057() * 0.4f);
            }
        } else {
            Optional<class_1293> stolenEffect = target.method_6026().stream().filter(instance -> instance.method_5579().method_5573()).filter(instance -> !((Incurable)instance).spectrum$isIncurable()).findFirst();
            if (stolenEffect.isEmpty() || !target.method_6016(stolenEffect.get().method_5579())) {
                return;
            }
            class_1293 effect = stolenEffect.get();
            int duration = effect.method_5584();
            int amp = effect.method_5578();
            int takenDuration = (int)Math.ceil((double)duration / Math.log10(duration + 1));
            int takenAmp = 0;
            if (attacker.method_6059(effect.method_5579())) {
                takenAmp += attacker.method_6112(effect.method_5579()).method_5578();
            }
            attacker.method_6092(new class_1293(effect.method_5579(), takenDuration, takenAmp));
            if (amp > 0) {
                target.method_6092(new class_1293(effect.method_5579(), duration, amp - 1, effect.method_5591(), effect.method_5581(), effect.method_5592()));
            }
            target.method_5783(SpectrumSoundEvents.SOFT_HUM, 0.275f, 0.8f + target.method_6051().method_43057() * 0.4f);
        }
    }

    public static boolean sleepCrits(class_1657 player, class_1297 target) {
        if (!(target instanceof class_1309)) {
            return false;
        }
        class_1309 livingEntity = (class_1309)target;
        if (!player.method_6047().method_31574((class_1792)SpectrumItems.NECTAR_LANCE)) {
            return false;
        }
        if (livingEntity.method_6113()) {
            return true;
        }
        float scaling = SleepStatusEffect.getSleepScaling(livingEntity);
        return scaling > 0.0f && livingEntity.method_6051().method_43057() <= scaling / 3.0f;
    }

    private static void applyDoTProc(class_1282 type, float baseDamage, float damageScaling, class_1309 target, class_1293 effect, boolean canKill, boolean logScaling) {
        float scaling;
        float duration = (float)effect.method_5584() / 20.0f;
        int level = effect.method_5578() + 1;
        float damage = scaling = (float)level * damageScaling;
        if (logScaling) {
            damage = (float)(Math.log(duration) / Math.log(2.0) * (double)scaling);
        }
        damage += baseDamage;
        if (!canKill) {
            damage = Math.min(target.method_6032() - 1.0f, damage);
        }
        target.method_5643(type, damage);
        target.method_5783(SpectrumSoundEvents.DEEP_CRYSTAL_RING, 1.25f, 0.9f + target.method_6051().method_43057() * 0.2f);
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        return SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return -8377404;
    }
}

