/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.particle.effect.DynamicParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5150;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NightfallsBladeItem
extends class_1831
implements class_5150,
InkPoweredPotionFillable,
SlotBackgroundEffectProvider {
    private static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/equipment/nightfalls_blade");
    protected static final UUID REACH_MODIFIER_ID = UUID.fromString("8e2e05ef-a48a-4e2d-9633-388edcb21ea3");
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public NightfallsBladeItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, settings);
        float damage = (float)attackDamage + material.method_8028();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)damage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)attackSpeed, class_1322.class_1323.field_6328));
        builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new class_1322(REACH_MODIFIER_ID, "Weapon modifier", -1.5, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    @Override
    public int maxEffectCount() {
        return 1;
    }

    @Override
    public int maxEffectAmplifier() {
        return 2;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public long adjustFinalCostFor(@NotNull InkPoweredStatusEffectInstance instance) {
        boolean mod = SpectrumStatusEffects.isStrongSleepEffect(instance);
        return Math.round(Math.pow(instance.getInkCost().getCost(), 1.75 + (double)instance.getStatusEffectInstance().method_5578() + (double)mod));
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1657 player;
        if (target.method_5805() && attacker instanceof class_1657 && AdvancementHelper.hasAdvancement((class_1657)(player = (class_1657)attacker), (class_2960)UNLOCK_IDENTIFIER)) {
            List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
            for (InkPoweredStatusEffectInstance instance : effects) {
                if (!InkPowered.tryDrainEnergy(player, instance.getInkCost().getColor(), instance.getInkCost().getCost())) continue;
                class_1937 world = attacker.method_37908();
                if (world.field_9236) {
                    world.method_8406((class_2394)new DynamicParticleEffect((class_2396<?>)class_2398.field_11245, 0.1f, ColorHelper.colorIntToVec(instance.getStatusEffectInstance().method_5579().method_5556()), 0.5f, 120, true, true), target.method_23322(0.5), target.method_23323(0.5), target.method_23325(0.5), (double)world.field_9229.method_43057() - 0.5, (double)world.field_9229.method_43057() - 0.5, (double)world.field_9229.method_43057() - 0.5);
                    continue;
                }
                target.method_37222(instance.getStatusEffectInstance(), (class_1297)attacker);
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || !class_1844.method_8068((class_1799)stack).isEmpty();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        this.appendPotionFillableTooltip(stack, tooltip, class_2561.method_43471((String)"item.spectrum.nightfalls_blade.when_struck"), true);
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        if (InkPoweredPotionFillable.getEffects(stack).isEmpty()) {
            return SlotBackgroundEffectProvider.SlotEffect.NONE;
        }
        InkPoweredStatusEffectInstance effect = InkPoweredPotionFillable.getEffects(stack).get(0);
        boolean usable = InkPowered.hasAvailableInk(player, new InkCost(effect.getInkCost().getColor(), this.adjustFinalCostFor(effect)));
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.BORDER;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return 0;
        }
        return effects.get(0).getColor();
    }

    @Override
    public float getEffectOpacity(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return 0.0f;
        }
        InkPoweredStatusEffectInstance effect = effects.get(0);
        if (InkPowered.hasAvailableInk(player, new InkCost(effect.getInkCost().getColor(), this.adjustFinalCostFor(effect)))) {
            return 1.0f;
        }
        if (player == null) {
            return 0.0f;
        }
        long time = player.method_37908().method_8510();
        return (float)(Math.sin(((float)time + tickDelta) / 30.0f) * (double)0.3f + 0.3);
    }
}

