/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.loot.SpectrumLootFunctionTypes;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_120;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_7923;

public class FillPotionFillableLootCondition
extends class_120 {
    final InkPoweredPotionTemplate template;

    FillPotionFillableLootCondition(class_5341[] conditions, InkPoweredPotionTemplate template) {
        super(conditions);
        this.template = template;
    }

    public class_5339 method_29321() {
        return SpectrumLootFunctionTypes.FILL_POTION_FILLABLE;
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        if (this.template == null) {
            return stack;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof InkPoweredPotionFillable)) {
            return stack;
        }
        InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)class_17922;
        if (inkPoweredPotionFillable.isFull(stack)) {
            return stack;
        }
        InkPoweredStatusEffectInstance effect = this.template.get(context);
        inkPoweredPotionFillable.addOrUpgradeEffects(stack, List.of(effect));
        return stack;
    }

    public static class_120.class_121<?> builder(InkPoweredPotionTemplate template) {
        return FillPotionFillableLootCondition.method_520(conditions -> new FillPotionFillableLootCondition((class_5341[])conditions, template));
    }

    record InkPoweredPotionTemplate(boolean ambient, boolean showParticles, class_5658 duration, List<class_1291> statusEffects, int color, class_5658 amplifier, List<InkColor> inkColors, class_5658 inkCost, boolean unidentifiable, boolean incurable) {
        public static InkPoweredPotionTemplate fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            boolean ambient = class_3518.method_15258((JsonObject)jsonObject, (String)"ambient", (boolean)false);
            boolean showParticles = class_3518.method_15258((JsonObject)jsonObject, (String)"show_particles", (boolean)false);
            boolean unidentifiable = class_3518.method_15258((JsonObject)jsonObject, (String)"unidentifiable", (boolean)false);
            boolean incurable = class_3518.method_15258((JsonObject)jsonObject, (String)"incurable", (boolean)false);
            class_5658 duration = (class_5658)class_3518.method_15272((JsonObject)jsonObject, (String)"duration", (JsonDeserializationContext)jsonDeserializationContext, class_5658.class);
            HashSet<class_1291> statusEffects = new HashSet<class_1291>();
            JsonElement statusEffectElement = jsonObject.get("status_effect");
            if (statusEffectElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)statusEffectElement;
                for (JsonElement element : jsonArray) {
                    statusEffects.add((class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)element.getAsString())));
                }
            } else {
                statusEffects.add((class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)statusEffectElement.getAsString())));
            }
            int color = class_3518.method_15282((JsonObject)jsonObject, (String)"color", (int)-1);
            class_5658 amplifier = (class_5658)class_3518.method_15272((JsonObject)jsonObject, (String)"amplifier", (JsonDeserializationContext)jsonDeserializationContext, class_5658.class);
            class_5658 inkCost = (class_5658)class_3518.method_15272((JsonObject)jsonObject, (String)"ink_cost", (JsonDeserializationContext)jsonDeserializationContext, class_5658.class);
            HashSet<InkColor> inkColors = new HashSet<InkColor>();
            JsonElement colorElement = jsonObject.get("ink_color");
            if (colorElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)colorElement;
                for (JsonElement element : jsonArray) {
                    String s = element.getAsString();
                    inkColors.add(InkColor.ofIdString(s).orElseThrow());
                }
            } else {
                String s = colorElement.getAsString();
                inkColors.add(InkColor.ofIdString(s).orElseThrow());
            }
            return new InkPoweredPotionTemplate(ambient, showParticles, duration, statusEffects.stream().toList(), color, amplifier, inkColors.stream().toList(), inkCost, unidentifiable, incurable);
        }

        public void toJson(JsonObject jsonObject, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("ambient", Boolean.valueOf(this.ambient));
            jsonObject.addProperty("show_particles", Boolean.valueOf(this.showParticles));
            jsonObject.add("duration", jsonSerializationContext.serialize((Object)this.duration));
            JsonArray statusEffectArray = new JsonArray();
            for (class_1291 statusEffect : this.statusEffects) {
                statusEffectArray.add(class_7923.field_41174.method_10221((Object)statusEffect).toString());
            }
            jsonObject.add("status_effect", (JsonElement)statusEffectArray);
            jsonObject.addProperty("color", (Number)this.color);
            jsonObject.addProperty("unidentifiable", Boolean.valueOf(this.unidentifiable));
            jsonObject.addProperty("incurable", Boolean.valueOf(this.incurable));
            jsonObject.add("amplifier", jsonSerializationContext.serialize((Object)this.amplifier));
            jsonObject.add("ink_cost", jsonSerializationContext.serialize((Object)this.inkCost));
            JsonArray inkColorArray = new JsonArray();
            for (InkColor inkColor : this.inkColors) {
                inkColorArray.add(inkColor.getID().toString());
            }
            jsonObject.add("ink_color", (JsonElement)inkColorArray);
        }

        public InkPoweredStatusEffectInstance get(class_47 context) {
            class_1291 statusEffect = this.statusEffects.get(context.method_294().method_43048(this.statusEffects.size()));
            class_1293 statusEffectInstance = new class_1293(statusEffect, this.duration.method_366(context), this.amplifier.method_366(context), this.ambient, this.showParticles, true);
            InkColor inkColor = this.inkColors.get(context.method_294().method_43048(this.inkColors.size()));
            int cost = this.inkCost.method_366(context);
            return new InkPoweredStatusEffectInstance(statusEffectInstance, new InkCost(inkColor, cost), this.color, this.unidentifiable, this.incurable);
        }
    }

    public static class Serializer
    extends class_120.class_123<FillPotionFillableLootCondition> {
        public void toJson(JsonObject jsonObject, FillPotionFillableLootCondition lootFunction, JsonSerializationContext jsonSerializationContext) {
            super.method_529(jsonObject, (class_120)lootFunction, jsonSerializationContext);
            lootFunction.template.toJson(jsonObject, jsonSerializationContext);
        }

        public FillPotionFillableLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, class_5341[] lootConditions) {
            return new FillPotionFillableLootCondition(lootConditions, InkPoweredPotionTemplate.fromJson(jsonObject, jsonDeserializationContext));
        }
    }
}

