/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import de.dafuqs.spectrum.helpers.NbtHelper;
import de.dafuqs.spectrum.loot.SpectrumLootFunctionTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;

public class MergeNbtRandomlyLootFunction
extends class_120 {
    final List<class_2487> nbts;

    MergeNbtRandomlyLootFunction(class_5341[] conditions, Collection<class_2487> nbts) {
        super(conditions);
        this.nbts = ImmutableList.copyOf(nbts);
    }

    public class_5339 method_29321() {
        return SpectrumLootFunctionTypes.SET_NBT_RANDOMLY;
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        if (this.nbts.isEmpty()) {
            return stack;
        }
        class_2487 compound = this.nbts.get(context.method_294().method_43048(this.nbts.size()));
        stack.method_7948().method_10543(compound);
        return stack;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class_120.class_121<?> builder() {
        return MergeNbtRandomlyLootFunction.method_520(conditions -> new MergeNbtRandomlyLootFunction((class_5341[])conditions, (Collection<class_2487>)ImmutableList.of()));
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final Set<class_2487> nbts = Sets.newHashSet();

        protected Builder getThisBuilder() {
            return this;
        }

        public Builder add(class_2487 nbt) {
            this.nbts.add(nbt);
            return this;
        }

        public class_117 method_515() {
            return new MergeNbtRandomlyLootFunction(this.method_526(), this.nbts);
        }
    }

    public static class Serializer
    extends class_120.class_123<MergeNbtRandomlyLootFunction> {
        public void toJson(JsonObject jsonObject, MergeNbtRandomlyLootFunction lootFunction, JsonSerializationContext jsonSerializationContext) {
            super.method_529(jsonObject, (class_120)lootFunction, jsonSerializationContext);
            if (!lootFunction.nbts.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (class_2487 nbt : lootFunction.nbts) {
                    jsonArray.add((JsonElement)new JsonPrimitive(nbt.toString()));
                }
                jsonObject.add("tags", (JsonElement)jsonArray);
            }
        }

        public MergeNbtRandomlyLootFunction fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, class_5341[] lootConditions) {
            ArrayList nbts = Lists.newArrayList();
            if (jsonObject.has("tags")) {
                JsonArray jsonArray = class_3518.method_15261((JsonObject)jsonObject, (String)"tags");
                for (JsonElement jsonElement : jsonArray) {
                    Optional<class_2487> nbt = NbtHelper.getNbtCompound(jsonElement);
                    if (!nbt.isPresent()) continue;
                    nbts.add(nbt.get());
                }
            }
            return new MergeNbtRandomlyLootFunction(lootConditions, nbts);
        }
    }
}

