/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.damage_type.StackTracking;
import de.dafuqs.spectrum.api.energy.storage.FixedSingleInkStorage;
import de.dafuqs.spectrum.api.entity.TouchingWaterAware;
import de.dafuqs.spectrum.api.item.ApplyFoodEffectsCallback;
import de.dafuqs.spectrum.api.item.ArmorPiercingItem;
import de.dafuqs.spectrum.api.item.ArmorWithHitEffect;
import de.dafuqs.spectrum.api.item.SplitDamageItem;
import de.dafuqs.spectrum.api.status_effect.Incurable;
import de.dafuqs.spectrum.api.status_effect.StackableStatusEffect;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.cca.EverpromiseRibbonComponent;
import de.dafuqs.spectrum.cca.MiscPlayerDataComponent;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeProvider;
import de.dafuqs.spectrum.enchantments.DisarmingEnchantment;
import de.dafuqs.spectrum.enchantments.InexorableEnchantment;
import de.dafuqs.spectrum.helpers.ParticleHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.items.tools.DragonTalonItem;
import de.dafuqs.spectrum.items.tools.LightGreatswordItem;
import de.dafuqs.spectrum.items.tools.ParryingSwordItem;
import de.dafuqs.spectrum.items.trinkets.AetherGracedNectarGlovesItem;
import de.dafuqs.spectrum.items.trinkets.RingOfAerialGraceItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.mixin.accessors.StatusEffectInstanceAccessor;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.registries.SpectrumDamageTypeTags;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import de.dafuqs.spectrum.registries.SpectrumEntityTypeTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.EffectProlongingStatusEffect;
import de.dafuqs.spectrum.status_effects.ImmunityStatusEffect;
import de.dafuqs.spectrum.status_effects.SleepStatusEffect;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalEntityTypeTags;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2783;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4050;
import net.minecraft.class_4081;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected class_1657 field_6258;
    @Shadow
    protected class_1799 field_6277;

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_1291 var1);

    @Shadow
    public abstract boolean method_6049(class_1293 var1);

    @Shadow
    public abstract void method_5749(class_2487 var1);

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract boolean method_6016(class_1291 var1);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @Shadow
    public abstract class_1799 method_6079();

    @Shadow
    public abstract int method_6096();

    @Shadow
    public abstract double method_26825(class_1320 var1);

    @Shadow
    public abstract void method_5650(class_1297.class_5529 var1);

    @Shadow
    public abstract void method_6091(class_243 var1);

    @Shadow
    @Nullable
    protected abstract class_3414 method_6002();

    @Shadow
    protected abstract float method_6107();

    @Inject(method={"createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void spectrum$addAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(SpectrumEntityAttributes.MENTAL_PRESENCE);
    }

    @ModifyArg(method={"dropXp()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    protected int spectrum$applyExuberance(int originalXP) {
        return (int)((float)originalXP * this.spectrum$getExuberanceMod(this.field_6258));
    }

    @Unique
    private float spectrum$getExuberanceMod(class_1657 attackingPlayer) {
        if (attackingPlayer != null && SpectrumEnchantments.EXUBERANCE.canEntityUse((class_1297)attackingPlayer)) {
            int exuberanceLevel = class_1890.method_8203((class_1887)SpectrumEnchantments.EXUBERANCE, (class_1309)attackingPlayer);
            return 1.0f + (float)exuberanceLevel * SpectrumCommon.CONFIG.ExuberanceBonusExperiencePercentPerLevel;
        }
        return 1.0f;
    }

    @ModifyVariable(method={"travel"}, at=@At(value="STORE"), ordinal=0)
    private boolean spectrum$noSlowFallingSlowdown(boolean b) {
        if (!b) {
            return false;
        }
        return !InexorableEnchantment.isArmorActive((class_1309)this);
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasNoDrag()Z")})
    private void spectrum$travel(CallbackInfo ci, @Local(ordinal=1) LocalFloatRef f) {
        Optional<class_1799> optionalTrinket;
        DragonTalonItem talon = SpectrumItems.DRAGON_TALON;
        class_1309 entity = (class_1309)this;
        boolean override = false;
        float friction = -1.0f;
        if ((talon.isReservingSlot(this.method_6047()) || talon.isReservingSlot(this.method_6079())) && !entity.method_24828()) {
            friction = 0.945f;
            override = true;
        }
        if (!entity.method_24828() && (optionalTrinket = SpectrumTrinketItem.getFirstEquipped((class_1309)this, (class_1792)SpectrumItems.RING_OF_AERIAL_GRACE)).isPresent()) {
            FixedSingleInkStorage inkStorage = SpectrumItems.RING_OF_AERIAL_GRACE.getEnergyStorage(optionalTrinket.get());
            long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
            friction = (float)Math.max((double)friction, 0.91 + ((RingOfAerialGraceItem)SpectrumItems.RING_OF_AERIAL_GRACE).getBonus(storedInk) / 150.0);
            override = true;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (override) {
                friction += MiscPlayerDataComponent.get(player).getFrictionModifiers();
            } else {
                f.set(Math.min(f.get() + MiscPlayerDataComponent.get(player).getFrictionModifiers(), 0.99f));
            }
        }
        if (friction >= 0.0f) {
            f.set(Math.min(friction, 0.99f));
        }
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;getSlipperiness()F")})
    private float spectrum$increaseSlipperiness(float original) {
        class_1309 entity = (class_1309)this;
        class_5819 random = entity.method_6051();
        float potency = SleepStatusEffect.getSleepScaling(entity);
        if (potency != -1.0f) {
            potency *= 2.0f;
            if (entity instanceof class_1657 && (double)random.method_43057() < (double)potency * 0.05) {
                return 0.35f + random.method_43057() * 0.45f;
            }
            original = (float)Math.min((double)original + 0.3 + (double)(potency / 25.0f), (double)0.9975f);
        }
        return original;
    }

    @ModifyReturnValue(method={"canWalkOnFluid"}, at={@At(value="RETURN")})
    private boolean spectrum$modifyFluidWalking(boolean original) {
        class_1309 entity = (class_1309)this;
        if (SpectrumTrinketItem.hasEquipped((class_1309)this, (class_1792)SpectrumItems.RING_OF_AERIAL_GRACE)) {
            return !entity.method_5869();
        }
        return original;
    }

    @ModifyExpressionValue(method={"isBlocking"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/Item;getMaxUseTime(Lnet/minecraft/item/ItemStack;)I")})
    private int spectrum$allowInstantBlockForParryingSwords(int original) {
        if (this.field_6277.method_7909() instanceof ParryingSwordItem) {
            return Integer.MAX_VALUE;
        }
        return original;
    }

    @WrapOperation(method={"handleStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;playSound(Lnet/minecraft/sound/SoundEvent;FF)V", ordinal=2)})
    private void spectrum$swapBlockSound(class_1309 instance, class_3414 soundEvent, float v, float p, Operation<Void> original) {
        class_1792 class_17922 = instance.method_6030().method_7909();
        if (!(class_17922 instanceof ParryingSwordItem)) {
            original.call(new Object[]{instance, soundEvent, Float.valueOf(v), Float.valueOf(p)});
            return;
        }
        ParryingSwordItem parryingSword = (ParryingSwordItem)class_17922;
        if (instance.method_6048() <= parryingSword.getPerfectParryWindow(instance, instance.method_6030())) {
            original.call(new Object[]{instance, SpectrumSoundEvents.PERFECT_PARRY, Float.valueOf(1.75f), Float.valueOf(0.9f + instance.method_37908().field_9229.method_43057() * 0.3f)});
            original.call(new Object[]{instance, SpectrumSoundEvents.SWORD_BLOCK, Float.valueOf(0.667f), Float.valueOf(0.5f + instance.method_37908().field_9229.method_43057() * 0.3f)});
        } else {
            original.call(new Object[]{instance, SpectrumSoundEvents.SWORD_BLOCK, Float.valueOf(1.0f), Float.valueOf(0.8f + instance.method_37908().field_9229.method_43057() * 0.4f)});
        }
    }

    @Inject(method={"applyFoodEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/Item;getFoodComponent()Lnet/minecraft/item/FoodComponent;")})
    private void spectrum$applyConcealedEffects(class_1799 stack, class_1937 world, class_1309 targetEntity, CallbackInfo ci) {
        if (!world.method_8608() && stack.method_7985() && stack.method_7969().method_10545("ConcealedOilEffect")) {
            class_2487 nbt = stack.method_7969().method_10562("ConcealedOilEffect");
            class_1293 instance = class_1293.method_5583((class_2487)nbt);
            targetEntity.method_6092(instance);
        }
    }

    @ModifyReturnValue(method={"canHaveStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;)Z"}, at={@At(value="RETURN")})
    private boolean spectrum$canHaveStatusEffect(boolean original, @Local(argsOnly=true) class_1293 statusEffectInstance) {
        class_1309 instance = (class_1309)this;
        if (original && this.method_6059(SpectrumStatusEffects.FATAL_SLUMBER) && statusEffectInstance.method_5579() == SpectrumStatusEffects.IMMUNITY) {
            ImmunityStatusEffect.removeNegativeStatusEffects(instance);
            this.method_6092(new class_1293(SpectrumStatusEffects.ETERNAL_SLUMBER, 6000));
            return false;
        }
        if (original && this.method_6059(SpectrumStatusEffects.ETERNAL_SLUMBER) && statusEffectInstance.method_5579() == SpectrumStatusEffects.IMMUNITY) {
            ImmunityStatusEffect.removeNegativeStatusEffects(instance);
            ((StatusEffectInstanceAccessor)statusEffectInstance).setDuration(Math.max(0, statusEffectInstance.method_5584() - 600));
            if (!instance.method_37908().method_8608()) {
                ((class_3218)instance.method_37908()).method_14178().method_18751((class_1297)instance, (class_2596)new class_2783(instance.method_5628(), statusEffectInstance));
            }
            return true;
        }
        if (original && this.method_6059(SpectrumStatusEffects.IMMUNITY) && statusEffectInstance.method_5579().method_18792() == class_4081.field_18272 && !SpectrumStatusEffectTags.bypassesImmunity(statusEffectInstance.method_5579())) {
            if (Incurable.isIncurable(statusEffectInstance) || statusEffectInstance.method_5579() == SpectrumStatusEffects.ETERNAL_SLUMBER) {
                class_1293 immunity = this.method_6112(SpectrumStatusEffects.IMMUNITY);
                int cost = 600 * (statusEffectInstance.method_5578() + 1);
                int immDuration = immunity.method_5584();
                if (immDuration >= cost) {
                    ((StatusEffectInstanceAccessor)immunity).setDuration(immDuration - cost);
                    if (!instance.method_37908().method_8608()) {
                        ((class_3218)instance.method_37908()).method_14178().method_18751((class_1297)instance, (class_2596)new class_2783(instance.method_5628(), immunity));
                    }
                    return false;
                }
                this.method_6016(SpectrumStatusEffects.IMMUNITY);
                return false;
            }
            if (statusEffectInstance.method_5579() == SpectrumStatusEffects.FATAL_SLUMBER) {
                this.method_6016(SpectrumStatusEffects.IMMUNITY);
                this.method_6092(new class_1293(SpectrumStatusEffects.ETERNAL_SLUMBER, 6000));
                return false;
            }
            return false;
        }
        return original;
    }

    @ModifyReturnValue(method={"disablesShield"}, at={@At(value="RETURN")})
    private boolean spectrum$lungeBreaksShields(boolean original) {
        class_1657 player;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && MiscPlayerDataComponent.get(player = (class_1657)class_13092).isLunging()) {
            return player.method_6047().method_7909() instanceof LightGreatswordItem;
        }
        return original;
    }

    @ModifyExpressionValue(method={"damage"}, at={@At(value="CONSTANT", args={"floatValue=0F"}, ordinal=2)})
    private float spectrum$parryingSwordShielding(float original, @Local(argsOnly=true) class_1282 source, @Local(ordinal=2) float shieldedDamage) {
        class_1309 entity = (class_1309)this;
        class_1799 activeStack = entity.method_6030();
        int useTime = entity.method_6048();
        class_1792 class_17922 = activeStack.method_7909();
        if (!(class_17922 instanceof ParryingSwordItem)) {
            return original;
        }
        ParryingSwordItem parryingSword = (ParryingSwordItem)class_17922;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (parryingSword.canBluffParry(activeStack, entity, useTime)) {
                MiscPlayerDataComponent comp = MiscPlayerDataComponent.get(player);
                comp.setParryTicks(15);
                if (parryingSword.canPerfectParry(activeStack, entity, useTime)) {
                    comp.markForPerfectCounter();
                }
            }
        }
        return shieldedDamage * parryingSword.getBlockingMultiplier(source, activeStack, entity, useTime);
    }

    @ModifyExpressionValue(method={"blockedByShield"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/projectile/PersistentProjectileEntity;getPierceLevel()B")})
    private byte spectrum$parryPiercingProjectiles(byte original) {
        class_1309 entity = (class_1309)this;
        class_1799 activeStack = entity.method_6030();
        class_1792 class_17922 = activeStack.method_7909();
        if (class_17922 instanceof ParryingSwordItem) {
            ParryingSwordItem parryingSword = (ParryingSwordItem)class_17922;
            return parryingSword.canBluffParry(activeStack, entity, entity.method_6048()) ? (byte)0 : original;
        }
        return original;
    }

    @ModifyExpressionValue(method={"blockedByShield"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageSource;isIn(Lnet/minecraft/registry/tag/TagKey;)Z")})
    private boolean spectrum$parryShieldUnblockables(boolean original, class_1282 source) {
        class_1309 entity = (class_1309)this;
        class_1799 activeStack = entity.method_6030();
        class_1792 class_17922 = activeStack.method_7909();
        if (!(class_17922 instanceof ParryingSwordItem)) {
            return original;
        }
        ParryingSwordItem parryingSword = (ParryingSwordItem)class_17922;
        return source.method_48789(SpectrumDamageTypeTags.BYPASSES_PARRYING) || !parryingSword.canDeflect(source, parryingSword.canPerfectParry(activeStack, entity, entity.method_6048()));
    }

    @ModifyVariable(method={"damageArmor(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float spectrum$damageArmor(float amount, class_1282 source) {
        if (source.method_48789(SpectrumDamageTypeTags.DOES_NOT_DAMAGE_ARMOR)) {
            return 0.0f;
        }
        if (source.method_48789(SpectrumDamageTypeTags.INCREASED_ARMOR_DAMAGE)) {
            return amount * 10.0f;
        }
        return amount;
    }

    @ModifyArg(method={"modifyAppliedDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getInflictedDamage(FF)F"), index=1)
    private float spectrum$modifyAppliedDamage(float protection, @Local(argsOnly=true) class_1282 source) {
        Optional<class_3545<ArmorPiercingItem, class_1799>> pair = this.getArmorPiercing(source);
        if (pair.isPresent()) {
            ArmorPiercingItem ap = (ArmorPiercingItem)pair.get().method_15442();
            class_1799 stack = (class_1799)pair.get().method_15441();
            float modProt = Math.max(protection, 20.0f) / 25.0f;
            protection = Math.max(modProt - ap.getProtReduction((class_1309)this, stack), 0.0f) * 20.0f;
        }
        return protection;
    }

    @ModifyVariable(method={"applyArmorToDamage"}, at=@At(value="STORE"), ordinal=0, argsOnly=true)
    private float spectrum$applyArmorToDamage(float amount, class_1282 source) {
        float defense = this.method_6096();
        float toughness = this.getToughness();
        boolean modified = false;
        Optional<class_3545<ArmorPiercingItem, class_1799>> pair = this.getArmorPiercing(source);
        if (pair.isPresent()) {
            ArmorPiercingItem ap = (ArmorPiercingItem)pair.get().method_15442();
            class_1799 stack = (class_1799)pair.get().method_15441();
            defense *= ap.getDefenseMultiplier((class_1309)this, stack);
            toughness *= ap.getToughnessMultiplier((class_1309)this, stack);
            modified = true;
        }
        if (source.method_48789(SpectrumDamageTypeTags.CALCULATES_DAMAGE_BASED_ON_TOUGHNESS)) {
            amount = class_1280.method_5496((float)amount, (float)(toughness * 1.334f), (float)Float.MAX_VALUE);
        } else if (source.method_48789(SpectrumDamageTypeTags.PARTLY_IGNORES_PROTECTION)) {
            amount = class_1280.method_5496((float)amount, (float)(defense / 2.0f), (float)toughness);
        }
        if (modified) {
            amount = class_1280.method_5496((float)amount, (float)defense, (float)toughness);
        }
        return amount;
    }

    @Unique
    private Optional<class_3545<ArmorPiercingItem, class_1799>> getArmorPiercing(class_1282 source) {
        if (!(source instanceof StackTracking)) {
            return Optional.empty();
        }
        StackTracking stackTracking = (StackTracking)source;
        Optional<class_1799> stackOptional = stackTracking.spectrum$getTrackedStack();
        if (stackOptional.isEmpty()) {
            return Optional.empty();
        }
        class_1799 stack = stackOptional.get();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof ArmorPiercingItem)) {
            return Optional.empty();
        }
        ArmorPiercingItem ap = (ArmorPiercingItem)class_17922;
        return Optional.of(new class_3545((Object)ap, (Object)stack));
    }

    @Unique
    private float getToughness() {
        return (float)this.method_26825(class_5134.field_23725);
    }

    @ModifyExpressionValue(method={"handleFallDamage(FFLnet/minecraft/entity/damage/DamageSource;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;computeFallDamage(FF)I")})
    private int spectrum$puffCircletDamageNegation(int original) {
        class_1309 thisEntity = (class_1309)this;
        float cost = Math.min((float)original, 2.0f);
        if (original <= 0 || thisEntity.method_5679(thisEntity.method_48923().method_48827()) || AzureDikeProvider.getAzureDikeCharges(thisEntity) <= cost) {
            return original;
        }
        Optional component = TrinketsApi.getTrinketComponent((class_1309)thisEntity);
        if (component.isEmpty() || ((TrinketComponent)component.get()).getEquipped(SpectrumItems.PUFF_CIRCLET).isEmpty()) {
            return original;
        }
        AzureDikeProvider.absorbDamage(thisEntity, cost);
        class_243 velocity = thisEntity.method_18798();
        thisEntity.method_18800(velocity.method_10216(), 0.5, velocity.method_10215());
        class_1937 world = thisEntity.method_37908();
        if (world.field_9236) {
            ParticleHelper.playParticleWithPatternAndVelocityClient(thisEntity.method_37908(), thisEntity.method_19538(), (class_2394)SpectrumParticleTypes.WHITE_CRAFTING, VectorPattern.EIGHT, 0.4);
            ParticleHelper.playParticleWithPatternAndVelocityClient(thisEntity.method_37908(), thisEntity.method_19538(), (class_2394)SpectrumParticleTypes.BLUE_CRAFTING, VectorPattern.EIGHT_OFFSET, 0.5);
        } else if (thisEntity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)thisEntity;
            SpectrumS2CPacketSender.playParticleWithPatternAndVelocity((class_1657)serverPlayerEntity, (class_3218)thisEntity.method_37908(), thisEntity.method_19538(), (class_2394)SpectrumParticleTypes.WHITE_CRAFTING, VectorPattern.EIGHT, 0.4);
            SpectrumS2CPacketSender.playParticleWithPatternAndVelocity((class_1657)serverPlayerEntity, (class_3218)thisEntity.method_37908(), thisEntity.method_19538(), (class_2394)SpectrumParticleTypes.BLUE_CRAFTING, VectorPattern.EIGHT_OFFSET, 0.5);
        }
        thisEntity.method_37908().method_8396(null, thisEntity.method_24515(), SpectrumSoundEvents.PUFF_CIRCLET_PFFT, class_3419.field_15248, 1.0f, 1.0f);
        return 0;
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, argsOnly=true)
    private float spectrum$modifyDamage(float amount, class_1282 source) {
        @Nullable class_1293 vulnerability = this.method_6112(SpectrumStatusEffects.VULNERABILITY);
        if (vulnerability != null) {
            amount *= 1.0f + 0.25f * (float)vulnerability.method_5578();
        }
        return amount;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageSource;isIn(Lnet/minecraft/registry/tag/TagKey;)Z", ordinal=1)}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    private void spectrum$allowPartialBlocks(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)this;
        class_1799 activeItem = entity.method_6030();
        if (!(activeItem.method_7909() instanceof ParryingSwordItem)) {
            return;
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V", ordinal=0)}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    private void spectrum$applyDike1(class_1309 instance, class_1282 source, float amount, Operation<Void> original) {
        if (source.method_48789(SpectrumDamageTypeTags.BYPASSES_DIKE)) {
            original.call(new Object[]{instance, source, Float.valueOf(amount)});
            return;
        }
        instance.method_6074(source, AzureDikeProvider.absorbDamage(instance, amount));
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V", ordinal=1)}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    private void spectrum$applyDike2(class_1309 instance, class_1282 source, float amount, Operation<Void> original) {
        if (source.method_48789(SpectrumDamageTypeTags.BYPASSES_DIKE)) {
            original.call(new Object[]{instance, source, Float.valueOf(amount)});
            return;
        }
        instance.method_6074(source, AzureDikeProvider.absorbDamage(instance, amount));
    }

    @Inject(method={"tickStatusEffects"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;remove()V")})
    private void spectrum$fatalSlumberKill(CallbackInfo ci, @Local class_1293 effectInstance) {
        block8: {
            class_3222 serverPlayerEntity;
            class_1309 entity;
            block10: {
                block9: {
                    if (effectInstance.method_5579() != SpectrumStatusEffects.FATAL_SLUMBER) break block8;
                    entity = (class_1309)this;
                    if (entity.method_37908().method_8608()) {
                        return;
                    }
                    if (entity.method_7325()) break block9;
                    if (!(entity instanceof class_1657)) break block10;
                    class_1657 player = (class_1657)entity;
                    if (!player.method_31549().field_7477) break block10;
                }
                return;
            }
            float damage = Float.MAX_VALUE;
            if (SleepStatusEffect.isImmuneish(entity)) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    damage = entity.method_6032() * 0.95f;
                } else {
                    damage = entity.method_6063() * 0.3f;
                }
            }
            entity.method_5643(SpectrumDamageTypes.sleep(entity.method_37908(), null), damage);
            if (entity.method_5805() && entity instanceof class_3222 && !(serverPlayerEntity = (class_3222)entity).method_7337()) {
                Support.grantAdvancementCriterion(serverPlayerEntity, "lategame/survive_fatal_slumber", "survived_fatal_slumber");
            }
        }
    }

    @ModifyReturnValue(method={"isSleeping"}, at={@At(value="RETURN")})
    private boolean spectrum$forceSleepingState(boolean original) {
        if (original) {
            return true;
        }
        if (this.method_6059(SpectrumStatusEffects.ETERNAL_SLUMBER) || this.method_6059(SpectrumStatusEffects.FATAL_SLUMBER)) {
            return !((class_1309)this instanceof class_1657);
        }
        return false;
    }

    @Inject(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void spectrum$modifyOrCancelEffects(class_1293 effect, class_1297 source, CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)this;
        class_1291 effectType = effect.method_5579();
        if ((!entity.method_6059(SpectrumStatusEffects.IMMUNITY) || SpectrumStatusEffectTags.bypassesImmunity(effectType)) && AetherGracedNectarGlovesItem.testEffectFor(entity, effectType)) {
            int cost = (effect.method_5578() + 1) * 7;
            if (Incurable.isIncurable(effect)) {
                cost *= 3;
            }
            if (AetherGracedNectarGlovesItem.tryBlockEffect(entity, cost)) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
        float resistanceModifier = class_3532.method_15363((float)SleepStatusEffect.getSleepResistance(effect, entity), (float)0.1f, (float)10.0f);
        if (effectType == SpectrumStatusEffects.ETERNAL_SLUMBER) {
            if (SleepStatusEffect.isImmuneish(entity)) {
                ((StatusEffectInstanceAccessor)effect).setDuration(Math.round((float)effect.method_5584() / resistanceModifier));
            } else if (!entity.method_5864().method_20210(SpectrumEntityTypeTags.SLEEP_RESISTANT)) {
                ((StatusEffectInstanceAccessor)effect).setDuration(-1);
            }
        } else if (effectType == SpectrumStatusEffects.FATAL_SLUMBER) {
            if (SleepStatusEffect.isImmuneish(entity) && entity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) {
                ((StatusEffectInstanceAccessor)effect).setDuration(1200);
            } else {
                ((StatusEffectInstanceAccessor)effect).setDuration(Math.max(Math.round((float)effect.method_5584() * resistanceModifier * 3.0f), 200));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    private void spectrum$applyDisarmingEnchantment(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        int disarmingLevel;
        class_1309 livingSource;
        class_1297 class_12972;
        if (amount > 0.0f && cir.getReturnValue() != null && ((Boolean)cir.getReturnValue()).booleanValue() && !source.method_49708(class_8111.field_42330) && (class_12972 = source.method_5529()) instanceof class_1309 && SpectrumEnchantments.DISARMING.canEntityUse((class_1297)(livingSource = (class_1309)class_12972)) && (disarmingLevel = class_1890.method_8225((class_1887)SpectrumEnchantments.DISARMING, (class_1799)livingSource.method_6047())) > 0 && Math.random() < (double)((float)disarmingLevel * SpectrumCommon.CONFIG.DisarmingChancePerLevelMobs)) {
            DisarmingEnchantment.disarmEntity((class_1309)this);
        }
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void spectrum$applyBonusDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingSource;
        class_1799 mainHandStack;
        class_1792 class_17922;
        class_1297 deathSound2;
        class_1309 target = (class_1309)this;
        if (amount > 0.0f && source.method_48789(SpectrumDamageTypeTags.USES_SET_HEALTH)) {
            class_3414 deathSound2;
            float h = target.method_6032();
            target.method_6033(h - amount);
            target.method_6066().method_5547(source, amount);
            if (target.method_29504() && !target.method_41328(class_4050.field_18082) && (deathSound2 = this.method_6002()) != null) {
                target.method_5783(deathSound2, this.method_6107(), target.method_6017());
            }
            cir.setReturnValue((Object)true);
            return;
        }
        if (!SpectrumDamageTypes.recursiveDamageFlag && amount > 0.0f && (deathSound2 = source.method_5526()) instanceof class_1309 && (class_17922 = (mainHandStack = (livingSource = (class_1309)deathSound2).method_6047()).method_7909()) instanceof SplitDamageItem) {
            SplitDamageItem splitDamageItem = (SplitDamageItem)class_17922;
            SpectrumDamageTypes.recursiveDamageFlag = true;
            SplitDamageItem.DamageComposition composition = splitDamageItem.getDamageComposition(livingSource, target, mainHandStack, amount);
            boolean damaged = false;
            for (class_3545<class_1282, Float> entry : composition.get()) {
                int invincibilityFrameStore = target.field_6008;
                damaged |= this.method_5643((class_1282)entry.method_15442(), ((Float)entry.method_15441()).floatValue());
                target.field_6008 = invincibilityFrameStore;
            }
            SpectrumDamageTypes.recursiveDamageFlag = false;
            cir.setReturnValue((Object)damaged);
        }
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isDead()Z", ordinal=1)})
    private void spectrum$TriggerArmorWithHitEffect(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        block2: {
            class_1309 thisEntity;
            block3: {
                thisEntity = (class_1309)this;
                class_1937 world = thisEntity.method_37908();
                if (world.field_9236) break block2;
                if (!(thisEntity instanceof class_1308)) break block3;
                class_1308 thisMobEntity = (class_1308)thisEntity;
                for (class_1799 armorItemStack : thisMobEntity.method_5661()) {
                    class_1792 class_17922 = armorItemStack.method_7909();
                    if (!(class_17922 instanceof ArmorWithHitEffect)) continue;
                    ArmorWithHitEffect armorWithHitEffect = (ArmorWithHitEffect)class_17922;
                    armorWithHitEffect.onHit(armorItemStack, source, (class_1309)thisMobEntity, amount);
                }
                break block2;
            }
            if (!(thisEntity instanceof class_3222)) break block2;
            class_3222 thisPlayerEntity = (class_3222)thisEntity;
            for (class_1799 armorItemStack : thisPlayerEntity.method_5661()) {
                class_1792 class_17923 = armorItemStack.method_7909();
                if (!(class_17923 instanceof ArmorWithHitEffect)) continue;
                ArmorWithHitEffect armorWithHitEffect = (ArmorWithHitEffect)class_17923;
                armorWithHitEffect.onHit(armorItemStack, source, (class_1309)thisPlayerEntity, amount);
            }
        }
    }

    @ModifyVariable(method={"setSprinting(Z)V"}, at=@At(value="HEAD"), argsOnly=true)
    private boolean spectrum$setSprinting(boolean sprinting) {
        if (sprinting && ((class_1309)this).method_6059(SpectrumStatusEffects.SCARRED)) {
            return false;
        }
        return sprinting;
    }

    @Inject(at={@At(value="TAIL")}, method={"applyFoodEffects(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V"})
    private void spectrum$eat(class_1799 stack, class_1937 world, class_1309 targetEntity, CallbackInfo ci) {
        class_1792 item = stack.method_7909();
        if (item instanceof ApplyFoodEffectsCallback) {
            ApplyFoodEffectsCallback foodWithCallback = (ApplyFoodEffectsCallback)item;
            foodWithCallback.afterConsumption(world, stack, (class_1309)this);
        }
    }

    @Inject(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")}, cancellable=true)
    private void spectrum$addStatusEffect(class_1293 effect, class_1297 source, CallbackInfoReturnable<Boolean> cir) {
        class_1293 effectProlongingInstance;
        class_1291 effectType = effect.method_5579();
        if (effectType instanceof StackableStatusEffect) {
            if (!SpectrumStatusEffects.effectsAreGettingStacked) {
                if (this.method_6049(effect)) {
                    class_1293 existingInstance = this.method_6112(effect.method_5579());
                    if (existingInstance != null) {
                        SpectrumStatusEffects.effectsAreGettingStacked = true;
                        int newAmplifier = 1 + existingInstance.method_5578() + effect.method_5578();
                        class_1293 newInstance = new class_1293(existingInstance.method_5579(), existingInstance.method_5584(), newAmplifier, existingInstance.method_5591(), existingInstance.method_5581(), existingInstance.method_5592());
                        this.method_6016(existingInstance.method_5579());
                        this.method_6092(newInstance);
                        cir.cancel();
                    }
                } else {
                    SpectrumStatusEffects.effectsAreGettingStacked = false;
                }
            } else {
                SpectrumStatusEffects.effectsAreGettingStacked = false;
            }
        } else if (EffectProlongingStatusEffect.canBeExtended(effectType) && (effectProlongingInstance = this.method_6112(SpectrumStatusEffects.EFFECT_PROLONGING)) != null) {
            ((StatusEffectInstanceAccessor)effect).setDuration(EffectProlongingStatusEffect.getExtendedDuration(effect.method_5584(), effectProlongingInstance.method_5578()));
        }
    }

    @Inject(method={"drop(Lnet/minecraft/entity/damage/DamageSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void drop(class_1282 source, CallbackInfo ci) {
        class_1309 thisEntity = (class_1309)this;
        if (EverpromiseRibbonComponent.hasRibbon(thisEntity)) {
            class_1799 memoryStack = MemoryItem.getMemoryForEntity(thisEntity);
            MemoryItem.setTicksToManifest(memoryStack, 20);
            MemoryItem.setSpawnAsAdult(memoryStack, true);
            MemoryItem.markAsBrokenPromise(memoryStack, true);
            class_243 entityPos = thisEntity.method_19538();
            class_1542 itemEntity = new class_1542(thisEntity.method_37908(), entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), memoryStack);
            thisEntity.method_37908().method_8649((class_1297)itemEntity);
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    protected void applyInexorableEffects(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity.method_37908() != null && entity.method_37908().method_8510() % 20L == 0L) {
            InexorableEnchantment.checkAndRemoveSlowdownModifiers(entity);
        }
    }

    @Redirect(method={"tickMovement()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isWet()Z"))
    private boolean spectrum$isWet(class_1309 livingEntity) {
        return livingEntity.method_5799() ? ((TouchingWaterAware)livingEntity).spectrum$isActuallyTouchingWater() : livingEntity.method_5637();
    }

    @WrapWithCondition(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tiltScreen(DD)V")})
    private boolean shouldTiltScreen(class_1309 entity, double deltaX, double deltaZ, class_1282 source, float amount) {
        return !source.method_48789(SpectrumDamageTypeTags.USES_SET_HEALTH);
    }
}

