/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.spectrum.api.entity.PlayerEntityAccessor;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.cca.LastKillComponent;
import de.dafuqs.spectrum.cca.MiscPlayerDataComponent;
import de.dafuqs.spectrum.enchantments.ImprovedCriticalEnchantment;
import de.dafuqs.spectrum.entity.entity.SpectrumFishingBobberEntity;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.tools.LightGreatswordItem;
import de.dafuqs.spectrum.items.tools.NectarLanceItem;
import de.dafuqs.spectrum.items.trinkets.AttackRingItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumDamageTypeTags;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.FrenzyStatusEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityAccessor {
    @Shadow
    private int field_7487;
    public SpectrumFishingBobberEntity spectrum$fishingBobber;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract Iterable<class_1799> method_5877();

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Inject(method={"updateSwimming()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void spectrum$updateSwimming(CallbackInfo ci) {
        if (SpectrumTrinketItem.hasEquipped(this, (class_1792)SpectrumItems.RING_OF_DENSER_STEPS)) {
            this.method_5796(false);
            ci.cancel();
        }
    }

    @Inject(method={"onKilledOther"}, at={@At(value="HEAD")})
    private void spectrum$rememberKillOther(class_3218 world, class_1309 other, CallbackInfoReturnable<Boolean> cir) {
        class_1657 entity = (class_1657)this;
        LastKillComponent.rememberKillTick((class_1309)entity, entity.method_37908().method_8510());
        class_1293 frenzy = entity.method_6112(SpectrumStatusEffects.FRENZY);
        if (frenzy != null) {
            ((FrenzyStatusEffect)frenzy.method_5579()).onKill((class_1309)entity, frenzy.method_5578());
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z")})
    private void spectrum$stopSleep(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (amount > 0.0f) {
            class_1657 entity = (class_1657)this;
            MiscPlayerDataComponent.get(entity).notifyHit();
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttributeValue(Lnet/minecraft/entity/attribute/EntityAttribute;)D")})
    protected void spectrum$calculateModifiers(class_1297 target, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        Multimap map = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        class_1322 jeopardantModifier = SpectrumTrinketItem.hasEquipped((class_1309)player, SpectrumItems.JEOPARDANT) ? new class_1322(AttackRingItem.ATTACK_RING_DAMAGE_UUID, "spectrum:jeopardant", AttackRingItem.getAttackModifierForEntity((class_1309)player), class_1322.class_1323.field_6331) : new class_1322(AttackRingItem.ATTACK_RING_DAMAGE_UUID, "spectrum:jeopardant", 0.0, class_1322.class_1323.field_6331);
        map.put((Object)class_5134.field_23721, (Object)jeopardantModifier);
        if (SpectrumEnchantments.IMPROVED_CRITICAL.canEntityUse((class_1297)player)) {
            int improvedCriticalLevel = SpectrumEnchantmentHelper.getUsableLevel(SpectrumEnchantments.IMPROVED_CRITICAL, player.method_6047(), (class_1297)player);
            class_1322 improvedCriticalModifier = new class_1322(ImprovedCriticalEnchantment.EXTRA_CRIT_DAMAGE_MULTIPLIER_ATTRIBUTE_UUID, "spectrum:improved_critical", (double)ImprovedCriticalEnchantment.getAddtionalCritDamageMultiplier(improvedCriticalLevel), class_1322.class_1323.field_6328);
            map.put((Object)AdditionalEntityAttributes.CRITICAL_BONUS_DAMAGE, (Object)improvedCriticalModifier);
        }
        player.method_6127().method_26854(map);
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getNonSpectatingEntities(Ljava/lang/Class;Lnet/minecraft/util/math/Box;)Ljava/util/List;")})
    protected List<class_1309> spectrum$increaseSweepRadius(List<class_1309> original, class_1297 target) {
        class_1799 stack = this.method_5998(class_1268.field_5808);
        if (stack.method_7909() == SpectrumItems.DRACONIC_TWINSWORD) {
            int channeling = this.getChanneling(stack) + 1;
            double size = (double)(channeling * 2) + 0.5;
            List entities = this.method_37908().method_18467(class_1309.class, target.method_5829().method_1009(size, 0.4 * (double)channeling, size));
            if (!this.method_37908().method_8608() && channeling - 1 > 0) {
                for (class_1309 living : entities) {
                    if (!living.method_33190()) continue;
                    for (int i = 0; i < 5; ++i) {
                        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11208, living.method_23322(1.25), living.method_23318() + (double)(living.method_17682() * this.field_5974.method_43057()), living.method_23325(1.25), this.field_5974.method_43048(2), 0.0, (double)(this.field_5974.method_43057() / 6.0f), 0.0, 0.0);
                    }
                }
            }
            return entities;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), index=8, require=1)
    private boolean spectrum$binglebongle(boolean value, class_1297 target) {
        if (this.hasForcedCrits(target)) {
            return true;
        }
        return value;
    }

    @Inject(method={"attack(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;getFireAspect(Lnet/minecraft/entity/LivingEntity;)I")})
    private void spectrum$perfectCounter(class_1297 target, CallbackInfo ci, @Local(ordinal=0) LocalFloatRef damage) {
        class_1657 player = (class_1657)this;
        if (MiscPlayerDataComponent.get(player).consumePerfectCounter()) {
            damage.set(damage.get() * 1.5f);
        }
    }

    @Unique
    protected boolean hasForcedCrits(class_1297 target) {
        class_1657 player = (class_1657)this;
        MiscPlayerDataComponent component = MiscPlayerDataComponent.get(player);
        if (NectarLanceItem.sleepCrits(player, target)) {
            return true;
        }
        if (component.isParrying()) {
            component.setParryTicks(0);
            return true;
        }
        return component.isLunging();
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FF)V", ordinal=2)})
    protected void spectrum$switchCritSound(class_1937 instance, class_1657 except, double x, double y, double z, class_3414 sound, class_3419 category, float volume, float pitch, Operation<Void> original) {
        class_1657 player = (class_1657)this;
        class_1799 stack = this.method_5998(class_1268.field_5808);
        MiscPlayerDataComponent component = MiscPlayerDataComponent.get(player);
        if (stack.method_7909() instanceof LightGreatswordItem && component.isLunging()) {
            original.call(new Object[]{instance, except, x, y, z, SpectrumSoundEvents.LUNGE_CRIT, category, Float.valueOf(1.0f), Float.valueOf(1.0f + this.field_5974.method_43057() * 0.2f)});
            return;
        }
        original.call(new Object[]{instance, except, x, y, z, sound, category, Float.valueOf(volume), Float.valueOf(pitch)});
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FF)V", ordinal=1)})
    protected void spectrum$switchSweepSound(class_1937 instance, class_1657 except, double x, double y, double z, class_3414 sound, class_3419 category, float volume, float pitch, Operation<Void> original) {
        class_1799 stack = this.method_5998(class_1268.field_5808);
        if (stack.method_7909() == SpectrumItems.DRACONIC_TWINSWORD && this.getChanneling(stack) > 0) {
            this.method_37908().method_43128(except, x, y, z, SpectrumSoundEvents.ELECTRIC_DISCHARGE, category, 0.75f, 0.9f + this.field_5974.method_43057() * 0.2f);
            return;
        }
        original.call(new Object[]{instance, except, x, y, z, sound, category, Float.valueOf(volume), Float.valueOf(pitch)});
    }

    @Unique
    protected int getChanneling(class_1799 stack) {
        return class_1890.method_8225((class_1887)class_1893.field_9117, (class_1799)stack);
    }

    @Inject(at={@At(value="TAIL")}, method={"jump()V"})
    protected void spectrum$jumpAdvancementCriterion(CallbackInfo ci) {
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)playerEntityMixin;
            SpectrumAdvancementCriteria.TAKE_OFF_BELT_JUMP.trigger(serverPlayerEntity);
        }
    }

    @ModifyVariable(method={"damageArmor(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float spectrum$damageArmor(float amount, class_1282 source) {
        if (source.method_48789(SpectrumDamageTypeTags.DOES_NOT_DAMAGE_ARMOR)) {
            return 0.0f;
        }
        if (source.method_48789(SpectrumDamageTypeTags.INCREASED_ARMOR_DAMAGE)) {
            return amount * 10.0f;
        }
        return amount;
    }

    @Override
    public void setSpectrumBobber(SpectrumFishingBobberEntity bobber) {
        this.spectrum$fishingBobber = bobber;
    }

    @Override
    public void setSleepTimer(int ticks) {
        this.field_7487 = ticks;
    }

    @Override
    public SpectrumFishingBobberEntity getSpectrumBobber() {
        return this.spectrum$fishingBobber;
    }

    @Inject(at={@At(value="HEAD")}, method={"canFoodHeal()Z"}, cancellable=true)
    public void canFoodHeal(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        if (player.method_6059(SpectrumStatusEffects.SCARRED)) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addExperience(I)V"}, argsOnly=true)
    public int addExperience(int experience) {
        if (experience < 0) {
            return experience;
        }
        class_1657 player = (class_1657)this;
        for (class_1799 stack : this.method_5877()) {
            if (player.method_6115() || !(stack.method_7909() instanceof ExperienceStorageItem)) continue;
            experience = ExperienceStorageItem.addStoredExperience(stack, experience);
            player.field_7504 = 0;
            if (experience != 0) continue;
            break;
        }
        return experience;
    }

    @ModifyVariable(method={"getBlockBreakingSpeed"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z"), to=@At(value="TAIL")), at=@At(value="LOAD"), ordinal=1)
    public float applyInexorableEffects(float value) {
        if (this.isInexorableActive()) {
            return 1.0f;
        }
        return value;
    }

    @ModifyReturnValue(method={"getBlockBreakingSpeed"}, at={@At(value="RETURN")})
    public float applyInexorableAntiSlowdowns(float original) {
        if (this.isInexorableActive()) {
            class_1657 player = (class_1657)this;
            float f = original;
            if (player.method_5777(class_3486.field_15517) && !class_1890.method_8200((class_1309)player)) {
                f *= 5.0f;
            }
            if (!player.method_24828()) {
                f *= 5.0f;
            }
            return f;
        }
        return original;
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="HEAD")})
    public void spectrum$applyWakeUpEffects(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (!player.method_37908().method_8608()) {
            MiscPlayerDataComponent.get(player).resetSleepingState(true);
        }
    }

    @WrapOperation(method={"updatePose"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setPose(Lnet/minecraft/entity/EntityPose;)V")})
    public void spectrum$forceSwimmingState(class_1657 instance, class_4050 entityPose, Operation<Void> original) {
        MiscPlayerDataComponent component = MiscPlayerDataComponent.get(instance);
        if ((component.shouldLieDown() || instance.method_6059(SpectrumStatusEffects.FATAL_SLUMBER)) && this.method_20233(class_4050.field_18079)) {
            instance.method_18380(class_4050.field_18079);
            return;
        }
        original.call(new Object[]{instance, entityPose});
    }

    @Unique
    private boolean isInexorableActive() {
        class_1657 player = (class_1657)this;
        return SpectrumEnchantments.INEXORABLE.canEntityUse((class_1297)player) && class_1890.method_8225((class_1887)SpectrumEnchantments.INEXORABLE, (class_1799)player.method_5998(player.method_6058())) > 0;
    }
}

