/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import org.jetbrains.annotations.Nullable;

public class ColorPredicate {
    public static final ColorPredicate ANY = new ColorPredicate(null);
    @Nullable
    private final InkColor color;

    public ColorPredicate(@Nullable InkColor color) {
        this.color = color;
    }

    public static ColorPredicate fromJson(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull() && json instanceof JsonPrimitive) {
            InkColor color = InkColor.ofIdString(json.getAsString()).orElseThrow();
            return new ColorPredicate(color);
        }
        return ANY;
    }

    public boolean test(InkColor color) {
        if (this == ANY || color == null) {
            return true;
        }
        return this.color == color;
    }

    public JsonElement toJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.color != null) {
            jsonObject.addProperty("color", this.color.getID().toString());
        }
        return jsonObject;
    }

    public static class Builder {
        @Nullable
        private InkColor color = null;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder color(InkColor color) {
            this.color = color;
            return this;
        }

        public ColorPredicate build() {
            return new ColorPredicate(this.color);
        }
    }
}

