/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.fusion_shrine;

import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.predicate.world.WorldConditionPredicate;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineRecipe
extends GatedStackSpectrumRecipe<FusionShrineBlockEntity> {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("build_fusion_shrine");
    protected final List<IngredientStack> craftingInputs;
    protected final FluidIngredient fluid;
    protected final class_1799 output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean yieldUpgradesDisabled;
    protected final boolean playCraftingFinishedEffects;
    protected final List<WorldConditionPredicate> worldConditions;
    @NotNull
    protected final FusionShrineRecipeWorldEffect startWorldEffect;
    @NotNull
    protected final List<FusionShrineRecipeWorldEffect> duringWorldEffects;
    @NotNull
    protected final FusionShrineRecipeWorldEffect finishWorldEffect;
    @Nullable
    protected final class_2561 description;
    protected final boolean copyNbt;

    public FusionShrineRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, List<IngredientStack> craftingInputs, FluidIngredient fluid, class_1799 output, float experience, int craftingTime, boolean yieldUpgradesDisabled, boolean playCraftingFinishedEffects, boolean copyNbt, List<WorldConditionPredicate> worldConditions, @NotNull FusionShrineRecipeWorldEffect startWorldEffect, @NotNull List<FusionShrineRecipeWorldEffect> duringWorldEffects, @NotNull FusionShrineRecipeWorldEffect finishWorldEffect, @Nullable class_2561 description) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.craftingInputs = craftingInputs;
        this.fluid = fluid;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.yieldUpgradesDisabled = yieldUpgradesDisabled;
        this.playCraftingFinishedEffects = playCraftingFinishedEffects;
        this.worldConditions = worldConditions;
        this.startWorldEffect = startWorldEffect;
        this.duringWorldEffects = duringWorldEffects;
        this.finishWorldEffect = finishWorldEffect;
        this.description = description;
        this.copyNbt = copyNbt;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean matches(FusionShrineBlockEntity inv, class_1937 world) {
        SingleVariantStorage<FluidVariant> fluidStorage = inv.getFluidStorage();
        if (!this.fluid.test((FluidVariant)fluidStorage.variant)) {
            return false;
        }
        if (this.fluid != FluidIngredient.EMPTY && fluidStorage.getAmount() != fluidStorage.getCapacity()) {
            return false;
        }
        return this.matchIngredientStacksExclusively(inv, this.getIngredientStacks());
    }

    public class_1799 craft(FusionShrineBlockEntity inv, class_5455 drm) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return this.craftingInputs.size() <= width * height;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.FUSION_SHRINE_BASALT);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.FUSION_SHRINE_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.FUSION_SHRINE;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.craftingInputs;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean areConditionMetCurrently(class_3218 world, class_2338 pos) {
        for (WorldConditionPredicate worldCondition : this.worldConditions) {
            if (worldCondition.test(world, pos)) continue;
            return false;
        }
        return true;
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public FusionShrineRecipeWorldEffect getWorldEffectForTick(int tick, int totalTicks) {
        if (tick == 1) {
            return this.startWorldEffect;
        }
        if (tick == totalTicks) {
            return this.finishWorldEffect;
        }
        if (this.duringWorldEffects.isEmpty()) {
            return null;
        }
        if (this.duringWorldEffects.size() == 1) {
            return this.duringWorldEffects.get(0);
        }
        float parts = (float)totalTicks / (float)this.duringWorldEffects.size();
        int index = (int)((float)tick / parts);
        FusionShrineRecipeWorldEffect effect = this.duringWorldEffects.get(index);
        if (effect.isOneTimeEffect() && index != (int)parts) {
            return null;
        }
        return effect;
    }

    public Optional<class_2561> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return Optional.of(this.description);
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "fusion_shrine";
    }

    public void craft(class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        class_1799 firstStack = class_1799.field_8037;
        int maxAmount = 1;
        class_1799 output = this.craft(fusionShrineBlockEntity, world.method_30349());
        if (!output.method_7960()) {
            maxAmount = output.method_7914();
            block0: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    if (firstStack.method_7960()) {
                        firstStack = currentStack;
                    }
                    int ingredientStackAmount = ingredientStack.getCount();
                    maxAmount = Math.min(maxAmount, currentStack.method_7947() / ingredientStackAmount);
                    continue block0;
                }
            }
            if (maxAmount > 0) {
                double efficiencyModifier = fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                this.decrementIngredients(world, fusionShrineBlockEntity, maxAmount, efficiencyModifier);
            }
        } else {
            block2: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                double efficiencyModifier = fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    int reducedAmountAfterMod = Support.getIntFromDecimalWithChance((double)ingredientStack.getCount() / efficiencyModifier, world.field_9229);
                    currentStack.method_7934(reducedAmountAfterMod);
                    continue block2;
                }
            }
        }
        if (this.copyNbt) {
            output = FusionShrineRecipe.copyNbt(firstStack, output);
        }
        this.spawnCraftingResultAndXP(world, fusionShrineBlockEntity, output, maxAmount);
    }

    private void decrementIngredients(class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity, int recipesCrafted, double efficiencyModifier) {
        block0: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
            for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                if (!ingredientStack.test(currentStack)) continue;
                int reducedAmount = recipesCrafted * ingredientStack.getCount();
                int reducedAmountAfterMod = efficiencyModifier == 1.0 ? reducedAmount : Support.getIntFromDecimalWithChance((double)reducedAmount / efficiencyModifier, world.field_9229);
                class_1799 currentRemainder = currentStack.getRecipeRemainder();
                currentStack.method_7934(reducedAmountAfterMod);
                if (currentRemainder.method_7960()) continue block0;
                currentRemainder = currentRemainder.method_7972();
                currentRemainder.method_7939(reducedAmountAfterMod);
                InventoryHelper.smartAddToInventory(currentRemainder, fusionShrineBlockEntity, null);
                continue block0;
            }
        }
    }

    protected void spawnCraftingResultAndXP(@NotNull class_1937 world, @NotNull FusionShrineBlockEntity fusionShrineBlockEntity, @NotNull class_1799 stack, int recipeCount) {
        int resultAmountBeforeMod = recipeCount * stack.method_7947();
        double yieldModifier = this.yieldUpgradesDisabled ? 1.0 : (double)fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.YIELD);
        int resultAmountAfterMod = Support.getIntFromDecimalWithChance((double)resultAmountBeforeMod * yieldModifier, world.field_9229);
        int intExperience = Support.getIntFromDecimalWithChance((float)recipeCount * this.experience, world.field_9229);
        MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, fusionShrineBlockEntity.method_11016().method_10086(2), stack, resultAmountAfterMod, MultiblockCrafter.RECIPE_STACK_VELOCITY);
        if (this.experience > 0.0f) {
            MultiblockCrafter.spawnExperience(world, fusionShrineBlockEntity.method_11016(), intExperience);
        }
        fusionShrineBlockEntity.grantPlayerFusionCraftingAdvancement(stack, intExperience);
    }

    public boolean shouldPlayCraftingFinishedEffects() {
        return this.playCraftingFinishedEffects;
    }
}

